/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.content.copycat.vertical_stairs;

import com.copycatsplus.copycats.CCBlockStateProperties;
import com.copycatsplus.copycats.CCBlocks;
import com.copycatsplus.copycats.CCShapes;
import com.copycatsplus.copycats.content.copycat.stairs.CopycatStairsBlock;
import com.copycatsplus.copycats.foundation.copycat.CCWaterloggedCopycatBlock;
import com.copycatsplus.copycats.foundation.copycat.ICopycatBlock;
import com.copycatsplus.copycats.foundation.copycat.ICustomCTBlocking;
import com.copycatsplus.copycats.foundation.copycat.IStateType;
import com.copycatsplus.copycats.utility.BackportUtils;
import com.copycatsplus.copycats.utility.BlockUtils;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1750;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2510;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2760;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_4970;
import net.minecraft.class_6328;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@class_6328
public class CopycatVerticalStairBlock
extends CCWaterloggedCopycatBlock
implements ICustomCTBlocking,
IStateType {
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2754<CCBlockStateProperties.Side> SIDE = CCBlockStateProperties.SIDE;
    public static final class_2754<CCBlockStateProperties.VerticalStairShape> SHAPE = CCBlockStateProperties.VERTICAL_STAIR_SHAPE;

    public CopycatVerticalStairBlock(class_4970.class_2251 pProperties) {
        super(pProperties);
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657(SIDE, (Comparable)((Object)CCBlockStateProperties.Side.LEFT))).method_11657(SHAPE, (Comparable)((Object)CCBlockStateProperties.VerticalStairShape.STRAIGHT)));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> pBuilder) {
        super.method_9515((class_2689.class_2690<class_2248, class_2680>)pBuilder.method_11667(new class_2769[]{FACING, SIDE, SHAPE}));
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        CCBlockStateProperties.Side side;
        class_2338 blockPos = context.method_8037();
        class_2350 facing = context.method_8042();
        CCBlockStateProperties.Side side2 = side = context.method_17698().method_18043(facing.method_10170().method_10166()) - (double)context.method_8037().method_30558(facing.method_10170().method_10166()) > 0.5 ? CCBlockStateProperties.Side.RIGHT : CCBlockStateProperties.Side.LEFT;
        if (facing.method_10160().method_10171() == class_2350.class_2352.field_11056) {
            side = side.getOpposite();
        }
        class_2680 blockState = (class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)facing)).method_11657(SIDE, (Comparable)((Object)side));
        return this.withWater((class_2680)blockState.method_11657(SHAPE, (Comparable)((Object)CopycatVerticalStairBlock.getStairsShape(blockState, (class_1922)context.method_8045(), blockPos))), context);
    }

    @NotNull
    public class_265 method_9530(class_2680 state, @NotNull class_1922 level, @NotNull class_2338 pos, @NotNull class_3726 context) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        CCBlockStateProperties.Side side = (CCBlockStateProperties.Side)((Object)state.method_11654(SIDE));
        CCBlockStateProperties.VerticalStairShape shape = (CCBlockStateProperties.VerticalStairShape)((Object)state.method_11654(SHAPE));
        return CCShapes.VERTICAL_STAIR.get(facing).get((Object)side).get((Object)shape).toShape();
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 level, class_2338 pos, class_2338 neighborPos) {
        class_2680 newState = super.method_9559(state, direction, neighborState, level, pos, neighborPos);
        if (direction.method_10166() != ((class_2350)newState.method_11654((class_2769)FACING)).method_10166()) {
            return (class_2680)newState.method_11657(SHAPE, (Comparable)((Object)CopycatVerticalStairBlock.getStairsShape(newState, (class_1922)level, pos)));
        }
        return newState;
    }

    public boolean method_9526(@NotNull class_2680 pState) {
        return true;
    }

    private static CCBlockStateProperties.VerticalStairShape getStairsShape(class_2680 state, class_1922 level, class_2338 pos) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        boolean side = ((CCBlockStateProperties.Side)((Object)state.method_11654(SIDE))).isRight();
        class_2350 verticalDirection = null;
        Boolean horizontalConnection = null;
        boolean down = CopycatVerticalStairBlock.canConnect(state, level, pos, class_2350.field_11033);
        boolean downParity = CopycatVerticalStairBlock.getVerticalParity(state, level, pos, class_2350.field_11033);
        if (down && side == downParity) {
            verticalDirection = class_2350.field_11033;
        } else {
            boolean up = CopycatVerticalStairBlock.canConnect(state, level, pos, class_2350.field_11036);
            boolean upParity = CopycatVerticalStairBlock.getVerticalParity(state, level, pos, class_2350.field_11036);
            if (up && side == upParity) {
                verticalDirection = class_2350.field_11036;
            }
        }
        boolean left = CopycatVerticalStairBlock.canConnect(state, level, pos, facing.method_10160());
        boolean leftParity = CopycatVerticalStairBlock.getHorizontalParity(state, level, pos, facing.method_10160());
        if (left && (verticalDirection == null || verticalDirection == class_2350.field_11033 && side == leftParity || verticalDirection == class_2350.field_11036 && side != leftParity)) {
            horizontalConnection = false;
            if (verticalDirection == null) {
                verticalDirection = leftParity == side ? class_2350.field_11033 : class_2350.field_11036;
            }
        } else {
            boolean right = CopycatVerticalStairBlock.canConnect(state, level, pos, facing.method_10170());
            boolean rightParity = CopycatVerticalStairBlock.getHorizontalParity(state, level, pos, facing.method_10170());
            if (right && (verticalDirection == null || verticalDirection == class_2350.field_11036 && side == rightParity || verticalDirection == class_2350.field_11033 && side != rightParity)) {
                horizontalConnection = true;
                if (verticalDirection == null) {
                    class_2350 class_23502 = verticalDirection = rightParity == side ? class_2350.field_11036 : class_2350.field_11033;
                }
            }
        }
        if (horizontalConnection == null) {
            return CCBlockStateProperties.VerticalStairShape.STRAIGHT;
        }
        if (!horizontalConnection.booleanValue()) {
            if (verticalDirection == class_2350.field_11033) {
                return side ? CCBlockStateProperties.VerticalStairShape.INNER_TOP : CCBlockStateProperties.VerticalStairShape.OUTER_BOTTOM;
            }
            return side ? CCBlockStateProperties.VerticalStairShape.INNER_BOTTOM : CCBlockStateProperties.VerticalStairShape.OUTER_TOP;
        }
        if (verticalDirection == class_2350.field_11033) {
            return side ? CCBlockStateProperties.VerticalStairShape.OUTER_BOTTOM : CCBlockStateProperties.VerticalStairShape.INNER_TOP;
        }
        return side ? CCBlockStateProperties.VerticalStairShape.OUTER_TOP : CCBlockStateProperties.VerticalStairShape.INNER_BOTTOM;
    }

    private static boolean getVerticalParity(class_2680 state, class_1922 level, class_2338 pos, class_2350 face) {
        class_2680 blockState = level.method_8320(pos.method_10093(face));
        if (!(blockState.method_26204() instanceof CopycatVerticalStairBlock)) {
            return false;
        }
        return ((CCBlockStateProperties.Side)((Object)blockState.method_11654(SIDE))).isRight();
    }

    private static boolean getHorizontalParity(class_2680 state, class_1922 level, class_2338 pos, class_2350 face) {
        class_2680 blockState = level.method_8320(pos.method_10093(face));
        if (!CopycatVerticalStairBlock.isStairs(blockState)) {
            return false;
        }
        if (blockState.method_26204() instanceof CopycatVerticalStairBlock) {
            return ((class_2350)state.method_11654((class_2769)FACING)).method_10160() == face == ((CCBlockStateProperties.Side)((Object)blockState.method_11654(SIDE))).isRight();
        }
        return blockState.method_11654((class_2769)class_2510.field_11572) == class_2760.field_12619;
    }

    private static boolean canConnect(class_2680 state, class_1922 level, class_2338 pos, class_2350 face) {
        class_2350 otherFacing;
        class_2680 blockState = level.method_8320(pos.method_10093(face));
        if (!CopycatVerticalStairBlock.isStairs(blockState)) {
            return false;
        }
        if (face.method_10166().method_10178() && !(blockState.method_26204() instanceof CopycatVerticalStairBlock)) {
            return false;
        }
        class_2350 selfFacing = (class_2350)state.method_11654((class_2769)FACING);
        if (selfFacing == (otherFacing = (class_2350)blockState.method_11654((class_2769)FACING)).method_10153()) {
            return false;
        }
        if (selfFacing == otherFacing && face.method_10166() != selfFacing.method_10166()) {
            return true;
        }
        return selfFacing != otherFacing;
    }

    public static boolean isStairs(class_2680 state) {
        return state.method_26204() instanceof class_2510 || state.method_26204() instanceof CopycatVerticalStairBlock;
    }

    @Override
    public class_2680 transform(class_2680 state, StructureTransform transform) {
        if (transform.mirror != null && transform.mirror != class_2415.field_11302) {
            class_2350.class_2351 mirrorAxis = null;
            for (class_2350.class_2351 axis : Iterate.axes) {
                if (!transform.mirror.method_26380().method_26387(axis)) continue;
                mirrorAxis = axis;
                break;
            }
            if (mirrorAxis != null && !mirrorAxis.method_10178()) {
                class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
                state = facing.method_10166() != mirrorAxis ? (class_2680)state.method_28493(SIDE) : (class_2680)((class_2680)state.method_11657((class_2769)FACING, (Comparable)facing.method_10153())).method_28493(SIDE);
            }
        }
        if (transform.rotationAxis != null) {
            if (transform.rotationAxis == class_2350.class_2351.field_11052) {
                state = (class_2680)state.method_11657((class_2769)FACING, (Comparable)transform.rotateFacing((class_2350)state.method_11654((class_2769)FACING)));
            } else {
                class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
                CCBlockStateProperties.Side side = (CCBlockStateProperties.Side)((Object)state.method_11654(SIDE));
                if (facing.method_10166() != transform.rotationAxis) {
                    state = side == CCBlockStateProperties.Side.LEFT ? (class_2680)((class_2680)state.method_11657((class_2769)FACING, (Comparable)facing.method_10160())).method_28493(SIDE) : (class_2680)((class_2680)state.method_11657((class_2769)FACING, (Comparable)facing.method_10170())).method_28493(SIDE);
                }
                facing = (class_2350)state.method_11654((class_2769)FACING);
                side = (CCBlockStateProperties.Side)((Object)state.method_11654(SIDE));
                if (transform.rotation == class_2470.field_11464) {
                    state = (class_2680)state.method_28493(SIDE);
                } else if (transform.rotation != class_2470.field_11467) {
                    class_2350 offset = transform.rotateFacing(side.isRight() ? facing.method_10170() : facing.method_10160());
                    state = (class_2680)BlockUtils.tryCopyProperties(state, CCBlocks.COPYCAT_STAIRS.getDefaultState()).method_11657((class_2769)class_2510.field_11572, (Comparable)(offset == class_2350.field_11033 ? class_2760.field_12617 : class_2760.field_12619));
                }
            }
        }
        return state;
    }

    @Override
    public boolean isIgnoredConnectivitySide(class_1920 reader, class_2680 state, class_2350 face, class_2338 fromPos, class_2338 toPos) {
        boolean right = ((CCBlockStateProperties.Side)((Object)state.method_11654(SIDE))).isRight();
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        class_2680 toState = reader.method_8320(toPos);
        class_2338 diff = toPos.method_10059((class_2382)fromPos);
        if (diff.equals((Object)class_2382.field_11176)) {
            return true;
        }
        if (CopycatVerticalStairBlock.isStairs(toState)) {
            return false;
        }
        if (diff.method_30558(facing.method_10166()) == 0) {
            CopycatStairsBlock.FaceShape faceShape;
            CCBlockStateProperties.VerticalStairShape shape = (CCBlockStateProperties.VerticalStairShape)((Object)state.method_11654(SHAPE));
            int fullCount = 0;
            if (diff.method_10263() != 0) {
                faceShape = CopycatVerticalStairBlock.getFaceShape(state, class_2350.method_10169((class_2350.class_2351)class_2350.class_2351.field_11048, (class_2350.class_2352)CopycatVerticalStairBlock.directionOf(diff.method_10263())));
                if (faceShape.isFull()) {
                    ++fullCount;
                } else if ((shape == CCBlockStateProperties.VerticalStairShape.OUTER_BOTTOM || shape == CCBlockStateProperties.VerticalStairShape.OUTER_TOP) && (diff.method_10264() != 0 || diff.method_10260() != 0) && (diff.method_10263() > 0 && faceShape.topNegative && faceShape.bottomNegative || diff.method_10263() < 0 && faceShape.topPositive && faceShape.bottomPositive)) {
                    ++fullCount;
                }
            }
            if (diff.method_10264() != 0) {
                faceShape = CopycatVerticalStairBlock.getFaceShape(state, class_2350.method_10169((class_2350.class_2351)class_2350.class_2351.field_11052, (class_2350.class_2352)CopycatVerticalStairBlock.directionOf(diff.method_10264())));
                if (faceShape.isFull()) {
                    ++fullCount;
                } else if ((shape == CCBlockStateProperties.VerticalStairShape.OUTER_BOTTOM || shape == CCBlockStateProperties.VerticalStairShape.OUTER_TOP) && (diff.method_10263() != 0 || diff.method_10260() != 0) && (diff.method_10264() > 0 && faceShape.topNegative && faceShape.topPositive || diff.method_10263() < 0 && faceShape.bottomNegative && faceShape.bottomPositive)) {
                    ++fullCount;
                }
            }
            if (diff.method_10260() != 0) {
                faceShape = CopycatVerticalStairBlock.getFaceShape(state, class_2350.method_10169((class_2350.class_2351)class_2350.class_2351.field_11051, (class_2350.class_2352)CopycatVerticalStairBlock.directionOf(diff.method_10260())));
                if (faceShape.isFull()) {
                    ++fullCount;
                } else if ((shape == CCBlockStateProperties.VerticalStairShape.OUTER_BOTTOM || shape == CCBlockStateProperties.VerticalStairShape.OUTER_TOP) && (diff.method_10263() != 0 || diff.method_10264() != 0) && (diff.method_10260() > 0 && faceShape.topNegative && faceShape.bottomNegative || diff.method_10260() < 0 && faceShape.topPositive && faceShape.bottomPositive)) {
                    ++fullCount;
                }
            }
            return fullCount < class_3532.method_15382((int)diff.method_10263()) + class_3532.method_15382((int)diff.method_10264()) + class_3532.method_15382((int)diff.method_10260());
        }
        return diff.method_30558(facing.method_10166()) * (facing.method_10171() == class_2350.class_2352.field_11056 ? -1 : 1) > 0;
    }

    @Override
    public boolean canConnectTexturesToward(class_1920 reader, class_2338 fromPos, class_2338 toPos, class_2680 state) {
        class_2680 toState = reader.method_8320(toPos);
        class_2338 diff = toPos.method_10059((class_2382)fromPos);
        if (diff.equals((Object)class_2382.field_11176)) {
            return true;
        }
        class_2350 side = BackportUtils.directionFromDelta(diff.method_10263(), diff.method_10264(), diff.method_10260());
        if (side != null) {
            CopycatStairsBlock.FaceShape sideShape = CopycatVerticalStairBlock.getFaceShape(state, side);
            if (!sideShape.canConnect()) {
                return false;
            }
            if (CopycatVerticalStairBlock.isStairs(toState) ? !sideShape.equals(CopycatVerticalStairBlock.getFaceShape(toState, side.method_10153())) : !sideShape.isFull()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public Optional<Boolean> isCTBlocked(class_1920 reader, class_2680 state, class_2338 pos, class_2338 connectingPos, class_2338 blockingPos, class_2350 face) {
        if (!CopycatVerticalStairBlock.getFaceShape(state, face).canConnect()) {
            return Optional.of(false);
        }
        return Optional.empty();
    }

    @Override
    public Optional<Boolean> blockCTTowards(class_1920 reader, class_2680 state, class_2338 pos, class_2338 ctPos, class_2338 connectingPos, class_2350 face) {
        CopycatStairsBlock.FaceShape sideShape = CopycatVerticalStairBlock.getFaceShape(state, face);
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        if (!sideShape.canConnect()) {
            return Optional.of(false);
        }
        class_2680 connectingState = reader.method_8320(connectingPos);
        if (connectingState.method_27852((class_2248)this)) {
            if (sideShape.equals(CopycatVerticalStairBlock.getFaceShape(connectingState, face.method_10153()))) {
                return Optional.of(true);
            }
        } else if (sideShape.isFull()) {
            class_2680 ctState = reader.method_8320(ctPos);
            if (ctPos.method_30558(facing.method_10166()) == pos.method_30558(facing.method_10166()) || !CopycatVerticalStairBlock.isStairs(ctState) || ctState.method_28500(SIDE).orElse(null) != state.method_28500(SIDE).orElse(null) || ctState.method_28500((class_2769)class_2510.field_11572).orElse(null) != state.method_28500((class_2769)class_2510.field_11572).orElse(null)) {
                return Optional.of(true);
            }
        }
        return Optional.empty();
    }

    private static class_2350.class_2352 directionOf(int value) {
        return value >= 0 ? class_2350.class_2352.field_11056 : class_2350.class_2352.field_11060;
    }

    public boolean supportsExternalFaceHiding(class_2680 state) {
        return true;
    }

    @Override
    public boolean hidesNeighborFace(class_1922 level, class_2338 pos, class_2680 state, class_2680 neighborState, class_2350 dir) {
        return ICopycatBlock.hidesNeighborFace(level, pos, state, neighborState, dir);
    }

    public static CopycatStairsBlock.FaceShape getFaceShape(class_2680 state, class_2350 face) {
        if (!(state.method_26204() instanceof CopycatVerticalStairBlock)) {
            return CopycatStairsBlock.getFaceShape(state, face);
        }
        boolean right = ((CCBlockStateProperties.Side)((Object)state.method_11654(SIDE))).isRight();
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        CCBlockStateProperties.VerticalStairShape shape = (CCBlockStateProperties.VerticalStairShape)((Object)state.method_11654(SHAPE));
        if (face == facing) {
            return new CopycatStairsBlock.FaceShape().fillAll();
        }
        CopycatStairsBlock.FaceShape faceShape = new CopycatStairsBlock.FaceShape();
        switch (shape) {
            case STRAIGHT: {
                if (face == facing.method_10153()) {
                    return right ? faceShape.fillRight(facing) : faceShape.fillLeft(facing);
                }
                if (face == facing.method_10160()) {
                    return !right ? faceShape.fillAll() : faceShape.fillLeft(facing);
                }
                if (face == facing.method_10170()) {
                    return right ? faceShape.fillAll() : faceShape.fillRight(facing);
                }
                faceShape.fillTop();
                if (right) {
                    faceShape.fillPositive();
                } else {
                    faceShape.fillNegative();
                }
                return faceShape.rotate(facing.method_10144());
            }
            case INNER_BOTTOM: {
                if (face == facing.method_10153()) {
                    faceShape.fillBottom();
                    if (right) {
                        faceShape.fillRight(facing);
                    } else {
                        faceShape.fillLeft(facing);
                    }
                    return faceShape;
                }
                if (face == facing.method_10160()) {
                    return !right ? faceShape.fillAll() : faceShape.fillLeft(facing).fillBottom();
                }
                if (face == facing.method_10170()) {
                    return right ? faceShape.fillAll() : faceShape.fillRight(facing).fillBottom();
                }
                if (face == class_2350.field_11033) {
                    return faceShape.fillAll();
                }
                faceShape.fillTop();
                if (right) {
                    faceShape.fillPositive();
                } else {
                    faceShape.fillNegative();
                }
                return faceShape.rotate(facing.method_10144());
            }
            case INNER_TOP: {
                if (face == facing.method_10153()) {
                    faceShape.fillTop();
                    if (right) {
                        faceShape.fillRight(facing);
                    } else {
                        faceShape.fillLeft(facing);
                    }
                    return faceShape;
                }
                if (face == facing.method_10160()) {
                    return !right ? faceShape.fillAll() : faceShape.fillLeft(facing).fillTop();
                }
                if (face == facing.method_10170()) {
                    return right ? faceShape.fillAll() : faceShape.fillRight(facing).fillTop();
                }
                if (face == class_2350.field_11036) {
                    return faceShape.fillAll();
                }
                faceShape.fillTop();
                if (right) {
                    faceShape.fillPositive();
                } else {
                    faceShape.fillNegative();
                }
                return faceShape.rotate(facing.method_10144());
            }
            case OUTER_BOTTOM: {
                if (face == facing.method_10153()) {
                    return faceShape.fillBottom(right ? facing.method_10160().method_10171() : facing.method_10170().method_10171());
                }
                if (face == facing.method_10160()) {
                    return !right ? faceShape.fillLeft(facing).fillBottom() : faceShape.fillLeft(facing);
                }
                if (face == facing.method_10170()) {
                    return right ? faceShape.fillRight(facing).fillBottom() : faceShape.fillRight(facing);
                }
                if (face == class_2350.field_11036) {
                    return faceShape.fillTop().rotate(facing.method_10144());
                }
                faceShape.fillTop();
                if (right) {
                    faceShape.fillPositive();
                } else {
                    faceShape.fillNegative();
                }
                return faceShape.rotate(facing.method_10144());
            }
            case OUTER_TOP: {
                if (face == facing.method_10153()) {
                    return faceShape.fillTop(right ? facing.method_10160().method_10171() : facing.method_10170().method_10171());
                }
                if (face == facing.method_10160()) {
                    return !right ? faceShape.fillLeft(facing).fillTop() : faceShape.fillLeft(facing);
                }
                if (face == facing.method_10170()) {
                    return right ? faceShape.fillRight(facing).fillTop() : faceShape.fillRight(facing);
                }
                if (face == class_2350.field_11033) {
                    return faceShape.fillTop().rotate(facing.method_10144());
                }
                faceShape.fillTop();
                if (right) {
                    faceShape.fillPositive();
                } else {
                    faceShape.fillNegative();
                }
                return faceShape.rotate(facing.method_10144());
            }
        }
        return faceShape;
    }
}

