/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.content.copycat.bytes;

import com.copycatsplus.copycats.Copycats;
import com.copycatsplus.copycats.foundation.copycat.multistate.IMultiStateCopycatBlock;
import com.copycatsplus.copycats.foundation.copycat.multistate.IMultiStateCopycatBlockEntity;
import com.copycatsplus.copycats.foundation.copycat.multistate.WaterloggedMultiStateCopycatBlock;
import com.copycatsplus.copycats.utility.BackportUtils;
import com.google.common.collect.ImmutableMap;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.schematics.requirement.ISpecialBlockItemRequirement;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_10;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_4970;
import net.minecraft.class_4990;
import net.minecraft.class_6328;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@class_6328
public class CopycatByteBlock
extends WaterloggedMultiStateCopycatBlock
implements ISpecialBlockItemRequirement {
    public static class_2746 TOP_NE = class_2746.method_11825((String)"top_northeast");
    public static class_2746 TOP_NW = class_2746.method_11825((String)"top_northwest");
    public static class_2746 TOP_SE = class_2746.method_11825((String)"top_southeast");
    public static class_2746 TOP_SW = class_2746.method_11825((String)"top_southwest");
    public static class_2746 BOTTOM_NE = class_2746.method_11825((String)"bottom_northeast");
    public static class_2746 BOTTOM_NW = class_2746.method_11825((String)"bottom_northwest");
    public static class_2746 BOTTOM_SE = class_2746.method_11825((String)"bottom_southeast");
    public static class_2746 BOTTOM_SW = class_2746.method_11825((String)"bottom_southwest");
    private final ImmutableMap<class_2680, class_265> shapesCache;
    public static final List<Byte> allBytes = new ArrayList<Byte>(8);
    public static final Map<String, Byte> byteMap;

    public CopycatByteBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)TOP_NE, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)TOP_NW, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)TOP_SE, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)TOP_SW, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)BOTTOM_NE, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)BOTTOM_NW, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)BOTTOM_SE, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)BOTTOM_SW, (Comparable)Boolean.valueOf(false)));
        this.shapesCache = this.method_33615(CopycatByteBlock::calculateMultiFaceShape);
    }

    @Override
    public String defaultProperty() {
        return BOTTOM_NW.method_11899();
    }

    @Override
    public class_2382 vectorScale(class_2680 state) {
        return new class_2382(2, 2, 2);
    }

    @Override
    public boolean partExists(class_2680 state, String property) {
        if (property.equals(TOP_NE.method_11899())) {
            return (Boolean)state.method_11654((class_2769)TOP_NE);
        }
        if (property.equals(TOP_NW.method_11899())) {
            return (Boolean)state.method_11654((class_2769)TOP_NW);
        }
        if (property.equals(TOP_SE.method_11899())) {
            return (Boolean)state.method_11654((class_2769)TOP_SE);
        }
        if (property.equals(TOP_SW.method_11899())) {
            return (Boolean)state.method_11654((class_2769)TOP_SW);
        }
        if (property.equals(BOTTOM_NE.method_11899())) {
            return (Boolean)state.method_11654((class_2769)BOTTOM_NE);
        }
        if (property.equals(BOTTOM_NW.method_11899())) {
            return (Boolean)state.method_11654((class_2769)BOTTOM_NW);
        }
        if (property.equals(BOTTOM_SE.method_11899())) {
            return (Boolean)state.method_11654((class_2769)BOTTOM_SE);
        }
        if (property.equals(BOTTOM_SW.method_11899())) {
            return (Boolean)state.method_11654((class_2769)BOTTOM_SW);
        }
        return false;
    }

    @Override
    public Set<String> storageProperties() {
        return Set.of(TOP_NE, TOP_NW, TOP_SE, TOP_SW, BOTTOM_NE, BOTTOM_NW, BOTTOM_SE, BOTTOM_SW).stream().map(class_2769::method_11899).collect(Collectors.toSet());
    }

    @Override
    public int getColorIndex(String property) {
        Byte bite = byteMap.get(property);
        return bite.x ^ bite.y ^ bite.z ? 1 : 0;
    }

    @Override
    public String getPropertyFromInteraction(class_2680 state, class_1922 level, class_2382 hitLocation, class_2338 blockPos, class_2350 facing, class_243 unscaledHit) {
        return CopycatByteBlock.byByte(hitLocation.method_10263() > 0, hitLocation.method_10264() > 0, hitLocation.method_10260() > 0).method_11899();
    }

    @Override
    public class_2382 getVectorFromProperty(class_2680 state, String property) {
        Byte bite = byteMap.get(property);
        return new class_2382(bite.x ? 1 : 0, bite.y ? 1 : 0, bite.z ? 1 : 0);
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> pBuilder) {
        super.method_9515((class_2689.class_2690<class_2248, class_2680>)pBuilder.method_11667(new class_2769[]{TOP_NE, TOP_NW, TOP_SE, TOP_SW, BOTTOM_NE, BOTTOM_NW, BOTTOM_SE, BOTTOM_SW}));
    }

    @Override
    public boolean isIgnoredConnectivitySide(String property, class_1920 reader, class_2680 state, class_2350 face, class_2338 fromPos, class_2338 toPos) {
        class_2680 toState = reader.method_8320(toPos);
        return !toState.method_27852((class_2248)this);
    }

    @Override
    public boolean canConnectTexturesToward(String property, class_1920 reader, class_2338 fromPos, class_2338 toPos, class_2680 state) {
        class_2680 toState = reader.method_8320(toPos);
        return toState.method_27852((class_2248)this);
    }

    private static class_265 calculateMultiFaceShape(class_2680 pState) {
        class_265 shape = class_259.method_1073();
        for (Byte bite : allBytes) {
            if (!((Boolean)pState.method_11654((class_2769)CopycatByteBlock.byByte(bite))).booleanValue()) continue;
            int offsetX = bite.x ? 8 : 0;
            int offsetY = bite.y ? 8 : 0;
            int offsetZ = bite.z ? 8 : 0;
            shape = class_259.method_1084((class_265)shape, (class_265)class_2248.method_9541((double)offsetX, (double)offsetY, (double)offsetZ, (double)(offsetX + 8), (double)(offsetY + 8), (double)(offsetZ + 8)));
        }
        return shape;
    }

    @NotNull
    public class_265 method_9530(@NotNull class_2680 pState, @NotNull class_1922 pLevel, @NotNull class_2338 pPos, @NotNull class_3726 pContext) {
        class_265 shapeOverride = IMultiStateCopycatBlock.blockShapeOverride(pState, pLevel, pPos, pContext);
        if (shapeOverride != null) {
            return shapeOverride;
        }
        return Objects.requireNonNull((class_265)this.shapesCache.get((Object)pState));
    }

    public boolean method_9516(class_2680 pState, class_1922 pLevel, class_2338 pPos, class_10 pType) {
        return switch (pType) {
            case class_10.field_50 -> true;
            default -> false;
        };
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        class_2680 stateForPlacement = super.method_9605(context);
        if (stateForPlacement == null) {
            return null;
        }
        class_2338 blockPos = context.method_8037();
        class_2680 state = context.method_8045().method_8320(blockPos);
        class_243 bias = class_243.method_24954((class_2382)context.method_8038().method_10163()).method_1021(0.0625);
        class_243 biasedLocation = context.method_17698().method_1019(bias);
        if (!BackportUtils.blockPosContaining((class_2374)biasedLocation).equals((Object)context.method_8037())) {
            biasedLocation = CopycatByteBlock.clampToBlockPos(biasedLocation, context.method_8037());
        }
        Byte bite = CopycatByteBlock.getByteFromVec(biasedLocation, context.method_8037());
        if (state.method_27852((class_2248)this)) {
            if (!((Boolean)state.method_11654((class_2769)CopycatByteBlock.byByte(bite))).booleanValue()) {
                return (class_2680)state.method_11657((class_2769)CopycatByteBlock.byByte(bite), (Comparable)Boolean.valueOf(true));
            }
            if (!((Boolean)state.method_11654((class_2769)CopycatByteBlock.byByte(bite = bite.relative(context.method_8038())))).booleanValue()) {
                return (class_2680)state.method_11657((class_2769)CopycatByteBlock.byByte(bite), (Comparable)Boolean.valueOf(true));
            }
            Copycats.LOGGER.warn("Can't figure out where to place a byte! Please file an issue if you see this.");
            return state;
        }
        return (class_2680)stateForPlacement.method_11657((class_2769)CopycatByteBlock.byByte(bite), (Comparable)Boolean.valueOf(true));
    }

    public boolean method_9616(@NotNull class_2680 pState, class_1750 pUseContext) {
        Byte bite;
        class_1799 itemstack = pUseContext.method_8041();
        if (!itemstack.method_31574(this.method_8389())) {
            return false;
        }
        class_243 bias = class_243.method_24954((class_2382)pUseContext.method_8038().method_10163()).method_1021(0.0625);
        class_243 biasedLocation = pUseContext.method_17698().method_1019(bias);
        if (!BackportUtils.blockPosContaining((class_2374)biasedLocation).equals((Object)pUseContext.method_8037())) {
            biasedLocation = CopycatByteBlock.clampToBlockPos(biasedLocation, pUseContext.method_8037());
        }
        return (Boolean)pState.method_11654((class_2769)CopycatByteBlock.byByte(bite = CopycatByteBlock.getByteFromVec(biasedLocation, pUseContext.method_8037()))) == false;
    }

    @Override
    public class_1269 onSneakWrenched(class_2680 state, class_1838 context) {
        this.onWrenched(state, context);
        int byteCount = 0;
        for (Byte bite : allBytes) {
            if (!((Boolean)state.method_11654((class_2769)CopycatByteBlock.byByte(bite))).booleanValue()) continue;
            ++byteCount;
        }
        if (byteCount <= 1) {
            return super.onSneakWrenched(state, context);
        }
        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();
        class_1657 player = context.method_8036();
        class_243 bias = class_243.method_24954((class_2382)context.method_8038().method_10163()).method_1021(-0.0625);
        Byte bite = CopycatByteBlock.getByteFromVec(context.method_17698().method_1019(bias), context.method_8037());
        if (world instanceof class_3218) {
            if (player != null) {
                List drops = class_2248.method_9609((class_2680)((class_2680)this.method_9564().method_11657((class_2769)CopycatByteBlock.byByte(bite), (Comparable)Boolean.valueOf(true))), (class_3218)((class_3218)world), (class_2338)pos, (class_2586)world.method_8321(pos), (class_1297)player, (class_1799)context.method_8041());
                if (!player.method_7337()) {
                    for (class_1799 drop : drops) {
                        player.method_31548().method_7398(drop);
                    }
                }
            }
            class_2338 up = pos.method_10093(class_2350.field_11036);
            world.method_8501(pos, ((class_2680)state.method_11657((class_2769)CopycatByteBlock.byByte(bite), (Comparable)Boolean.valueOf(false))).method_26191(class_2350.field_11036, world.method_8320(up), (class_1936)world, pos, up));
            this.playRemoveSound(world, pos);
        }
        return class_1269.field_5812;
    }

    public ItemRequirement getRequiredItems(class_2680 state, class_2586 blockEntity) {
        return IMultiStateCopycatBlock.getRequiredItemsForParts(state, TOP_NE, TOP_NW, TOP_SE, TOP_SW, BOTTOM_NE, BOTTOM_NW, BOTTOM_SE, BOTTOM_SW);
    }

    public boolean supportsExternalFaceHiding(class_2680 state) {
        return true;
    }

    @Override
    public boolean hidesNeighborFace(class_1922 level, class_2338 pos, class_2680 state, class_2680 neighborState, class_2350 dir) {
        return IMultiStateCopycatBlock.hidesNeighborFace(level, pos, state, neighborState, dir);
    }

    @Override
    public class_2680 transform(class_2680 state, StructureTransform transform) {
        return this.mapBytes(state, bite -> CopycatByteBlock.transformByte(transform, bite));
    }

    @Override
    public void transformStorage(class_2680 state, IMultiStateCopycatBlockEntity be, StructureTransform transform) {
        be.getMaterialItemStorage().remapStorage(key -> CopycatByteBlock.byByte(CopycatByteBlock.transformByte(transform, byteMap.get(key))).method_11899());
    }

    private static Byte transformByte(StructureTransform transform, Byte bite) {
        if (transform.mirror != null && transform.mirror != class_2415.field_11302) {
            bite = bite.mirror(transform.mirror);
        }
        if (transform.rotationAxis != null) {
            bite = switch (transform.rotationAxis) {
                default -> throw new IncompatibleClassChangeError();
                case class_2350.class_2351.field_11048 -> bite.rotateX(transform.rotation);
                case class_2350.class_2351.field_11052 -> bite.rotateY(transform.rotation);
                case class_2350.class_2351.field_11051 -> bite.rotateZ(transform.rotation);
            };
        }
        return bite;
    }

    public static class_243 clampToBlockPos(class_243 vec, class_2338 pos) {
        return new class_243(class_3532.method_15350((double)vec.field_1352, (double)pos.method_10263(), (double)(pos.method_10263() + 1)), class_3532.method_15350((double)vec.field_1351, (double)pos.method_10264(), (double)(pos.method_10264() + 1)), class_3532.method_15350((double)vec.field_1350, (double)pos.method_10260(), (double)(pos.method_10260() + 1)));
    }

    public static Byte getByteFromVec(class_243 vec, class_2338 pos) {
        vec = vec.method_1023((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
        return CopycatByteBlock.bite(vec.field_1352 > 0.5, vec.field_1351 > 0.5, vec.field_1350 > 0.5);
    }

    private class_2680 mapBytes(class_2680 state, Function<Byte, Byte> mapper) {
        class_2680 blockstate = state;
        for (Byte bite : allBytes) {
            blockstate = (class_2680)blockstate.method_11657((class_2769)CopycatByteBlock.byByte(mapper.apply(bite)), (Comparable)((Boolean)state.method_11654((class_2769)CopycatByteBlock.byByte(bite))));
        }
        return blockstate;
    }

    public static Byte bite(boolean x, boolean y, boolean z) {
        return new Byte(x, y, z);
    }

    public static class_2746 byByte(Byte bite) {
        return CopycatByteBlock.byByte(bite.x, bite.y, bite.z);
    }

    public static class_2746 byByte(boolean x, boolean y, boolean z) {
        if (y) {
            if (x) {
                if (z) {
                    return TOP_SE;
                }
                return TOP_NE;
            }
            if (z) {
                return TOP_SW;
            }
            return TOP_NW;
        }
        if (x) {
            if (z) {
                return BOTTOM_SE;
            }
            return BOTTOM_NE;
        }
        if (z) {
            return BOTTOM_SW;
        }
        return BOTTOM_NW;
    }

    static {
        for (boolean x : Iterate.falseAndTrue) {
            for (boolean y : Iterate.falseAndTrue) {
                for (boolean z : Iterate.falseAndTrue) {
                    allBytes.add(CopycatByteBlock.bite(x, y, z));
                }
            }
        }
        byteMap = allBytes.stream().collect(Collectors.toMap(b -> CopycatByteBlock.byByte(b).method_11899(), b -> b));
    }

    public record Byte(boolean x, boolean y, boolean z) {
        public Byte copy() {
            return new Byte(this.x, this.y, this.z);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Byte) {
                Byte other = (Byte)obj;
                return this.x == other.x && this.y == other.y && this.z == other.z;
            }
            return false;
        }

        public Byte set(class_2350.class_2351 axis, boolean value) {
            return switch (axis) {
                default -> throw new IncompatibleClassChangeError();
                case class_2350.class_2351.field_11048 -> new Byte(value, this.y, this.z);
                case class_2350.class_2351.field_11052 -> new Byte(this.x, value, this.z);
                case class_2350.class_2351.field_11051 -> new Byte(this.x, this.y, value);
            };
        }

        public boolean get(class_2350.class_2351 axis) {
            return switch (axis) {
                default -> throw new IncompatibleClassChangeError();
                case class_2350.class_2351.field_11048 -> this.x;
                case class_2350.class_2351.field_11052 -> this.y;
                case class_2350.class_2351.field_11051 -> this.z;
            };
        }

        public Byte relative(class_2350 direction) {
            return this.set(direction.method_10166(), !this.get(direction.method_10166()));
        }

        public Byte rotateX(class_2470 rotation) {
            if (rotation == class_2470.field_11463) {
                return new Byte(this.x, this.z, !this.y);
            }
            if (rotation == class_2470.field_11464) {
                return new Byte(this.x, this.y, this.z);
            }
            if (rotation == class_2470.field_11465) {
                return new Byte(this.x, !this.z, this.y);
            }
            return this;
        }

        public Byte rotateY(class_2470 rotation) {
            if (rotation == class_2470.field_11463) {
                return new Byte(!this.z, this.y, this.x);
            }
            if (rotation == class_2470.field_11464) {
                return new Byte(!this.x, this.y, !this.z);
            }
            if (rotation == class_2470.field_11465) {
                return new Byte(this.z, this.y, !this.x);
            }
            return this;
        }

        public Byte rotateZ(class_2470 rotation) {
            if (rotation == class_2470.field_11463) {
                return new Byte(this.y, !this.x, this.z);
            }
            if (rotation == class_2470.field_11464) {
                return new Byte(this.x, this.y, this.z);
            }
            if (rotation == class_2470.field_11465) {
                return new Byte(!this.y, this.x, this.z);
            }
            return this;
        }

        public Byte mirror(class_2415 mirror) {
            boolean invertX = mirror.method_26380() == class_4990.field_23323;
            boolean invertY = mirror.method_26380() == class_4990.field_23266;
            boolean invertZ = mirror.method_26380() == class_4990.field_23267;
            return new Byte(invertX != this.x, invertY != this.y, invertZ != this.z);
        }

        @Override
        public int hashCode() {
            return Byte.i(this.x) + Byte.i(this.y) << 1 + Byte.i(this.z) << 2;
        }

        private static int i(boolean b) {
            return b ? 1 : 0;
        }

        @Override
        public String toString() {
            return "(" + this.x + ", " + this.y + ", " + this.z + ")";
        }
    }
}

