/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.core.pick;

import java.util.List;
import java.util.Objects;
import mcp.mobius.waila.api.IObjectPicker;
import mcp.mobius.waila.api.IPickerAccessor;
import mcp.mobius.waila.api.IPickerResults;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.WailaConstants;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3610;
import net.minecraft.class_3902;
import net.minecraft.class_3965;
import net.minecraft.class_3966;

public enum ObjectPicker implements IObjectPicker
{
    INSTANCE;


    @Override
    public void pick(IPickerAccessor accessor, IPickerResults results, IPluginConfig config) {
        class_1297 camera = accessor.getCameraEntity();
        if (camera == null) {
            return;
        }
        boolean showBlock = config.getBoolean(WailaConstants.CONFIG_SHOW_BLOCK);
        boolean showFluid = config.getBoolean(WailaConstants.CONFIG_SHOW_FLUID);
        boolean showEntity = config.getBoolean(WailaConstants.CONFIG_SHOW_ENTITY);
        if (!(showBlock || showFluid || showEntity)) {
            return;
        }
        float frameDelta = accessor.getFrameDelta();
        double maxDistance = accessor.getMaxDistance();
        class_243 viewVec = camera.method_5828(frameDelta);
        class_243 start = camera.method_5836(frameDelta);
        class_243 end = start.method_1031(viewVec.field_1352 * maxDistance, viewVec.field_1351 * maxDistance, viewVec.field_1350 * maxDistance);
        class_1937 world = camera.method_37908();
        if (showBlock || showFluid) {
            class_1922.method_17744((class_243)start, (class_243)end, (Object)class_3902.field_17274, (unit, pos) -> {
                class_265 fluidShape;
                class_3965 fluidHit;
                class_3610 fluidState;
                class_2680 blockState;
                if (showBlock && !(blockState = world.method_8320(pos)).method_26215()) {
                    class_265 blockShape = blockState.method_26218((class_1922)world, pos);
                    class_3965 blockHit = world.method_17745(start, end, pos.method_10062(), blockShape, blockState);
                    if (blockHit != null) {
                        results.add((class_239)blockHit, start.method_1025(blockHit.method_17784()));
                    }
                }
                if (showFluid && (fluidState = world.method_8316(pos)).method_15771() && (fluidHit = (fluidShape = fluidState.method_17776((class_1922)world, pos)).method_1092(start, end, pos)) != null) {
                    results.add((class_239)fluidHit, start.method_1025(fluidHit.method_17784()));
                }
                return null;
            }, unit -> unit);
        }
        if (showEntity) {
            List entities = camera.field_6002.method_8333(camera, new class_238(start, end), class_1301.field_6154);
            for (class_1297 entity : entities) {
                class_238 bounds = entity.method_5829();
                class_243 clip = bounds.method_992(start, end).orElse(null);
                if (bounds.method_1006(start)) {
                    clip = Objects.requireNonNullElse(clip, start);
                }
                if (clip == null) continue;
                results.add((class_239)new class_3966(entity, clip), start.method_1025(clip));
            }
        }
    }
}

