/*
 * Decompiled with CFR 0.152.
 */
package me.duquee.createutilities.ponder;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllFluids;
import com.simibubi.create.foundation.ponder.ElementLink;
import com.simibubi.create.foundation.ponder.SceneBuilder;
import com.simibubi.create.foundation.ponder.SceneBuildingUtil;
import com.simibubi.create.foundation.ponder.Selection;
import com.simibubi.create.foundation.ponder.element.InputWindowElement;
import com.simibubi.create.foundation.ponder.instruction.PonderInstruction;
import com.simibubi.create.foundation.utility.Pointing;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import java.util.function.Consumer;
import me.duquee.createutilities.blocks.voidtypes.battery.VoidBatteryTileEntity;
import me.duquee.createutilities.blocks.voidtypes.chest.VoidChestTileEntity;
import me.duquee.createutilities.blocks.voidtypes.motor.VoidMotorTileEntity;
import me.duquee.createutilities.blocks.voidtypes.tank.VoidTankTileEntity;
import me.duquee.createutilities.ponder.ParallelInstruction;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_3611;
import net.minecraft.class_3612;

public class VoidScenes {
    public static void voidMotor(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("void_motor", "Using Void Motors");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.world.showSection(util.select.position(5, 0, 2), class_2350.field_11036);
        Selection source = util.select.fromTo(5, 1, 1, 4, 1, 1);
        Selection receiver = util.select.fromTo(1, 1, 2, 2, 1, 2);
        scene.world.showSection(source, class_2350.field_11033);
        scene.idle(10);
        scene.world.showSection(receiver, class_2350.field_11033);
        scene.idle(10);
        class_2338 sourcePos = util.grid.at(4, 1, 1);
        class_2338 receiverPos = util.grid.at(1, 1, 2);
        VoidScenes.playVoidSequence(scene, util, VoidMotorTileEntity.class, 0.015f, 0.0f, "Void Motor", "Rotational Force", sourcePos, receiverPos, class_2350.field_11039, class_2350.field_11039, pos -> scene.world.setKineticSpeed(receiver, 0.0f), pos -> scene.world.setKineticSpeed(receiver, -32.0f), false, false);
    }

    public static void voidChest(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("void_chest", "Using Void Chests");
        scene.configureBasePlate(1, 0, 5);
        scene.showBasePlate();
        scene.world.showSection(util.select.position(0, 0, 3).add(util.select.position(6, 0, 3)), class_2350.field_11036);
        Selection source = util.select.fromTo(4, 1, 0, 6, 2, 3);
        Selection receiver = util.select.fromTo(0, 1, 0, 2, 2, 3);
        scene.idle(10);
        scene.world.showSection(source, class_2350.field_11033);
        scene.world.showSection(receiver, class_2350.field_11033);
        scene.idle(10);
        ParallelInstruction parallel = new ParallelInstruction(scene);
        class_2338 sourceEntryBelt = util.grid.at(4, 1, 0);
        class_2338 sourceExitBelt = util.grid.at(4, 1, 2);
        class_2338 receiverEntryBelt = util.grid.at(2, 1, 2);
        class_1799 stack = AllBlocks.BRASS_BLOCK.asStack();
        class_243 motion = new class_243(0.0, -0.2, 0.0);
        for (int i = 0; i < 30; ++i) {
            if (i < 27) {
                ElementLink item = parallel.scene.world.createItemEntity(util.vector.of(4.75, 3.0, 0.5), motion, stack);
                parallel.scene.idle(5);
                parallel.scene.world.modifyEntity(item, class_1297::method_31472);
                parallel.scene.world.createItemOnBelt(sourceEntryBelt, class_2350.field_11034, stack);
                parallel.scene.idle(16);
                parallel.scene.world.removeItemsFromBelt(sourceExitBelt);
                parallel.scene.world.flapFunnel(sourceExitBelt.method_10084(), false);
                if (i < 6 || i > 21) {
                    parallel.scene.world.createItemOnBelt(receiverEntryBelt, class_2350.field_11034, stack);
                    parallel.scene.world.flapFunnel(receiverEntryBelt.method_10084(), true);
                }
            } else {
                parallel.scene.idle(21);
            }
            parallel.scene.world.modifyEntities(class_1542.class, entity -> {
                if (entity.method_19538().field_1351 < 1.0) {
                    entity.method_31472();
                }
            });
        }
        scene.addInstruction((PonderInstruction)parallel);
        class_2338 sourcePos = util.grid.at(4, 2, 3);
        class_2338 receiverPos = util.grid.at(2, 2, 3);
        VoidScenes.playVoidSequence(scene, util, VoidChestTileEntity.class, -0.0475f, -0.1875f, "Void Chest", "Items", sourcePos, receiverPos, class_2350.field_11035, class_2350.field_11035, pos -> {}, pos -> {}, true, false);
    }

    public static void voidTank(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("void_tank", "Using Void Tanks");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        Selection pipes = util.select.fromTo(1, 0, 5, 3, 1, 5).add(util.select.fromTo(1, 1, 4, 3, 1, 4));
        class_2338 sourcePos = util.grid.at(1, 1, 3);
        class_2338 secSourcePos = util.grid.at(3, 1, 3);
        class_2338 receiverPos = util.grid.at(2, 1, 1);
        Selection source = util.select.position(sourcePos);
        Selection secSource = util.select.position(secSourcePos);
        Selection receiver = util.select.position(receiverPos);
        scene.world.modifyBlockEntity(sourcePos, VoidTankTileEntity.class, te -> te.getFluidStorage().setFluid(FluidStack.EMPTY));
        scene.world.modifyBlockEntity(secSourcePos, VoidTankTileEntity.class, te -> te.getFluidStorage().setFluid(FluidStack.EMPTY));
        scene.idle(10);
        scene.world.showSection(pipes, class_2350.field_11043);
        scene.world.showSection(source, class_2350.field_11035);
        scene.world.showSection(secSource, class_2350.field_11035);
        scene.idle(10);
        scene.world.showSection(receiver, class_2350.field_11033);
        scene.idle(10);
        ParallelInstruction parallel = new ParallelInstruction(scene);
        FluidStack honey = new FluidStack((class_3611)AllFluids.HONEY.get(), 54000L);
        FluidStack lava = new FluidStack((class_3611)class_3612.field_15908, 54000L);
        for (int i = 0; i < 8; ++i) {
            parallel.scene.world.modifyBlockEntity(sourcePos, VoidTankTileEntity.class, te -> TransferUtil.insertFluid((Storage)te.getFluidStorage(), (FluidStack)honey));
            parallel.scene.world.modifyBlockEntity(secSourcePos, VoidTankTileEntity.class, te -> TransferUtil.insertFluid((Storage)te.getFluidStorage(), (FluidStack)lava));
            parallel.scene.idle(15);
        }
        scene.addInstruction((PonderInstruction)parallel);
        VoidScenes.playVoidSequence(scene, util, VoidTankTileEntity.class, 0.015f, 0.0f, "Void Tank", "Fluids", sourcePos, receiverPos, class_2350.field_11036, class_2350.field_11036, pos -> {}, pos -> scene.world.modifyBlockEntity(pos, VoidTankTileEntity.class, te -> {
            lava.setAmount(432000L);
            te.getFluidStorage().setFluid(lava);
        }), false, true);
    }

    public static void voidBattery(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("void_battery", "Using Void Batteries");
        scene.showBasePlate();
        class_2338 sourcePos = util.grid.at(3, 1, 2);
        class_2338 receiverPos = util.grid.at(1, 1, 2);
        scene.world.showSection(util.select.position(sourcePos), class_2350.field_11033);
        scene.idle(10);
        scene.world.showSection(util.select.position(receiverPos), class_2350.field_11033);
        scene.idle(10);
        VoidScenes.playVoidSequence(scene, util, VoidBatteryTileEntity.class, -0.0475f, -0.1875f, "Void Battery", "Energy", sourcePos, receiverPos, class_2350.field_11035, class_2350.field_11035, pos -> {}, pos -> {}, true, false);
    }

    private static void playVoidSequence(SceneBuilder scene, SceneBuildingUtil util, Class<? extends class_2586> beType, float shift, float yOffset, String blockName, String transmittedName, class_2338 firstPos, class_2338 secondPos, class_2350 firstDirection, class_2350 secondDirection, Consumer<class_2338> onDisconnect, Consumer<class_2338> onConnect, boolean rotate, boolean isTank) {
        Selection firstBlock = util.select.position(firstPos);
        class_243 firstVec = util.vector.blockSurface(firstPos, firstDirection);
        Selection secondBlock = util.select.position(secondPos);
        class_243 secondVec = util.vector.blockSurface(secondPos, secondDirection);
        scene.overlay.showText(50).text(blockName + " can transmit " + transmittedName + " across distances").pointAt(firstVec);
        scene.idle(50);
        if (rotate) {
            scene.rotateCameraY(-90.0f);
        }
        scene.addKeyframe();
        class_243 firstBackFreq = VoidScenes.getFirstFrequency(firstVec, firstDirection, shift, yOffset);
        class_243 firstFrontFreq = VoidScenes.getLastFrequency(firstVec, firstDirection, shift, yOffset);
        class_243 firstOwner = VoidScenes.getOwner(firstVec, firstDirection, shift, yOffset);
        class_243 secondBackFreq = VoidScenes.getFirstFrequency(secondVec, secondDirection, shift, yOffset);
        class_243 secondFrontFreq = VoidScenes.getLastFrequency(secondVec, secondDirection, shift, yOffset);
        scene.idle(10);
        scene.overlay.showFilterSlotInput(firstBackFreq, firstDirection, 100);
        scene.overlay.showFilterSlotInput(firstFrontFreq, firstDirection, 100);
        scene.idle(10);
        scene.overlay.showText(50).text("Placing items in the two upper slots can specify a Frequency").placeNearTarget().pointAt(firstFrontFreq);
        scene.idle(60);
        class_1799 iron = new class_1799((class_1935)class_1802.field_8620);
        class_1799 sapling = new class_1799((class_1935)class_1802.field_17535);
        VoidScenes.showFrequency(scene, firstBlock, beType, firstFrontFreq, "FrequencyLast", Pointing.LEFT, iron);
        onDisconnect.accept(secondPos);
        VoidScenes.showFrequency(scene, firstBlock, beType, firstBackFreq, "FrequencyFirst", Pointing.RIGHT, sapling);
        if (isTank) {
            onConnect.accept(firstPos);
        }
        scene.idle(30);
        scene.addKeyframe();
        scene.idle(10);
        scene.overlay.showFilterSlotInput(firstOwner, firstDirection, 100);
        scene.idle(10);
        scene.overlay.showControls(new InputWindowElement(firstOwner, Pointing.UP).rightClick(), 40);
        scene.idle(7);
        scene.world.modifyBlockEntityNBT(firstBlock, beType, nbt -> nbt.method_10551("Owner"));
        scene.overlay.showText(50).text("Right-click the bottom slot to unclaim the " + blockName).placeNearTarget().pointAt(firstOwner);
        scene.idle(60);
        scene.overlay.showControls(new InputWindowElement(firstOwner, Pointing.UP).rightClick(), 40);
        scene.idle(7);
        scene.world.restoreBlocks(firstBlock);
        scene.world.modifyBlockEntityNBT(firstBlock, beType, nbt -> {
            nbt.method_10566("FrequencyFirst", (class_2520)sapling.method_7953(new class_2487()));
            nbt.method_10566("FrequencyLast", (class_2520)iron.method_7953(new class_2487()));
        });
        if (isTank) {
            onConnect.accept(firstPos);
        }
        scene.overlay.showText(50).text("Right-click it again to re-claim it").placeNearTarget().pointAt(firstOwner);
        scene.idle(60);
        scene.overlay.showText(50).text("If a " + blockName + " is claimed, only it's owner is able to edit it's Frequency").placeNearTarget().pointAt(firstVec);
        scene.idle(60);
        scene.addKeyframe();
        scene.idle(10);
        scene.overlay.showText(60).text("A " + blockName + " will only receive " + transmittedName + " from " + blockName + "s with the same Frequency and Owner").placeNearTarget().pointAt(secondVec);
        scene.idle(70);
        VoidScenes.showFrequency(scene, secondBlock, beType, secondFrontFreq, "FrequencyLast", Pointing.LEFT, iron);
        VoidScenes.showFrequency(scene, secondBlock, beType, secondBackFreq, "FrequencyFirst", Pointing.RIGHT, sapling);
        onConnect.accept(secondPos);
        if (rotate) {
            scene.idle(20);
            scene.rotateCameraY(90.0f);
            scene.idle(30);
        } else {
            scene.idle(50);
        }
    }

    private static void showFrequency(SceneBuilder scene, Selection block, Class<? extends class_2586> beType, class_243 slotPos, String slotId, Pointing pointing, class_1799 item) {
        scene.overlay.showControls(new InputWindowElement(slotPos, pointing).withItem(item), 30);
        scene.idle(7);
        scene.world.modifyBlockEntityNBT(block, beType, nbt -> nbt.method_10566(slotId, (class_2520)item.method_7953(new class_2487())));
    }

    private static class_243 getFirstFrequency(class_243 faceVec, class_2350 face, float shift, float yOffset) {
        return switch (face) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11043 -> faceVec.method_1031(0.15625, (double)(0.15625f + yOffset), (double)(-shift));
            case class_2350.field_11034 -> faceVec.method_1031((double)shift, (double)(0.15625f + yOffset), 0.15625);
            case class_2350.field_11035 -> faceVec.method_1031(-0.15625, (double)(0.15625f + yOffset), (double)shift);
            case class_2350.field_11039 -> faceVec.method_1031((double)(-shift), (double)(0.15625f + yOffset), -0.15625);
            case class_2350.field_11036 -> faceVec.method_1031((double)(0.15625f + yOffset), (double)shift, -0.15625);
            case class_2350.field_11033 -> faceVec.method_1031((double)(0.15625f + yOffset), (double)(-shift), 0.15625);
        };
    }

    private static class_243 getLastFrequency(class_243 faceVec, class_2350 face, float shift, float yOffset) {
        return switch (face) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11043 -> faceVec.method_1031(-0.15625, (double)(0.15625f + yOffset), (double)(-shift));
            case class_2350.field_11034 -> faceVec.method_1031((double)shift, (double)(0.15625f + yOffset), -0.15625);
            case class_2350.field_11035 -> faceVec.method_1031(0.15625, (double)(0.15625f + yOffset), (double)shift);
            case class_2350.field_11039 -> faceVec.method_1031((double)(-shift), (double)(0.15625f + yOffset), 0.15625);
            case class_2350.field_11036 -> faceVec.method_1031((double)(0.15625f + yOffset), (double)shift, 0.15625);
            case class_2350.field_11033 -> faceVec.method_1031((double)(0.15625f + yOffset), (double)(-shift), -0.15625);
        };
    }

    private static class_243 getOwner(class_243 faceVec, class_2350 face, float shift, float yOffset) {
        return switch (face) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11043 -> faceVec.method_1031(0.0, (double)(-0.15625f + yOffset), (double)(-shift));
            case class_2350.field_11034 -> faceVec.method_1031((double)shift, (double)(-0.15625f + yOffset), 0.0);
            case class_2350.field_11035 -> faceVec.method_1031(0.0, (double)(-0.15625f + yOffset), (double)shift);
            case class_2350.field_11039 -> faceVec.method_1031((double)(-shift), (double)(-0.15625f + yOffset), 0.0);
            case class_2350.field_11036 -> faceVec.method_1031((double)(-0.15625f + yOffset), (double)shift, 0.0);
            case class_2350.field_11033 -> faceVec.method_1031((double)(-0.15625f + yOffset), (double)(-shift), 0.0);
        };
    }
}

