/*
 * Decompiled with CFR 0.152.
 */
package me.duquee.createutilities.ponder;

import com.simibubi.create.foundation.ponder.PonderScene;
import com.simibubi.create.foundation.ponder.SceneBuilder;
import com.simibubi.create.foundation.ponder.instruction.PonderInstruction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import me.duquee.createutilities.mixins.SceneBuilderAccessor;
import me.duquee.createutilities.ponder.ParallelSceneBuilder;

public class ParallelInstruction
extends PonderInstruction {
    private final List<PonderInstruction> schedule = new ArrayList<PonderInstruction>();
    private final List<PonderInstruction> activeSchedule = new ArrayList<PonderInstruction>();
    public final ParallelSceneBuilder scene;

    public ParallelInstruction(SceneBuilder scene) {
        PonderScene ponderScene = ((SceneBuilderAccessor)scene).getScene();
        this.scene = new ParallelSceneBuilder(ponderScene, this);
    }

    public void reset(PonderScene scene) {
        super.reset(scene);
        this.activeSchedule.clear();
        this.schedule.forEach(mdi -> mdi.reset(scene));
    }

    public boolean isComplete() {
        return this.activeSchedule.isEmpty();
    }

    public void onScheduled(PonderScene scene) {
        this.activeSchedule.addAll(this.schedule);
    }

    public void tick(PonderScene scene) {
        Iterator<PonderInstruction> iterator = this.activeSchedule.iterator();
        while (iterator.hasNext()) {
            PonderInstruction instruction = iterator.next();
            instruction.tick(scene);
            if (instruction.isComplete()) {
                iterator.remove();
                if (!instruction.isBlocking()) continue;
                break;
            }
            if (!instruction.isBlocking()) continue;
            break;
        }
    }

    public void addInstruction(PonderInstruction instruction) {
        this.schedule.add(instruction);
    }
}

