/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.block.entity;

import com.tom.createores.block.entity.ExcavatingBlockEntity;
import com.tom.createores.recipe.ExtractorRecipe;
import com.tom.createores.util.IOBlockType;
import io.github.fabricators_of_create.porting_lib.transfer.fluid.FluidTank;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public class ExtractorBlockEntity
extends ExcavatingBlockEntity<ExtractorRecipe> {
    private Tank fluidTank = new Tank();

    public ExtractorBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public <T> Storage<T> getCaps(IOBlockType type) {
        if (type == IOBlockType.FLUID_OUT) {
            return this.fluidTank;
        }
        return null;
    }

    @Override
    protected boolean instanceofCheck(Object rec) {
        return rec instanceof ExtractorRecipe;
    }

    @Override
    protected boolean canExtract() {
        return this.fluidTank.fillInternal(((ExtractorRecipe)this.current).getOutput(), true) == ((ExtractorRecipe)this.current).getOutput().getAmount();
    }

    @Override
    protected void onFinished() {
        this.fluidTank.fillInternal(((ExtractorRecipe)this.current).getOutput(), false);
    }

    @Override
    protected void read(class_2487 tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.fluidTank.readFromNBT(tag.method_10562("tank"));
    }

    @Override
    protected void write(class_2487 tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.method_10566("tank", (class_2520)this.fluidTank.writeToNBT(new class_2487()));
    }

    @Override
    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        this.containedFluidTooltip(tooltip, isPlayerSneaking, (Storage)this.fluidTank);
        return true;
    }

    private class Tank
    extends FluidTank {
        public Tank() {
            super(1296000L);
        }

        protected void onContentsChanged() {
            ExtractorBlockEntity.this.notifyUpdate();
        }

        public long insert(FluidVariant insertedVariant, long maxAmount, TransactionContext transaction) {
            return 0L;
        }

        public long fillInternal(FluidStack resource, boolean simulate) {
            long f;
            try (Transaction t = Transaction.openOuter();){
                f = super.insert(resource.getType(), resource.getAmount(), (TransactionContext)t);
                if (simulate) {
                    t.abort();
                } else {
                    t.commit();
                }
            }
            return f;
        }
    }
}

