/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.block.entity;

import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.tom.createores.CreateOreExcavation;
import com.tom.createores.OreDataCapability;
import com.tom.createores.block.entity.IDrill;
import com.tom.createores.block.entity.MultiblockCapHandler;
import com.tom.createores.client.ClientUtil;
import com.tom.createores.recipe.ExcavatingRecipe;
import com.tom.createores.recipe.IRecipe;
import com.tom.createores.util.NumberFormatter;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public abstract class ExcavatingBlockEntity<R extends ExcavatingRecipe>
extends SmartBlockEntity
implements MultiblockCapHandler,
IDrill {
    protected int progress;
    protected MultiblockCapHandler.Kinetic kinetic;
    protected class_2960 recipeClient;
    protected long resourceRemClient;
    protected boolean hasRotation;
    protected class_1799 drillStack;
    protected R current;
    protected OreDataCapability.OreData data;
    protected ExcavatorState state = ExcavatorState.NO_VEIN;

    protected ExcavatingBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.drillStack = class_1799.field_8037;
        this.setLazyTickRate(20);
    }

    protected abstract boolean instanceofCheck(Object var1);

    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        ExcavatingRecipe rec = this.recipeClient != null ? (ExcavatingRecipe)this.field_11863.method_8433().method_8130(this.recipeClient).filter(this::instanceofCheck).map(r -> (ExcavatingRecipe)r).orElse(null) : null;
        class_2561 vein = rec != null ? rec.getName() : class_2561.method_43471((String)"chat.coe.veinFinder.nothing");
        tooltip.add((class_2561)class_2561.method_43470((String)"    ").method_10852((class_2561)class_2561.method_43469((String)"chat.coe.veinFinder.found", (Object[])new Object[]{vein})));
        if (!this.hasRotation) {
            tooltip.add((class_2561)componentSpacing.method_27662().method_10852((class_2561)Lang.translateDirect((String)"tooltip.speedRequirement", (Object[])new Object[0]).method_27692(class_124.field_1065)));
            class_5250 hint = Lang.translateDirect((String)"gui.contraptions.not_fast_enough", (Object[])new Object[]{class_1074.method_4662((String)this.method_11010().method_26204().method_9539(), (Object[])new Object[0])});
            List cutString = TooltipHelper.cutTextComponent((class_2561)hint, (TooltipHelper.Palette)TooltipHelper.Palette.GRAY_AND_WHITE);
            for (int i = 0; i < cutString.size(); ++i) {
                tooltip.add((class_2561)componentSpacing.method_27662().method_10852((class_2561)cutString.get(i)));
            }
        }
        if (this.drillStack.method_7960()) {
            tooltip.add((class_2561)class_2561.method_43470((String)"    ").method_10852((class_2561)class_2561.method_43471((String)"info.coe.drill.noDrill")));
        } else {
            tooltip.add((class_2561)class_2561.method_43470((String)"    ").method_10852((class_2561)class_2561.method_43469((String)"info.coe.drill.installed", (Object[])new Object[]{this.drillStack.method_7964()})));
        }
        if (rec != null) {
            tooltip.add((class_2561)class_2561.method_43470((String)"    ").method_10852((class_2561)class_2561.method_43471((String)"info.coe.drill.progress")).method_27693(": [").method_10852(ClientUtil.makeProgressBar((float)this.progress / (float)rec.getTicks())).method_27693("]"));
            if (this.resourceRemClient != 0L) {
                tooltip.add((class_2561)class_2561.method_43470((String)"    ").method_10852((class_2561)class_2561.method_43469((String)"info.coe.drill.resourceRemaining", (Object[])new Object[]{NumberFormatter.formatNumber(this.resourceRemClient)})));
            }
            if (!rec.getDrill().method_8093(this.drillStack)) {
                tooltip.add((class_2561)class_2561.method_43470((String)"    ").method_10852((class_2561)class_2561.method_43471((String)"info.coe.drill.badDrill")));
            }
            this.addToGoggleTooltip(tooltip, rec);
        }
        if (this.state != ExcavatorState.NO_ERROR) {
            tooltip.add((class_2561)class_2561.method_43470((String)"    ").method_10852((class_2561)class_2561.method_43471((String)("info.coe.drill.err_" + this.state.name().toLowerCase()))));
        }
        return true;
    }

    public void addToGoggleTooltip(List<class_2561> tooltip, R recipe) {
    }

    private R getRecipe() {
        IRecipe r;
        class_1923 p = new class_1923(this.field_11867);
        this.data = OreDataCapability.getData(this.field_11863.method_8497(p.field_9181, p.field_9180));
        class_1863 m = this.field_11863.method_8433();
        if (this.data != null && (r = this.data.getRecipe(m)) != null && this.instanceofCheck(r)) {
            return (R)((ExcavatingRecipe)r);
        }
        return null;
    }

    protected abstract boolean canExtract();

    protected abstract void onFinished();

    public void tick() {
        super.tick();
        if (!this.field_11863.field_9236) {
            if (this.current != null && this.state == ExcavatorState.NO_ERROR) {
                if (this.kinetic != null) {
                    this.kinetic.setStress(((ExcavatingRecipe)this.current).getStress());
                }
                if (this.canExtract() && this.kinetic != null && this.kinetic.getRotationSpeed() >= IRotate.SpeedLevel.MEDIUM.getSpeedValue() && ((ExcavatingRecipe)this.current).getDrill().method_8093(this.drillStack)) {
                    float prg = this.kinetic.getRotationSpeed() / IRotate.SpeedLevel.MEDIUM.getSpeedValue();
                    this.progress = (int)((float)this.progress + prg);
                    if (this.progress >= ((ExcavatingRecipe)this.current).getTicks()) {
                        this.updateState();
                        if (this.state == ExcavatorState.NO_ERROR) {
                            this.onFinished();
                            this.data.extract(1);
                        }
                        this.progress = 0;
                    }
                }
            } else if (this.progress > 10) {
                this.progress = 0;
                this.updateState();
            } else {
                ++this.progress;
            }
        }
    }

    private void updateState() {
        this.current = this.getRecipe();
        this.state = this.current == null ? ExcavatorState.NO_VEIN : (!this.data.canExtract(this.field_11863, this.field_11867) ? ExcavatorState.TOO_MANY_EXCAVATORS : (this.data.getResourcesRemaining((IRecipe)this.current) == -1L ? ExcavatorState.VEIN_EMPTY : ExcavatorState.NO_ERROR));
        this.notifyUpdate();
    }

    public void lazyTick() {
        this.notifyUpdate();
    }

    protected void read(class_2487 tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.progress = tag.method_10550("progress");
        this.drillStack = class_1799.method_7915((class_2487)tag.method_10562("drill"));
        if (clientPacket) {
            this.state = ExcavatorState.VALUES[tag.method_10571("state")];
            if (tag.method_10545("veinName")) {
                this.recipeClient = new class_2960(tag.method_10558("veinName"));
                this.resourceRemClient = tag.method_10537("resRem");
            } else {
                this.recipeClient = null;
            }
            this.hasRotation = tag.method_10577("hasRot");
        }
    }

    protected void write(class_2487 tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.method_10569("progress", this.progress);
        tag.method_10566("drill", (class_2520)this.drillStack.method_7953(new class_2487()));
        if (clientPacket) {
            tag.method_10567("state", (byte)this.state.ordinal());
            if (this.current != null) {
                tag.method_10582("veinName", ((ExcavatingRecipe)this.current).getRecipeId().toString());
                tag.method_10544("resRem", this.data.getResourcesRemaining((IRecipe)this.current));
            }
            tag.method_10556("hasRot", this.kinetic != null && this.kinetic.getRotationSpeed() >= IRotate.SpeedLevel.MEDIUM.getSpeedValue());
        }
    }

    public void initialize() {
        super.initialize();
        if (!this.field_11863.field_9236) {
            if (this.progress > 0 && this.current == null) {
                this.current = this.getRecipe();
            }
            if (this.current == null) {
                this.progress = 0;
            }
        }
    }

    @Override
    public boolean isActive() {
        return this.recipeClient != null;
    }

    @Override
    public class_1799 getDrill() {
        return this.drillStack;
    }

    @Override
    public class_2338 getBelow() {
        return this.field_11867.method_10087(2);
    }

    @Override
    public void addKinetic(MultiblockCapHandler.Kinetic k) {
        this.kinetic = k;
    }

    @Override
    public void dropInv() {
        this.dropItemStack(this.drillStack);
    }

    public class_1269 onClick(class_1657 player, class_1268 hand) {
        class_1799 item = player.method_5998(hand);
        if (!item.method_7960() && item.method_31573(CreateOreExcavation.DRILL_TAG)) {
            if (this.drillStack.method_7960()) {
                if (!this.field_11863.field_9236) {
                    this.drillStack = item.method_7971(1);
                }
                this.notifyUpdate();
                return class_1269.field_5812;
            }
        } else if (item.method_7960() && !this.drillStack.method_7960()) {
            if (!this.field_11863.field_9236) {
                if (player.method_7270(this.drillStack)) {
                    this.drillStack = class_1799.field_8037;
                    this.notifyUpdate();
                    return class_1269.field_21466;
                }
                return class_1269.field_5812;
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    protected void dropItemStack(class_1799 stackInSlot) {
        class_1264.method_5449((class_1937)this.field_11863, (double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), (class_1799)stackInSlot);
    }

    protected class_238 createRenderBoundingBox() {
        return new class_238(this.field_11867.method_10069(-1, -1, -1), this.field_11867.method_10069(1, 0, 1));
    }

    public static enum ExcavatorState {
        NO_ERROR,
        NO_VEIN,
        VEIN_EMPTY,
        TOO_MANY_EXCAVATORS;

        public static final ExcavatorState[] VALUES;

        static {
            VALUES = ExcavatorState.values();
        }
    }
}

