/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.block.entity;

import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.tom.createores.block.entity.ExcavatingBlockEntity;
import com.tom.createores.recipe.DrillingRecipe;
import com.tom.createores.util.IOBlockType;
import com.tom.createores.util.QueueInventory;
import io.github.fabricators_of_create.porting_lib.transfer.fluid.FluidTank;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public class DrillBlockEntity
extends ExcavatingBlockEntity<DrillingRecipe> {
    private QueueInventory inventory = new QueueInventory();
    private FluidTank fluidTank = new FluidTank(1296000L, v -> this.current != null && ((DrillingRecipe)this.current).getDrillingFluid().test(v)){

        protected void onContentsChanged() {
            DrillBlockEntity.this.notifyUpdate();
        }
    };

    public DrillBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public <T> Storage<T> getCaps(IOBlockType type) {
        if (type == IOBlockType.ITEM_OUT) {
            return this.inventory;
        }
        if (type == IOBlockType.FLUID_IN) {
            return this.fluidTank;
        }
        return null;
    }

    @Override
    protected void read(class_2487 tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.fluidTank.readFromNBT(tag.method_10562("tank"));
        if (!clientPacket) {
            this.inventory.load(tag.method_10554("inv", 10));
        }
    }

    @Override
    protected void write(class_2487 tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.method_10566("tank", (class_2520)this.fluidTank.writeToNBT(new class_2487()));
        if (!clientPacket) {
            tag.method_10566("inv", (class_2520)this.inventory.toTag());
        }
    }

    @Override
    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        this.containedFluidTooltip(tooltip, isPlayerSneaking, (Storage)this.fluidTank);
        return true;
    }

    @Override
    public void addToGoggleTooltip(List<class_2561> tooltip, DrillingRecipe rec) {
        if (rec.getDrillingFluid().getRequiredAmount() != 0L && rec.getDrillingFluid().test(this.fluidTank.getFluid()) && this.fluidTank.getFluidAmount() >= rec.getDrillingFluid().getRequiredAmount()) {
            tooltip.add((class_2561)class_2561.method_43470((String)"    ").method_10852((class_2561)class_2561.method_43471((String)"info.coe.drill.noFluid")));
        }
    }

    @Override
    public void dropInv() {
        super.dropInv();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            this.dropItemStack(this.inventory.getStackInSlot(i));
        }
    }

    @Override
    protected boolean instanceofCheck(Object rec) {
        return rec instanceof DrillingRecipe;
    }

    @Override
    protected boolean canExtract() {
        return this.inventory.hasSpace() && ((DrillingRecipe)this.current).getDrillingFluid().getRequiredAmount() == 0L || ((DrillingRecipe)this.current).getDrillingFluid().test(this.fluidTank.getFluid()) && this.fluidTank.getFluidAmount() >= ((DrillingRecipe)this.current).getDrillingFluid().getRequiredAmount();
    }

    @Override
    protected void onFinished() {
        ((DrillingRecipe)this.current).getOutput().stream().map(ProcessingOutput::rollOutput).filter(i -> !i.method_7960()).forEach(this.inventory::add);
        if (((DrillingRecipe)this.current).getDrillingFluid().getRequiredAmount() != 0L) {
            try (Transaction t = Transaction.openOuter();){
                this.fluidTank.extract((FluidVariant)this.fluidTank.variant, ((DrillingRecipe)this.current).getDrillingFluid().getRequiredAmount(), (TransactionContext)t);
                t.commit();
            }
        }
    }
}

