/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores;

import com.mojang.logging.LogUtils;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.tom.createores.COECommand;
import com.tom.createores.Config;
import com.tom.createores.OreDataCapability;
import com.tom.createores.Registration;
import com.tom.createores.recipe.DrillingRecipe;
import com.tom.createores.recipe.ExcavatingRecipe;
import com.tom.createores.recipe.ExtractorRecipe;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.itemgroup.FabricItemGroupBuilder;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraftforge.api.ModLoadingContext;
import net.minecraftforge.api.fml.event.config.ModConfigEvents;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.slf4j.Logger;

public class CreateOreExcavation
implements ModInitializer {
    public static final String MODID = "createoreexcavation";
    public static final Logger LOGGER = LogUtils.getLogger();
    private static CreateRegistrate registrate;
    public static final RecipeTypeGroup<DrillingRecipe> DRILLING_RECIPES;
    public static final RecipeTypeGroup<ExtractorRecipe> EXTRACTING_RECIPES;
    public static final class_1761 MOD_TAB;
    public static final class_6862<class_1792> DRILL_TAG;

    public CreateOreExcavation() {
        registrate = CreateRegistrate.create((String)MODID);
        ModLoadingContext.registerConfig((String)MODID, (ModConfig.Type)ModConfig.Type.COMMON, (IConfigSpec)Config.commonSpec);
        ModLoadingContext.registerConfig((String)MODID, (ModConfig.Type)ModConfig.Type.SERVER, (IConfigSpec)Config.serverSpec);
        ModConfigEvents.loading((String)MODID).register(c -> {
            LOGGER.info("Loaded Create Ore Excavation config file {}", (Object)c.getFileName());
            Config.load(c);
        });
        ModConfigEvents.reloading((String)MODID).register(c -> {
            LOGGER.info("Create Ore Excavation config just got changed on the file system!");
            Config.load(c);
        });
        Registration.register();
    }

    private static <T extends ExcavatingRecipe> RecipeTypeGroup<T> recipe(String name, ExcavatingRecipe.Serializer.RecipeFactory<T> factory) {
        RecipeTypeGroup rg = new RecipeTypeGroup(new class_2960(MODID, name));
        final String stringId = rg.id.toString();
        rg.recipeType = (class_3956)class_2378.method_10230((class_2378)class_2378.field_17597, (class_2960)rg.id, (Object)new class_3956<T>(){

            public String toString() {
                return stringId;
            }
        });
        rg.serializer = (class_1865)class_2378.method_10230((class_2378)class_2378.field_17598, (class_2960)rg.id, new ExcavatingRecipe.Serializer<T>(rg, factory));
        return rg;
    }

    public static CreateRegistrate registrate() {
        return registrate;
    }

    public void onInitialize() {
        LOGGER.info("Create Ore Excavation starting");
        registrate.register();
        Registration.postRegister();
        OreDataCapability.init();
        COECommand.init();
    }

    static {
        DRILLING_RECIPES = CreateOreExcavation.recipe("drilling", DrillingRecipe::new);
        EXTRACTING_RECIPES = CreateOreExcavation.recipe("extracting", ExtractorRecipe::new);
        MOD_TAB = FabricItemGroupBuilder.build((class_2960)new class_2960(MODID, "tab"), () -> new class_1799((class_1935)Registration.DIAMOND_DRILL_ITEM.get()));
        DRILL_TAG = class_6862.method_40092((class_5321)class_2378.field_25108, (class_2960)new class_2960(MODID, "drills"));
    }

    public static class RecipeTypeGroup<T extends class_1860<?>> {
        private class_1865<T> serializer;
        private class_3956<T> recipeType;
        private class_2960 id;

        public RecipeTypeGroup(class_2960 id) {
            this.id = id;
        }

        public class_3956<T> getRecipeType() {
            return this.recipeType;
        }

        public class_1865<T> getSerializer() {
            return this.serializer;
        }

        public class_2960 getId() {
            return this.id;
        }
    }
}

