/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.netherportalfix;

import java.util.UUID;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.netherportalfix.ReturnPortal;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1946;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_5459;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class ReturnPortalManager {
    private static final int MAX_PORTAL_DISTANCE_SQ = 16;
    private static final String RETURN_PORTAL_LIST = "ReturnPortalList";
    private static final String RETURN_PORTAL_UID = "UID";
    private static final String FROM_DIM = "FromDim";
    private static final String FROM_POS = "FromPos";
    private static final String TO_MIN_CORNER = "ToMinCorner";
    private static final String TO_AXIS_1_SIZE = "ToAxis1Size";
    private static final String TO_AXIS_2_SIZE = "ToAxis2Size";

    public static class_5459.class_5460 findPortalAt(class_1657 player, class_5321<class_1937> dim, class_2338 pos) {
        class_3218 fromWorld;
        MinecraftServer server = player.field_6002.method_8503();
        if (server != null && (fromWorld = server.method_3847(dim)) != null) {
            class_1946 portalForcer = fromWorld.method_14173();
            return portalForcer.method_30483(pos, false, fromWorld.method_8621()).orElse(null);
        }
        return null;
    }

    public static class_2499 getPlayerPortalList(class_1657 player) {
        class_2487 data = Balm.getHooks().getPersistentData(player);
        class_2499 list = data.method_10554(RETURN_PORTAL_LIST, 10);
        data.method_10566(RETURN_PORTAL_LIST, (class_2520)list);
        return list;
    }

    @Nullable
    public static ReturnPortal findReturnPortal(class_3222 player, class_5321<class_1937> fromDim, class_2338 fromPos) {
        class_2499 portalList = ReturnPortalManager.getPlayerPortalList((class_1657)player);
        for (class_2520 entry : portalList) {
            class_2338 portalTrigger;
            class_2487 portal = (class_2487)entry;
            class_5321 entryFromDim = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)new class_2960(portal.method_10558(FROM_DIM)));
            if (entryFromDim != fromDim || !((portalTrigger = class_2338.method_10092((long)portal.method_10537(FROM_POS))).method_10262((class_2382)fromPos) <= 16.0)) continue;
            UUID uid = portal.method_25928(RETURN_PORTAL_UID) ? portal.method_25926(RETURN_PORTAL_UID) : UUID.randomUUID();
            class_2338 minCorner = class_2338.method_10092((long)portal.method_10537(TO_MIN_CORNER));
            int axis1Size = portal.method_10550(TO_AXIS_1_SIZE);
            int axis2Size = portal.method_10550(TO_AXIS_2_SIZE);
            return new ReturnPortal(uid, new class_5459.class_5460(minCorner, axis1Size, axis2Size));
        }
        return null;
    }

    public static void storeReturnPortal(class_3222 player, class_5321<class_1937> fromDim, class_2338 fromPos, class_5459.class_5460 toPortal) {
        class_2499 portalList = ReturnPortalManager.getPlayerPortalList((class_1657)player);
        ReturnPortal returnPortal = ReturnPortalManager.findReturnPortal(player, fromDim, fromPos);
        if (returnPortal != null) {
            ReturnPortalManager.removeReturnPortal(player, returnPortal);
        }
        class_2487 portalCompound = new class_2487();
        portalCompound.method_25927(RETURN_PORTAL_UID, UUID.randomUUID());
        portalCompound.method_10582(FROM_DIM, String.valueOf(fromDim.method_29177()));
        portalCompound.method_10544(FROM_POS, fromPos.method_10063());
        portalCompound.method_10544(TO_MIN_CORNER, toPortal.field_25936.method_10063());
        portalCompound.method_10569(TO_AXIS_1_SIZE, toPortal.field_25937);
        portalCompound.method_10569(TO_AXIS_2_SIZE, toPortal.field_25938);
        portalList.add((Object)portalCompound);
    }

    public static void removeReturnPortal(class_3222 player, ReturnPortal portal) {
        class_2499 portalList = ReturnPortalManager.getPlayerPortalList((class_1657)player);
        for (int i = 0; i < portalList.size(); ++i) {
            class_2487 entry = (class_2487)portalList.method_10534(i);
            if (!entry.method_25928(RETURN_PORTAL_UID) || !entry.method_25926(RETURN_PORTAL_UID).equals(portal.getUid())) continue;
            portalList.method_10536(i);
            break;
        }
    }
}

