/*
 * Decompiled with CFR 0.152.
 */
package com.github.talrey.createdeco.registry;

import com.github.talrey.createdeco.Registration;
import com.github.talrey.createdeco.blocks.CageLampBlock;
import com.github.talrey.createdeco.blocks.CoinStackBlock;
import com.github.talrey.createdeco.blocks.DecalBlock;
import com.github.talrey.createdeco.blocks.DyedPlacardBlock;
import com.github.talrey.createdeco.blocks.DyedPlacardBlockEntity;
import com.github.talrey.createdeco.items.CoinStackItem;
import com.github.talrey.createdeco.registry.DecoCreativeModeTab;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.decoration.placard.PlacardBlock;
import com.simibubi.create.content.decoration.placard.PlacardRenderer;
import com.simibubi.create.foundation.data.SharedProperties;
import com.simibubi.create.foundation.data.TagGen;
import com.simibubi.create.foundation.item.ItemDescription;
import com.tterrag.registrate.Registrate;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.util.entry.BlockEntityEntry;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1160;
import net.minecraft.class_117;
import net.minecraft.class_141;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_184;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2066;
import net.minecraft.class_2073;
import net.minecraft.class_212;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2447;
import net.minecraft.class_2450;
import net.minecraft.class_2498;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3614;
import net.minecraft.class_44;
import net.minecraft.class_4559;
import net.minecraft.class_4970;
import net.minecraft.class_52;
import net.minecraft.class_5341;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_6862;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.class_85;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;

public class Props {
    public static HashMap<class_1767, BlockEntry<DecalBlock>> DECAL_BLOCKS = new HashMap();
    public static HashMap<String, BlockEntry<CageLampBlock>> YELLOW_CAGE_LAMPS = new HashMap();
    public static HashMap<String, BlockEntry<CageLampBlock>> RED_CAGE_LAMPS = new HashMap();
    public static HashMap<String, BlockEntry<CageLampBlock>> GREEN_CAGE_LAMPS = new HashMap();
    public static HashMap<String, BlockEntry<CageLampBlock>> BLUE_CAGE_LAMPS = new HashMap();
    public static HashMap<String, ItemEntry<class_1792>> COIN_ITEM = new HashMap();
    public static HashMap<String, ItemEntry<CoinStackItem>> COINSTACK_ITEM = new HashMap();
    public static HashMap<String, BlockEntry<CoinStackBlock>> COIN_BLOCKS = new HashMap();
    public static class_6862<class_1792> PLACARD_TAG;
    public static HashMap<class_1767, BlockEntry<? extends PlacardBlock>> PLACARDS;
    public static BlockEntityEntry<DyedPlacardBlockEntity> PLACARD_ENTITY;
    public static ArrayList<String> COIN_TYPES;
    public static final class_2960 YELLOW_ON;
    public static final class_2960 YELLOW_OFF;
    public static final class_2960 RED_ON;
    public static final class_2960 RED_OFF;
    public static final class_2960 GREEN_ON;
    public static final class_2960 GREEN_OFF;
    public static final class_2960 BLUE_ON;
    public static final class_2960 BLUE_OFF;

    private static String prettyName(String original) {
        StringBuilder builder = new StringBuilder();
        for (String part : original.split("_")) {
            builder.append(part.charAt(0));
            builder.append(part.substring(1).toLowerCase(Locale.ROOT));
            builder.append(" ");
        }
        return builder.toString();
    }

    public static ItemBuilder<CoinStackItem, ?> buildCoinStackItem(Registrate reg, NonNullSupplier<class_1792> coin, String name) {
        return reg.item(name.toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_coinstack", p -> new CoinStackItem((class_1792.class_1793)p, name)).properties(p -> name.contains("Netherite") ? p.method_24359() : p).recipe((ctx, prov) -> class_2450.method_10447((class_1935)((class_1935)ctx.get())).method_10449((class_1935)coin.get(), 4).method_10442("has_item", (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{(class_1935)coin.get()})).method_10431((Consumer)prov)).lang(name + " Coinstack");
    }

    public static ItemBuilder<class_1792, ?> buildCoinItem(Registrate reg, NonNullSupplier<class_1792> coinstack, String name) {
        return reg.item(name.toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_coin", class_1792::new).properties(p -> name.contains("Netherite") ? p.method_24359() : p).recipe((ctx, prov) -> class_2450.method_10448((class_1935)((class_1935)ctx.get()), (int)4).method_10454((class_1935)coinstack.get()).method_10442("has_item", (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{(class_1935)coinstack.get()})).method_10431((Consumer)prov)).lang(name + " Coin");
    }

    public static BlockBuilder<CoinStackBlock, ?> buildCoinStackBlock(Registrate reg, NonNullSupplier<class_1792> material, String name, class_2960 side, class_2960 bottom, class_2960 top) {
        return reg.block(name.toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_coinstack_block", p -> new CoinStackBlock((class_4970.class_2251)p, name)).properties(props -> props.method_22488().method_9632(0.5f).method_9626(class_2498.field_24119)).blockstate((ctx, prov) -> prov.getVariantBuilder((class_2248)ctx.getEntry()).forAllStates(state -> {
            int layer = (Integer)state.method_11654((class_2769)class_2741.field_12536);
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_" + layer, prov.modLoc("block/layers_bottom_top_" + layer))).texture("side", side)).texture("bottom", bottom)).texture("top", top)).build();
        })).addLayer(() -> class_1921::method_23579).lang(name + " Stack Block").loot((table, block) -> {
            class_52.class_53 builder = class_52.method_324();
            class_55.class_56 pool = class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f));
            for (int layer = 1; layer <= 8; ++layer) {
                class_85.class_86 entry = class_77.method_411((class_1935)((class_1935)material.get()));
                ((class_85.class_86)entry.method_421((class_5341.class_210)class_212.method_900((class_2248)block).method_22584(class_4559.class_4560.method_22523().method_22524((class_2769)class_2741.field_12536, layer)))).method_438((class_117.class_118)class_141.method_621((class_5658)class_44.method_32448((float)layer)));
                pool.method_351((class_79.class_80)entry);
            }
            table.method_16258((class_2248)block, builder.method_336(pool));
        });
    }

    public static BlockBuilder<CageLampBlock, ?> buildCageLamp(Registrate reg, String name, class_1767 color, class_2960 cage, class_2960 lampOn, class_2960 lampOff) {
        return reg.block(color.method_7792().toLowerCase(Locale.ROOT) + "_" + name.toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_lamp", p -> new CageLampBlock((class_4970.class_2251)p, new class_1160(0.3f, 0.3f, 0.0f))).initialProperties(class_3614.field_15953).properties(props -> props.method_22488().method_9632(0.5f).method_9626(class_2498.field_17734).method_9631(state -> (Boolean)state.method_11654((class_2769)class_2741.field_12548) != false ? 15 : 0)).blockstate((ctx, prov) -> prov.getVariantBuilder((class_2248)ctx.get()).forAllStates(state -> {
            int y = 0;
            int x = 90;
            switch ((class_2350)state.method_11654((class_2769)class_2741.field_12525)) {
                case field_11043: {
                    y = 0;
                    break;
                }
                case field_11035: {
                    y = 180;
                    break;
                }
                case field_11039: {
                    y = -90;
                    break;
                }
                case field_11034: {
                    y = 90;
                    break;
                }
                case field_11033: {
                    x = 180;
                    break;
                }
                default: {
                    x = 0;
                }
            }
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + ((Boolean)state.method_11654((class_2769)class_2741.field_12548) != false ? "" : "_off"), prov.modLoc("block/cage_lamp"))).texture("cage", cage)).texture("lamp", (Boolean)state.method_11654((class_2769)class_2741.field_12548) != false ? lampOn : lampOff)).texture("particle", cage)).rotationX(x).rotationY(y).build();
        })).addLayer(() -> class_1921::method_23579).lang(color.name().charAt(0) + color.name().substring(1).toLowerCase() + " " + name + " Cage Lamp").simpleItem();
    }

    public static void registerBlocks(Registrate reg) {
        reg.creativeModeTab(() -> DecoCreativeModeTab.PROPS_GROUP);
        COIN_TYPES.forEach(metal -> {
            class_2960 side = new class_2960("createdeco", "block/" + metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_coinstack_side");
            class_2960 top = new class_2960("createdeco", "block/" + metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_coinstack_top");
            class_2960 bottom = new class_2960("createdeco", "block/" + metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_coinstack_bottom");
            COIN_BLOCKS.put((String)metal, (BlockEntry<CoinStackBlock>)Props.buildCoinStackBlock(reg, (NonNullSupplier<class_1792>)((NonNullSupplier)() -> (class_1792)COINSTACK_ITEM.get(metal).get()), metal, side, bottom, top).register());
        });
        for (class_1767 color : class_1767.values()) {
            DECAL_BLOCKS.put(color, (BlockEntry<DecalBlock>)((BlockBuilder)reg.block(color.name().toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_decal", DecalBlock::new).initialProperties(class_3614.field_15953).properties(props -> props.method_22488().method_9632(0.5f).method_9626(class_2498.field_17734)).blockstate((ctx, prov) -> prov.getVariantBuilder((class_2248)ctx.get()).forAllStates(state -> {
                int y = 0;
                switch ((class_2350)state.method_11654((class_2769)class_2741.field_12481)) {
                    case field_11043: {
                        y = 0;
                        break;
                    }
                    case field_11035: {
                        y = 180;
                        break;
                    }
                    case field_11039: {
                        y = -90;
                        break;
                    }
                    case field_11034: {
                        y = 90;
                    }
                }
                return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName(), prov.modLoc("block/decal"))).texture("face", prov.modLoc("block/palettes/decal/" + ctx.getName()))).texture("particle", prov.modLoc("block/palettes/decal/" + ctx.getName()))).rotationY(y).build();
            })).addLayer(() -> class_1921::method_23579).lang(Props.prettyName(color.name()) + "Decal").item().model((ctx, prov) -> prov.singleTexture(ctx.getName(), prov.mcLoc("item/generated"), "layer0", prov.modLoc("block/palettes/decal/" + ctx.getName()))).build()).recipe((ctx, prov) -> class_2450.method_10447((class_1935)((class_1935)ctx.get())).method_10449((class_1935)AllItems.IRON_SHEET.get(), 1).method_10449((class_1935)class_1769.method_7803((class_1767)color), 1).method_10442("has_item", (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{(class_1935)AllItems.IRON_SHEET.get()})).method_10442("has_dye", (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{class_1769.method_7803((class_1767)color)})).method_10431((Consumer)prov)).register());
        }
        Registration.METAL_TYPES.forEach((metal, getter) -> {
            class_2960 cage = new class_2960("createdeco", "block/palettes/cage_lamp/" + metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_lamp");
            String name = metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_");
            class_6862<class_1792> nugget = Registration.makeItemTag(name + "_nuggets");
            class_6862<class_1792> plate = Registration.makeItemTag(name + "_plates");
            YELLOW_CAGE_LAMPS.put((String)metal, (BlockEntry<CageLampBlock>)Props.buildCageLamp(reg, metal, class_1767.field_7947, cage, YELLOW_ON, YELLOW_OFF).recipe((ctx, prov) -> {
                if (metal != "Andesite") {
                    class_2447.method_10437((class_1935)((class_1935)ctx.get())).method_10439("n").method_10439("t").method_10439("p").method_10433(Character.valueOf('n'), nugget).method_10434(Character.valueOf('t'), (class_1935)class_1802.field_8810).method_10433(Character.valueOf('p'), plate).method_10429("has_item", (class_184)class_2066.class_2068.method_8957((class_2073[])new class_2073[]{class_2073.class_2074.method_8973().method_8975(plate).method_8976()})).method_10431((Consumer)prov);
                } else {
                    class_2447.method_10437((class_1935)((class_1935)ctx.get())).method_10439("n").method_10439("t").method_10439("p").method_10434(Character.valueOf('n'), (class_1935)AllItems.ANDESITE_ALLOY.get()).method_10434(Character.valueOf('t'), (class_1935)class_1802.field_8810).method_10434(Character.valueOf('p'), (class_1935)AllItems.ANDESITE_ALLOY.get()).method_10429("has_item", (class_184)class_2066.class_2068.method_8957((class_2073[])new class_2073[]{class_2073.class_2074.method_8973().method_8977(new class_1935[]{(class_1935)AllItems.ANDESITE_ALLOY.get()}).method_8976()})).method_10431((Consumer)prov);
                }
            }).register());
            RED_CAGE_LAMPS.put((String)metal, (BlockEntry<CageLampBlock>)Props.buildCageLamp(reg, metal, class_1767.field_7964, cage, RED_ON, RED_OFF).recipe((ctx, prov) -> {
                if (metal != "Andesite") {
                    class_2447.method_10437((class_1935)((class_1935)ctx.get())).method_10439("n").method_10439("t").method_10439("p").method_10433(Character.valueOf('n'), nugget).method_10434(Character.valueOf('t'), (class_1935)class_1802.field_8530).method_10433(Character.valueOf('p'), plate).method_10429("has_item", (class_184)class_2066.class_2068.method_8957((class_2073[])new class_2073[]{class_2073.class_2074.method_8973().method_8975(plate).method_8976()})).method_10431((Consumer)prov);
                } else {
                    class_2447.method_10437((class_1935)((class_1935)ctx.get())).method_10439("n").method_10439("t").method_10439("p").method_10434(Character.valueOf('n'), (class_1935)AllItems.ANDESITE_ALLOY.get()).method_10434(Character.valueOf('t'), (class_1935)class_1802.field_8530).method_10434(Character.valueOf('p'), (class_1935)AllItems.ANDESITE_ALLOY.get()).method_10429("has_item", (class_184)class_2066.class_2068.method_8957((class_2073[])new class_2073[]{class_2073.class_2074.method_8973().method_8977(new class_1935[]{(class_1935)AllItems.ANDESITE_ALLOY.get()}).method_8976()})).method_10431((Consumer)prov);
                }
            }).register());
            GREEN_CAGE_LAMPS.put((String)metal, (BlockEntry<CageLampBlock>)Props.buildCageLamp(reg, metal, class_1767.field_7942, cage, GREEN_ON, GREEN_OFF).recipe((ctx, prov) -> {
                if (metal != "Andesite") {
                    class_2447.method_10437((class_1935)((class_1935)ctx.get())).method_10439("n").method_10439("t").method_10439("p").method_10433(Character.valueOf('n'), nugget).method_10434(Character.valueOf('t'), (class_1935)class_1802.field_28659).method_10433(Character.valueOf('p'), plate).method_10429("has_item", (class_184)class_2066.class_2068.method_8957((class_2073[])new class_2073[]{class_2073.class_2074.method_8973().method_8975(plate).method_8976()})).method_10431((Consumer)prov);
                } else {
                    class_2447.method_10437((class_1935)((class_1935)ctx.get())).method_10439("n").method_10439("t").method_10439("p").method_10434(Character.valueOf('n'), (class_1935)AllItems.ANDESITE_ALLOY.get()).method_10434(Character.valueOf('t'), (class_1935)class_1802.field_28659).method_10434(Character.valueOf('p'), (class_1935)AllItems.ANDESITE_ALLOY.get()).method_10429("has_item", (class_184)class_2066.class_2068.method_8957((class_2073[])new class_2073[]{class_2073.class_2074.method_8973().method_8977(new class_1935[]{(class_1935)AllItems.ANDESITE_ALLOY.get()}).method_8976()})).method_10431((Consumer)prov);
                }
            }).register());
            BLUE_CAGE_LAMPS.put((String)metal, (BlockEntry<CageLampBlock>)Props.buildCageLamp(reg, metal, class_1767.field_7966, cage, BLUE_ON, BLUE_OFF).recipe((ctx, prov) -> {
                if (metal != "Andesite") {
                    class_2447.method_10437((class_1935)((class_1935)ctx.get())).method_10439("n").method_10439("t").method_10439("p").method_10433(Character.valueOf('n'), nugget).method_10434(Character.valueOf('t'), (class_1935)class_1802.field_22001).method_10433(Character.valueOf('p'), plate).method_10429("has_item", (class_184)class_2066.class_2068.method_8957((class_2073[])new class_2073[]{class_2073.class_2074.method_8973().method_8975(plate).method_8976()})).method_10431((Consumer)prov);
                } else {
                    class_2447.method_10437((class_1935)((class_1935)ctx.get())).method_10439("n").method_10439("t").method_10439("p").method_10434(Character.valueOf('n'), (class_1935)AllItems.ANDESITE_ALLOY.get()).method_10434(Character.valueOf('t'), (class_1935)class_1802.field_22001).method_10434(Character.valueOf('p'), (class_1935)AllItems.ANDESITE_ALLOY.get()).method_10429("has_item", (class_184)class_2066.class_2068.method_8957((class_2073[])new class_2073[]{class_2073.class_2074.method_8973().method_8977(new class_1935[]{(class_1935)AllItems.ANDESITE_ALLOY.get()}).method_8976()})).method_10431((Consumer)prov);
                }
            }).register());
        });
        if (PLACARD_TAG == null) {
            PLACARD_TAG = Registration.makeItemTag("createdeco", "placards");
        }
        for (class_1767 color : class_1767.values()) {
            if (color == class_1767.field_7952) continue;
            String regName = color.name().toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_placard";
            PLACARDS.put(color, (BlockEntry<? extends PlacardBlock>)((BlockBuilder)((BlockBuilder)reg.block(regName, DyedPlacardBlock::new).initialProperties(SharedProperties::copperMetal).transform(TagGen.pickaxeOnly())).tag(new class_6862[]{AllTags.AllBlockTags.SAFE_NBT.tag}).blockstate((ctx, prov) -> prov.horizontalFaceBlock((class_2248)ctx.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(regName, prov.modLoc("block/dyed_placard"))).texture("0", prov.modLoc("block/palettes/placard/" + regName))).texture("particle", prov.modLoc("block/palettes/placard/" + regName)))).simpleItem().recipe((ctx, prov) -> class_2450.method_10447((class_1935)((class_1935)ctx.get())).method_10446(PLACARD_TAG).method_10454((class_1935)class_1769.method_7803((class_1767)color)).method_10442("has_item", (class_184)class_2066.class_2068.method_8957((class_2073[])new class_2073[]{class_2073.class_2074.method_8973().method_8975(PLACARD_TAG).method_8976()})).method_10442("has_dye", (class_184)class_2066.class_2068.method_8957((class_2073[])new class_2073[]{class_2073.class_2074.method_8973().method_8977(new class_1935[]{class_1769.method_7803((class_1767)color)}).method_8976()})).method_10452("dye_placard").method_10431((Consumer)prov)).onRegisterAfter(class_2378.field_25108, v -> ItemDescription.referKey((class_1935)v, (Supplier)AllBlocks.PLACARD))).register());
        }
        BlockEntry[] validPlacards = new BlockEntry[PLACARDS.size()];
        int color = 0;
        Iterator<BlockEntry<? extends PlacardBlock>> iterator = PLACARDS.values().iterator();
        while (iterator.hasNext()) {
            BlockEntry<? extends PlacardBlock> block;
            validPlacards[color] = block = iterator.next();
        }
        PLACARD_ENTITY = reg.blockEntity("dyed_placard", DyedPlacardBlockEntity::new).renderer(() -> PlacardRenderer::new).validBlocks((NonNullSupplier[])PLACARDS.values().toArray(validPlacards)).register();
    }

    public static void registerItems(Registrate reg) {
        reg.creativeModeTab(() -> DecoCreativeModeTab.PROPS_GROUP, "CreateDeco Props");
        for (String metal : COIN_TYPES) {
            COIN_ITEM.put(metal, (ItemEntry<class_1792>)Props.buildCoinItem(reg, (NonNullSupplier<class_1792>)((NonNullSupplier)() -> (class_1792)COINSTACK_ITEM.get(metal).get()), metal).register());
            COINSTACK_ITEM.put(metal, (ItemEntry<CoinStackItem>)Props.buildCoinStackItem(reg, (NonNullSupplier<class_1792>)((NonNullSupplier)() -> (class_1792)COIN_ITEM.get(metal).get()), metal).register());
        }
    }

    static {
        PLACARDS = new HashMap();
        COIN_TYPES = new ArrayList();
        YELLOW_ON = new class_2960("createdeco", "block/palettes/cage_lamp/light_default");
        YELLOW_OFF = new class_2960("createdeco", "block/palettes/cage_lamp/light_default_off");
        RED_ON = new class_2960("createdeco", "block/palettes/cage_lamp/light_redstone");
        RED_OFF = new class_2960("createdeco", "block/palettes/cage_lamp/light_redstone_off");
        GREEN_ON = new class_2960("createdeco", "block/palettes/cage_lamp/light_green");
        GREEN_OFF = new class_2960("createdeco", "block/palettes/cage_lamp/light_green_off");
        BLUE_ON = new class_2960("createdeco", "block/palettes/cage_lamp/light_soul");
        BLUE_OFF = new class_2960("createdeco", "block/palettes/cage_lamp/light_soul_off");
    }
}

