/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.newage.content.reactor.reactorheatvent;

import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.utility.Lang;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import org.antarcticgardens.newage.config.NewAgeConfig;
import org.antarcticgardens.newage.content.heat.HeatBlockEntity;
import org.antarcticgardens.newage.content.reactor.RodFindingReactorBlockEntity;
import org.antarcticgardens.newage.content.reactor.reactorrod.ReactorRodBlockEntity;
import org.antarcticgardens.newage.tools.StringFormattingTool;
import org.jetbrains.annotations.Nullable;

public class ReactorHeatVentBlockEntity
extends RodFindingReactorBlockEntity
implements HeatBlockEntity,
IHaveGoggleInformation {
    private float extract;
    public float heat = 0.0f;
    int tick = 0;

    public ReactorHeatVentBlockEntity(class_2591<?> type, class_2338 pos, class_2680 blockState) {
        super(type, pos, blockState);
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.heat = tag.method_10583("heat");
        this.extract = tag.method_10583("extract");
    }

    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10548("heat", this.heat);
        tag.method_10548("extract", this.extract);
    }

    @Override
    public float getHeat() {
        return this.heat;
    }

    @Override
    public void addHeat(float amount) {
        this.heat += amount;
        this.method_5431();
    }

    @Override
    public void setHeat(float amount) {
        this.heat = amount;
        this.method_5431();
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public void tick(class_2338 pos, class_1937 world, class_2680 state) {
        ++this.tick;
        if (this.tick >= 20) {
            double multiplier = (Double)NewAgeConfig.getCommon().overheatingMultiplier.get();
            if (multiplier > 0.0 && (double)this.heat > 16000.0 * multiplier) {
                world.method_8652(pos, class_2246.field_10164.method_9564(), 3);
            }
            this.tick = 0;
            this.extract = 0.0f;
            ReactorHeatVentBlockEntity.transferAroundNonRodOnly(this);
            LinkedList<ReactorRodBlockEntity> rods = new LinkedList<ReactorRodBlockEntity>();
            for (class_2350 dir : class_2350.values()) {
                this.findRods(rods, dir);
            }
            for (ReactorRodBlockEntity rod : rods) {
                float total = Math.min(rod.heat, 9000.0f - this.heat);
                rod.heat -= total;
                if (total > 0.0f) {
                    this.method_5431();
                }
                this.extract += total;
                this.heat += total;
            }
        }
    }

    static <T extends class_2586> void transferAroundNonRodOnly(T self) {
        if (self.method_10997() == null) {
            return;
        }
        float totalToAverage = ((HeatBlockEntity)self).getHeat();
        int totalBlocks = 1;
        HeatBlockEntity[] setters = new HeatBlockEntity[6];
        for (int i = 0; i < 6; ++i) {
            class_2350 value = class_2350.values()[i];
            class_2586 entity = self.method_10997().method_8321(self.method_11016().method_10093(value));
            if (!(entity instanceof HeatBlockEntity)) continue;
            HeatBlockEntity hbe = (HeatBlockEntity)entity;
            if (entity instanceof ReactorRodBlockEntity || !hbe.canAdd(value)) continue;
            setters[i] = hbe;
            totalToAverage += hbe.getHeat();
            ++totalBlocks;
        }
        HeatBlockEntity.average(self, totalToAverage, totalBlocks, setters);
    }

    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        Lang.translate((String)"tooltip.create_new_age.temperature", (Object[])new Object[]{StringFormattingTool.formatFloat(this.heat)}).style(class_124.field_1075).forGoggles(tooltip, 1);
        Lang.translate((String)"tooltip.create_new_age.extracting", (Object[])new Object[0]).style(class_124.field_1080).forGoggles(tooltip, 1);
        Lang.translate((String)"tooltip.create_new_age.temperature", (Object[])new Object[]{StringFormattingTool.formatFloat(this.extract)}).style(class_124.field_1075).forGoggles(tooltip, 2);
        return true;
    }
}

