/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.newage.content.heat.stirlingengine;

import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.antarcticgardens.newage.config.NewAgeConfig;
import org.antarcticgardens.newage.content.heat.HeatBlockEntity;
import org.antarcticgardens.newage.tools.StringFormattingTool;

public class StirlingEngineBlockEntity
extends GeneratingKineticBlockEntity
implements HeatBlockEntity {
    LerpedFloat visualSpeed = LerpedFloat.linear();
    float angle;
    private float heat = 0.0f;
    public float speed = 0.0f;

    public StirlingEngineBlockEntity(class_2591<?> typeIn, class_2338 pos, class_2680 state) {
        super(typeIn, pos, state);
    }

    public void write(class_2487 compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.method_10548("heat", this.heat);
    }

    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        Lang.translate((String)"tooltip.create_new_age.temperature", (Object[])new Object[]{StringFormattingTool.formatFloat(this.heat)}).style(class_124.field_1075).forGoggles(tooltip, 1);
        Lang.translate((String)"tooltip.create_new_age.using", (Object[])new Object[0]).style(class_124.field_1080).forGoggles(tooltip, 1);
        Lang.translate((String)"tooltip.create_new_age.temperature.ps", (Object[])new Object[]{StringFormattingTool.formatFloat(this.speed * 6.25f)}).style(class_124.field_1075).forGoggles(tooltip, 2);
        return super.addToGoggleTooltip(tooltip, isPlayerSneaking);
    }

    protected void read(class_2487 compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        if (clientPacket) {
            this.visualSpeed.chase((double)this.getGeneratedSpeed(), 0.015625, LerpedFloat.Chaser.EXP);
        }
        this.heat = compound.method_10583("heat");
    }

    public float getGeneratedSpeed() {
        return this.speed;
    }

    public void tick() {
        super.tick();
        if (this.method_10997() == null) {
            return;
        }
        if (this.method_10997().method_8510() % 20L == 0L) {
            HeatBlockEntity.transferAround(this);
            if (this.getHeat() > 50.0f) {
                if (this.getHeat() > 100.0f) {
                    double multiplier = (Double)NewAgeConfig.getCommon().overheatingMultiplier.get();
                    if ((double)this.getHeat() < 6000.0 * (Double)NewAgeConfig.getCommon().overheatingMultiplier.get()) {
                        this.setHeat(this.getHeat() - 100.0f);
                        if (this.speed != 16.0f) {
                            this.speed = 16.0f;
                            this.updateGeneratedRotation();
                        }
                    } else if (multiplier > 0.0) {
                        this.method_10997().method_8652(this.method_11016(), class_2246.field_10164.method_9564(), 3);
                    }
                } else {
                    this.setHeat(this.getHeat() - 50.0f);
                    if (this.speed != 8.0f) {
                        this.speed = 8.0f;
                        this.updateGeneratedRotation();
                    }
                }
            } else if (this.speed != 0.0f) {
                this.speed = 0.0f;
                this.updateGeneratedRotation();
            }
        }
        if (!this.method_10997().field_9236) {
            return;
        }
        float targetSpeed = this.getSpeed();
        this.visualSpeed.updateChaseTarget(targetSpeed);
        this.visualSpeed.tickChaser();
        this.angle += this.visualSpeed.getValue() * 3.0f / 10.0f;
        this.angle %= 360.0f;
    }

    @Override
    public float getHeat() {
        return this.heat;
    }

    @Override
    public boolean canConnect(class_2350 from) {
        return from == class_2350.field_11036;
    }

    @Override
    public void addHeat(float amount) {
        this.heat += amount;
        this.method_5431();
    }

    @Override
    public void setHeat(float amount) {
        this.heat = amount;
        this.method_5431();
    }
}

