/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.infrastructure.gametest.tests;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.logistics.depot.DepotBlockEntity;
import com.simibubi.create.content.logistics.tunnel.BrassTunnelBlockEntity;
import com.simibubi.create.content.redstone.nixieTube.NixieTubeBlockEntity;
import com.simibubi.create.content.trains.display.FlapDisplayBlockEntity;
import com.simibubi.create.content.trains.display.FlapDisplayLayout;
import com.simibubi.create.content.trains.display.FlapDisplaySection;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.infrastructure.gametest.CreateGameTestHelper;
import com.simibubi.create.infrastructure.gametest.GameTestGroup;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_156;
import net.minecraft.class_1772;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1889;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2453;
import net.minecraft.class_2591;
import net.minecraft.class_2769;
import net.minecraft.class_5250;
import net.minecraft.class_6302;

@GameTestGroup(path="items")
public class TestItems {
    @class_6302(method_35936="andesite_tunnel_split")
    public static void andesiteTunnelSplit(CreateGameTestHelper helper) {
        class_2338 lever = new class_2338(2, 6, 2);
        helper.method_36039(lever);
        Map<class_2338, class_1799> outputs = Map.of(new class_2338(2, 2, 1), new class_1799((class_1935)AllItems.BRASS_INGOT.get(), 1), new class_2338(3, 2, 1), new class_1799((class_1935)AllItems.BRASS_INGOT.get(), 1), new class_2338(4, 2, 2), new class_1799((class_1935)AllItems.BRASS_INGOT.get(), 3));
        helper.method_36018(() -> outputs.forEach(helper::assertContainerContains));
    }

    @class_6302(method_35936="arm_purgatory", method_35932=200)
    public static void armPurgatory(CreateGameTestHelper helper) {
        class_2338 lever = new class_2338(2, 3, 2);
        class_2338 depot1Pos = new class_2338(3, 2, 1);
        DepotBlockEntity depot1 = (DepotBlockEntity)helper.getBlockEntity((class_2591)AllBlockEntityTypes.DEPOT.get(), depot1Pos);
        class_2338 depot2Pos = new class_2338(1, 2, 1);
        DepotBlockEntity depot2 = (DepotBlockEntity)helper.getBlockEntity((class_2591)AllBlockEntityTypes.DEPOT.get(), depot2Pos);
        helper.method_36039(lever);
        helper.method_36018(() -> {
            helper.assertSecondsPassed(5);
            class_1799 held1 = depot1.getHeldItem();
            boolean held1Empty = held1.method_7960();
            int held1Count = held1.method_7947();
            class_1799 held2 = depot2.getHeldItem();
            boolean held2Empty = held2.method_7960();
            int held2Count = held2.method_7947();
            if (held1Empty && held2Empty) {
                helper.method_35995("No item present");
            }
            if (!held1Empty && held1Count != 1) {
                helper.method_35995("Unexpected count on depot 1: " + held1Count);
            }
            if (!held2Empty && held2Count != 1) {
                helper.method_35995("Unexpected count on depot 2: " + held2Count);
            }
        });
    }

    @class_6302(method_35936="attribute_filters", method_35932=200)
    public static void attributeFilters(CreateGameTestHelper helper) {
        class_2338 lever = new class_2338(2, 3, 1);
        class_2338 end = new class_2338(11, 2, 2);
        Map<class_2338, class_1799> outputs = Map.of(new class_2338(3, 2, 1), new class_1799((class_1935)AllBlocks.BRASS_BLOCK.get()), new class_2338(4, 2, 1), new class_1799((class_1935)class_1802.field_8279), new class_2338(5, 2, 1), new class_1799((class_1935)class_1802.field_8705), new class_2338(6, 2, 1), class_1772.method_7808((class_1889)new class_1889(class_1893.field_9111, 1)), new class_2338(7, 2, 1), (class_1799)class_156.method_654((Object)new class_1799((class_1935)class_1802.field_22022), s -> s.method_7974(1)), new class_2338(8, 2, 1), new class_1799((class_1935)class_1802.field_8743), new class_2338(9, 2, 1), new class_1799((class_1935)class_1802.field_8713), new class_2338(10, 2, 1), new class_1799((class_1935)class_1802.field_8567));
        helper.method_36039(lever);
        helper.method_36018(() -> {
            outputs.forEach(helper::assertContainerContains);
            helper.method_36047(end);
        });
    }

    @class_6302(method_35936="belt_coaster", method_35932=200)
    public static void beltCoaster(CreateGameTestHelper helper) {
        class_2338 input = new class_2338(1, 5, 6);
        class_2338 output = new class_2338(3, 8, 6);
        class_2338 lever = new class_2338(1, 5, 5);
        helper.method_36039(lever);
        helper.method_36018(() -> {
            long remainingItems;
            long outputItems = helper.getTotalItems(output);
            if (outputItems != 27L) {
                helper.method_35995("Expected 27 items, got " + outputItems);
            }
            if ((remainingItems = helper.getTotalItems(input)) != 2L) {
                helper.method_35995("Expected 2 items remaining, got " + remainingItems);
            }
        });
    }

    @class_6302(method_35936="brass_tunnel_filtering")
    public static void brassTunnelFiltering(CreateGameTestHelper helper) {
        Map<class_2338, class_1799> outputs = Map.of(new class_2338(3, 2, 2), new class_1799((class_1935)class_1802.field_27022, 13), new class_2338(4, 2, 3), new class_1799((class_1935)AllItems.ZINC_INGOT.get(), 4), new class_2338(4, 2, 4), new class_1799((class_1935)class_1802.field_8620, 2), new class_2338(4, 2, 5), new class_1799((class_1935)class_1802.field_8695, 24), new class_2338(3, 2, 6), new class_1799((class_1935)class_1802.field_8477, 17));
        class_2338 lever = new class_2338(2, 3, 2);
        helper.method_36039(lever);
        helper.method_36018(() -> outputs.forEach(helper::assertContainerContains));
    }

    @class_6302(method_35936="brass_tunnel_prefer_nearest", method_35932=200)
    public static void brassTunnelPreferNearest(CreateGameTestHelper helper) {
        List<class_2338> tunnels = List.of(new class_2338(3, 3, 1), new class_2338(3, 3, 2), new class_2338(3, 3, 3));
        List<class_2338> out = List.of(new class_2338(5, 2, 1), new class_2338(5, 2, 2), new class_2338(5, 2, 3));
        class_2338 lever = new class_2338(2, 3, 2);
        helper.method_36039(lever);
        tunnels.forEach(tunnel -> helper.setTunnelMode((class_2338)tunnel, BrassTunnelBlockEntity.SelectionMode.PREFER_NEAREST));
        helper.method_36018(() -> out.forEach(pos -> helper.assertContainerContains((class_2338)pos, (class_1935)AllBlocks.BRASS_CASING.get())));
    }

    @class_6302(method_35936="brass_tunnel_round_robin", method_35932=200)
    public static void brassTunnelRoundRobin(CreateGameTestHelper helper) {
        List<class_2338> outputs = List.of(new class_2338(7, 3, 1), new class_2338(7, 3, 2), new class_2338(7, 3, 3));
        TestItems.brassTunnelModeTest(helper, BrassTunnelBlockEntity.SelectionMode.ROUND_ROBIN, outputs);
    }

    @class_6302(method_35936="brass_tunnel_split")
    public static void brassTunnelSplit(CreateGameTestHelper helper) {
        List<class_2338> outputs = List.of(new class_2338(7, 2, 1), new class_2338(7, 2, 2), new class_2338(7, 2, 3));
        TestItems.brassTunnelModeTest(helper, BrassTunnelBlockEntity.SelectionMode.SPLIT, outputs);
    }

    private static void brassTunnelModeTest(CreateGameTestHelper helper, BrassTunnelBlockEntity.SelectionMode mode, List<class_2338> outputs) {
        class_2338 lever = new class_2338(2, 3, 2);
        List<class_2338> tunnels = List.of(new class_2338(3, 3, 1), new class_2338(3, 3, 2), new class_2338(3, 3, 3));
        helper.method_36039(lever);
        tunnels.forEach(tunnel -> helper.setTunnelMode((class_2338)tunnel, mode));
        helper.method_36018(() -> {
            long items = 0L;
            for (class_2338 out : outputs) {
                helper.assertContainerContains(out, (class_1935)AllBlocks.BRASS_CASING.get());
                items += helper.getTotalItems(out);
            }
            if (items != 10L) {
                helper.method_35995("expected 10 items, got " + items);
            }
        });
    }

    @class_6302(method_35936="brass_tunnel_sync_input", method_35932=200)
    public static void brassTunnelSyncInput(CreateGameTestHelper helper) {
        class_2338 lever = new class_2338(1, 3, 2);
        List<class_2338> redstoneBlocks = List.of(new class_2338(3, 4, 1), new class_2338(3, 4, 2), new class_2338(3, 4, 3));
        List<class_2338> tunnels = List.of(new class_2338(5, 3, 1), new class_2338(5, 3, 2), new class_2338(5, 3, 3));
        List<class_2338> outputs = List.of(new class_2338(7, 2, 1), new class_2338(7, 2, 2), new class_2338(7, 2, 3));
        helper.method_36039(lever);
        tunnels.forEach(tunnel -> helper.setTunnelMode((class_2338)tunnel, BrassTunnelBlockEntity.SelectionMode.SYNCHRONIZE));
        helper.method_36018(() -> {
            if (helper.secondsPassed() < 9L) {
                helper.method_35984((class_2338)redstoneBlocks.get(0), class_2246.field_10124);
                helper.assertSecondsPassed(3);
                outputs.forEach(helper::method_36047);
                helper.method_35984((class_2338)redstoneBlocks.get(1), class_2246.field_10124);
                helper.assertSecondsPassed(6);
                outputs.forEach(helper::method_36047);
                helper.method_35984((class_2338)redstoneBlocks.get(2), class_2246.field_10124);
                helper.assertSecondsPassed(9);
            } else {
                outputs.forEach(out -> helper.assertContainerContains((class_2338)out, (class_1935)AllBlocks.BRASS_CASING.get()));
            }
        });
    }

    @class_6302(method_35936="smart_observer_belt_and_funnel", method_35932=200)
    public static void smartObserverBeltAndFunnel(CreateGameTestHelper helper) {
        class_2338 lever = new class_2338(6, 3, 2);
        List<class_2338> targets = List.of(new class_2338(5, 2, 1), new class_2338(2, 4, 6));
        List<class_2338> overflows = List.of(new class_2338(6, 2, 1), new class_2338(1, 3, 6));
        helper.method_36039(lever);
        helper.method_36018(() -> {
            helper.assertSecondsPassed(9);
            targets.forEach(pos -> helper.method_35972(class_2246.field_10201, (class_2338)pos));
            overflows.forEach(pos -> helper.method_35972(class_2246.field_10124, (class_2338)pos));
        });
    }

    @class_6302(method_35936="smart_observer_chutes")
    public static void smartObserverChutes(CreateGameTestHelper helper) {
        class_2338 lever = new class_2338(1, 5, 2);
        class_2338 output = new class_2338(1, 5, 3);
        helper.method_36039(lever);
        helper.method_36018(() -> helper.method_35972(class_2246.field_10201, output));
    }

    @class_6302(method_35936="smart_observer_counting")
    public static void smartObserverCounting(CreateGameTestHelper helper) {
        class_2338 chest = new class_2338(3, 2, 1);
        long totalChestItems = helper.getTotalItems(chest);
        class_2338 chestNixiePos = new class_2338(2, 3, 1);
        NixieTubeBlockEntity chestNixie = (NixieTubeBlockEntity)helper.getBlockEntity((class_2591)AllBlockEntityTypes.NIXIE_TUBE.get(), chestNixiePos);
        class_2338 doubleChest = new class_2338(2, 2, 3);
        long totalDoubleChestItems = helper.getTotalItems(doubleChest);
        class_2338 doubleChestNixiePos = new class_2338(1, 3, 3);
        NixieTubeBlockEntity doubleChestNixie = (NixieTubeBlockEntity)helper.getBlockEntity((class_2591)AllBlockEntityTypes.NIXIE_TUBE.get(), doubleChestNixiePos);
        helper.method_36018(() -> {
            String doubleChestNixieText;
            long doubleChestNixieReading;
            String chestNixieText = chestNixie.getFullText().getString();
            long chestNixieReading = Long.parseLong(chestNixieText);
            if (chestNixieReading != totalChestItems) {
                helper.method_35995("Chest nixie detected %s, expected %s".formatted(chestNixieReading, totalChestItems));
            }
            if ((doubleChestNixieReading = Long.parseLong(doubleChestNixieText = doubleChestNixie.getFullText().getString())) != totalDoubleChestItems) {
                helper.method_35995("Double chest nixie detected %s, expected %s".formatted(doubleChestNixieReading, totalDoubleChestItems));
            }
        });
    }

    @class_6302(method_35936="smart_observer_filtered_storage")
    public static void smartObserverFilteredStorage(CreateGameTestHelper helper) {
        class_2338 lever = new class_2338(2, 3, 1);
        class_2338 leftLamp = new class_2338(3, 2, 3);
        class_2338 rightLamp = new class_2338(1, 2, 3);
        helper.method_36039(lever);
        helper.method_36018(() -> {
            helper.method_35987(leftLamp, (class_2769)class_2453.field_11413, Boolean.valueOf(true));
            helper.method_35987(rightLamp, (class_2769)class_2453.field_11413, Boolean.valueOf(false));
        });
    }

    @class_6302(method_35936="smart_observer_storage")
    public static void smartObserverStorage(CreateGameTestHelper helper) {
        class_2338 lever = new class_2338(1, 3, 2);
        class_2338 lamp = new class_2338(1, 2, 3);
        helper.method_36039(lever);
        helper.method_36018(() -> helper.method_35987(lamp, (class_2769)class_2453.field_11413, Boolean.valueOf(true)));
    }

    @class_6302(method_35936="depot_display", method_35932=200)
    public static void depotDisplay(CreateGameTestHelper helper) {
        class_2338 displayPos = new class_2338(5, 3, 1);
        List<DepotBlockEntity> depots = Stream.of(new class_2338(2, 2, 1), new class_2338(1, 2, 1)).map(pos -> (DepotBlockEntity)helper.getBlockEntity((class_2591)AllBlockEntityTypes.DEPOT.get(), (class_2338)pos)).toList();
        List<class_2338> levers = List.of(new class_2338(2, 5, 0), new class_2338(1, 5, 0));
        levers.forEach(arg_0 -> ((CreateGameTestHelper)helper).method_36039(arg_0));
        FlapDisplayBlockEntity display = ((FlapDisplayBlockEntity)helper.getBlockEntity((class_2591)AllBlockEntityTypes.FLAP_DISPLAY.get(), displayPos)).getController();
        helper.method_36018(() -> {
            for (int i = 0; i < 2; ++i) {
                FlapDisplayLayout line = display.getLines().get(i);
                class_5250 textComponent = Components.empty();
                line.getSections().stream().map(FlapDisplaySection::getText).forEach(arg_0 -> ((class_5250)textComponent).method_10852(arg_0));
                String text = textComponent.getString().toLowerCase(Locale.ROOT).trim();
                DepotBlockEntity depot = (DepotBlockEntity)depots.get(i);
                class_1799 item = depot.getHeldItem();
                String name = class_2378.field_11142.method_10221((Object)item.method_7909()).method_12832();
                if (name.equals(text)) continue;
                helper.method_35995("Text mismatch: wanted [" + name + "], got: " + text);
            }
        });
    }

    @class_6302(method_35936="threshold_switch")
    public static void thresholdSwitch(CreateGameTestHelper helper) {
        class_2338 chest = new class_2338(1, 2, 1);
        class_2338 lamp = new class_2338(2, 3, 1);
        helper.method_35987(lamp, (class_2769)class_2453.field_11413, Boolean.valueOf(false));
        Storage<ItemVariant> chestStorage = helper.itemStorageAt(chest);
        class_1799 diamondStack = new class_1799((class_1935)class_1802.field_8477, 64);
        for (int i = 0; i < 18; ++i) {
            TransferUtil.insertItem(chestStorage, (class_1799)diamondStack);
        }
        helper.method_36018(() -> helper.method_35987(lamp, (class_2769)class_2453.field_11413, Boolean.valueOf(true)));
    }

    @class_6302(method_35936="storages", method_35932=200)
    public static void storages(CreateGameTestHelper helper) {
        class_2338 lever = new class_2338(12, 3, 2);
        class_2338 startChest = new class_2338(13, 3, 1);
        Object2LongMap<class_1792> originalContent = helper.getItemContent(startChest);
        class_2338 endShulker = new class_2338(1, 3, 1);
        helper.method_36039(lever);
        helper.method_36018(() -> helper.assertContentPresent(originalContent, endShulker));
    }

    @class_6302(method_35936="vault_comparator_output")
    public static void vaultComparatorOutput(CreateGameTestHelper helper) {
        class_2338 smallInput = new class_2338(1, 4, 1);
        class_2338 smallNixie = new class_2338(3, 2, 1);
        helper.assertNixiePower(smallNixie, 0);
        helper.whenSecondsPassed(1, () -> helper.spawnItems(smallInput, class_1802.field_8229, 576));
        class_2338 medInput = new class_2338(1, 5, 4);
        class_2338 medNixie = new class_2338(4, 2, 4);
        helper.assertNixiePower(medNixie, 0);
        helper.whenSecondsPassed(2, () -> helper.spawnItems(medInput, class_1802.field_8229, 4928));
        class_2338 bigInput = new class_2338(1, 6, 8);
        class_2338 bigNixie = new class_2338(5, 2, 7);
        helper.assertNixiePower(bigNixie, 0);
        helper.whenSecondsPassed(3, () -> helper.spawnItems(bigInput, class_1802.field_8229, 15360));
        helper.method_36018(() -> {
            helper.assertNixiePower(smallNixie, 7);
            helper.assertNixiePower(medNixie, 7);
            helper.assertNixiePower(bigNixie, 7);
        });
    }
}

