/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.instruction;

import com.simibubi.create.content.contraptions.bearing.IBearingBlockEntity;
import com.simibubi.create.content.contraptions.pulley.PulleyBlockEntity;
import com.simibubi.create.content.kinetics.deployer.DeployerBlockEntity;
import com.simibubi.create.content.trains.bogey.AbstractBogeyBlockEntity;
import com.simibubi.create.foundation.ponder.PonderScene;
import com.simibubi.create.foundation.ponder.PonderWorld;
import com.simibubi.create.foundation.ponder.instruction.TickingInstruction;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_2338;
import net.minecraft.class_2586;

public class AnimateBlockEntityInstruction
extends TickingInstruction {
    protected double deltaPerTick;
    protected double totalDelta;
    protected double target;
    protected final class_2338 location;
    private BiConsumer<PonderWorld, Float> setter;
    private Function<PonderWorld, Float> getter;

    public static AnimateBlockEntityInstruction bearing(class_2338 location, float totalDelta, int ticks) {
        return new AnimateBlockEntityInstruction(location, totalDelta, ticks, (w, f) -> AnimateBlockEntityInstruction.castIfPresent(w, location, IBearingBlockEntity.class).ifPresent(bte -> bte.setAngle(f.floatValue())), w -> AnimateBlockEntityInstruction.castIfPresent(w, location, IBearingBlockEntity.class).map(bte -> Float.valueOf(bte.getInterpolatedAngle(0.0f))).orElse(Float.valueOf(0.0f)));
    }

    public static AnimateBlockEntityInstruction bogey(class_2338 location, float totalDelta, int ticks) {
        float movedPerTick = totalDelta / (float)ticks;
        return new AnimateBlockEntityInstruction(location, totalDelta, ticks, (w, f) -> AnimateBlockEntityInstruction.castIfPresent(w, location, AbstractBogeyBlockEntity.class).ifPresent(bte -> bte.animate(f.equals(Float.valueOf(totalDelta)) ? 0.0f : movedPerTick)), w -> Float.valueOf(0.0f));
    }

    public static AnimateBlockEntityInstruction pulley(class_2338 location, float totalDelta, int ticks) {
        return new AnimateBlockEntityInstruction(location, totalDelta, ticks, (w, f) -> AnimateBlockEntityInstruction.castIfPresent(w, location, PulleyBlockEntity.class).ifPresent(pulley -> pulley.animateOffset(f.floatValue())), w -> AnimateBlockEntityInstruction.castIfPresent(w, location, PulleyBlockEntity.class).map(pulley -> Float.valueOf(pulley.offset)).orElse(Float.valueOf(0.0f)));
    }

    public static AnimateBlockEntityInstruction deployer(class_2338 location, float totalDelta, int ticks) {
        return new AnimateBlockEntityInstruction(location, totalDelta, ticks, (w, f) -> AnimateBlockEntityInstruction.castIfPresent(w, location, DeployerBlockEntity.class).ifPresent(deployer -> deployer.setAnimatedOffset(f.floatValue())), w -> AnimateBlockEntityInstruction.castIfPresent(w, location, DeployerBlockEntity.class).map(deployer -> Float.valueOf(deployer.getHandOffset(1.0f))).orElse(Float.valueOf(0.0f)));
    }

    protected AnimateBlockEntityInstruction(class_2338 location, float totalDelta, int ticks, BiConsumer<PonderWorld, Float> setter, Function<PonderWorld, Float> getter) {
        super(false, ticks);
        this.location = location;
        this.setter = setter;
        this.getter = getter;
        this.deltaPerTick = (double)totalDelta * (1.0 / (double)ticks);
        this.totalDelta = totalDelta;
        this.target = totalDelta;
    }

    @Override
    protected final void firstTick(PonderScene scene) {
        super.firstTick(scene);
        this.target = (double)this.getter.apply(scene.getWorld()).floatValue() + this.totalDelta;
    }

    @Override
    public void tick(PonderScene scene) {
        super.tick(scene);
        PonderWorld world = scene.getWorld();
        float current = this.getter.apply(world).floatValue();
        float next = (float)(this.remainingTicks == 0 ? this.target : (double)current + this.deltaPerTick);
        this.setter.accept(world, Float.valueOf(next));
        if (this.remainingTicks == 0) {
            this.setter.accept(world, Float.valueOf(next));
        }
    }

    private static <T> Optional<T> castIfPresent(PonderWorld world, class_2338 pos, Class<T> beType) {
        class_2586 blockEntity = world.method_8321(pos);
        if (beType.isInstance(blockEntity)) {
            return Optional.of(beType.cast(blockEntity));
        }
        return Optional.empty();
    }
}

