/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder;

import com.simibubi.create.content.contraptions.actors.trainControls.ControlsBlock;
import com.simibubi.create.content.contraptions.glue.SuperGlueItem;
import com.simibubi.create.content.fluids.pump.PumpBlockEntity;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.RotationIndicatorParticleData;
import com.simibubi.create.content.kinetics.belt.BeltBlockEntity;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.kinetics.crafter.ConnectedInputHandler;
import com.simibubi.create.content.kinetics.crafter.MechanicalCrafterBlockEntity;
import com.simibubi.create.content.kinetics.gauge.SpeedGaugeBlockEntity;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmBlockEntity;
import com.simibubi.create.content.logistics.funnel.FunnelBlockEntity;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlockEntity;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkBlockEntity;
import com.simibubi.create.content.trains.display.FlapDisplayBlockEntity;
import com.simibubi.create.content.trains.signal.SignalBlockEntity;
import com.simibubi.create.content.trains.station.StationBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.ponder.ElementLink;
import com.simibubi.create.foundation.ponder.PonderLocalization;
import com.simibubi.create.foundation.ponder.PonderPalette;
import com.simibubi.create.foundation.ponder.PonderScene;
import com.simibubi.create.foundation.ponder.PonderWorld;
import com.simibubi.create.foundation.ponder.Selection;
import com.simibubi.create.foundation.ponder.element.AnimatedSceneElement;
import com.simibubi.create.foundation.ponder.element.BeltItemElement;
import com.simibubi.create.foundation.ponder.element.EntityElement;
import com.simibubi.create.foundation.ponder.element.InputWindowElement;
import com.simibubi.create.foundation.ponder.element.MinecartElement;
import com.simibubi.create.foundation.ponder.element.ParrotElement;
import com.simibubi.create.foundation.ponder.element.TextWindowElement;
import com.simibubi.create.foundation.ponder.element.WorldSectionElement;
import com.simibubi.create.foundation.ponder.instruction.AnimateBlockEntityInstruction;
import com.simibubi.create.foundation.ponder.instruction.AnimateMinecartInstruction;
import com.simibubi.create.foundation.ponder.instruction.AnimateParrotInstruction;
import com.simibubi.create.foundation.ponder.instruction.AnimateWorldSectionInstruction;
import com.simibubi.create.foundation.ponder.instruction.BlockEntityDataInstruction;
import com.simibubi.create.foundation.ponder.instruction.ChaseAABBInstruction;
import com.simibubi.create.foundation.ponder.instruction.CreateMinecartInstruction;
import com.simibubi.create.foundation.ponder.instruction.CreateParrotInstruction;
import com.simibubi.create.foundation.ponder.instruction.DelayInstruction;
import com.simibubi.create.foundation.ponder.instruction.DisplayWorldSectionInstruction;
import com.simibubi.create.foundation.ponder.instruction.EmitParticlesInstruction;
import com.simibubi.create.foundation.ponder.instruction.FadeOutOfSceneInstruction;
import com.simibubi.create.foundation.ponder.instruction.HighlightValueBoxInstruction;
import com.simibubi.create.foundation.ponder.instruction.KeyframeInstruction;
import com.simibubi.create.foundation.ponder.instruction.LineInstruction;
import com.simibubi.create.foundation.ponder.instruction.MarkAsFinishedInstruction;
import com.simibubi.create.foundation.ponder.instruction.MovePoiInstruction;
import com.simibubi.create.foundation.ponder.instruction.OutlineSelectionInstruction;
import com.simibubi.create.foundation.ponder.instruction.PonderInstruction;
import com.simibubi.create.foundation.ponder.instruction.ReplaceBlocksInstruction;
import com.simibubi.create.foundation.ponder.instruction.RotateSceneInstruction;
import com.simibubi.create.foundation.ponder.instruction.ShowInputInstruction;
import com.simibubi.create.foundation.ponder.instruction.TextInstruction;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import io.github.fabricators_of_create.porting_lib.util.NBTSerializer;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2390;
import net.minecraft.class_243;
import net.minecraft.class_2459;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;

public class SceneBuilder {
    public final OverlayInstructions overlay;
    public final WorldInstructions world;
    public final DebugInstructions debug;
    public final EffectInstructions effects;
    public final SpecialInstructions special;
    private final PonderScene scene;

    public SceneBuilder(PonderScene ponderScene) {
        this.scene = ponderScene;
        this.overlay = new OverlayInstructions();
        this.special = new SpecialInstructions();
        this.world = new WorldInstructions();
        this.debug = new DebugInstructions();
        this.effects = new EffectInstructions();
    }

    public void title(String sceneId, String title) {
        this.scene.sceneId = new class_2960(this.scene.getNamespace(), sceneId);
        PonderLocalization.registerSpecific(this.scene.sceneId, "header", title);
    }

    public void configureBasePlate(int xOffset, int zOffset, int basePlateSize) {
        this.scene.basePlateOffsetX = xOffset;
        this.scene.basePlateOffsetZ = zOffset;
        this.scene.basePlateSize = basePlateSize;
    }

    public void scaleSceneView(float factor) {
        this.scene.scaleFactor = factor;
    }

    public void removeShadow() {
        this.scene.hidePlatformShadow = true;
    }

    public void setSceneOffsetY(float yOffset) {
        this.scene.yOffset = yOffset;
    }

    public void showBasePlate() {
        this.world.showSection(this.scene.getSceneBuildingUtil().select.cuboid(new class_2338(this.scene.getBasePlateOffsetX(), 0, this.scene.getBasePlateOffsetZ()), new class_2382(this.scene.getBasePlateSize() - 1, 0, this.scene.getBasePlateSize() - 1)), class_2350.field_11036);
    }

    public void addInstruction(PonderInstruction instruction) {
        this.scene.schedule.add(instruction);
    }

    public void addInstruction(Consumer<PonderScene> callback) {
        this.addInstruction(PonderInstruction.simple(callback));
    }

    public void idle(int ticks) {
        this.addInstruction(new DelayInstruction(ticks));
    }

    public void idleSeconds(int seconds) {
        this.idle(seconds * 20);
    }

    public void markAsFinished() {
        this.addInstruction(new MarkAsFinishedInstruction());
    }

    public void rotateCameraY(float degrees) {
        this.addInstruction(new RotateSceneInstruction(0.0f, degrees, true));
    }

    public void addKeyframe() {
        this.addInstruction(KeyframeInstruction.IMMEDIATE);
    }

    public void addLazyKeyframe() {
        this.addInstruction(KeyframeInstruction.DELAYED);
    }

    public class OverlayInstructions {
        public TextWindowElement.Builder showText(int duration) {
            TextWindowElement textWindowElement = new TextWindowElement();
            SceneBuilder.this.addInstruction(new TextInstruction(textWindowElement, duration));
            TextWindowElement textWindowElement2 = textWindowElement;
            Objects.requireNonNull(textWindowElement2);
            return new TextWindowElement.Builder(textWindowElement2, SceneBuilder.this.scene);
        }

        public TextWindowElement.Builder showSelectionWithText(Selection selection, int duration) {
            TextWindowElement textWindowElement = new TextWindowElement();
            SceneBuilder.this.addInstruction(new TextInstruction(textWindowElement, duration, selection));
            TextWindowElement textWindowElement2 = textWindowElement;
            Objects.requireNonNull(textWindowElement2);
            return new TextWindowElement.Builder(textWindowElement2, SceneBuilder.this.scene).pointAt(selection.getCenter());
        }

        public void showControls(InputWindowElement element, int duration) {
            SceneBuilder.this.addInstruction(new ShowInputInstruction(element.clone(), duration));
        }

        public void chaseBoundingBoxOutline(PonderPalette color, Object slot, class_238 boundingBox, int duration) {
            SceneBuilder.this.addInstruction(new ChaseAABBInstruction(color, slot, boundingBox, duration));
        }

        public void showCenteredScrollInput(class_2338 pos, class_2350 side, int duration) {
            this.showFilterSlotInput(SceneBuilder.this.scene.getSceneBuildingUtil().vector.blockSurface(pos, side), side, duration);
        }

        public void showScrollInput(class_243 location, class_2350 side, int duration) {
            class_2350.class_2351 axis = side.method_10166();
            float s = 0.0625f;
            float q = 0.25f;
            class_243 expands = new class_243(axis == class_2350.class_2351.field_11048 ? (double)s : (double)q, axis == class_2350.class_2351.field_11052 ? (double)s : (double)q, axis == class_2350.class_2351.field_11051 ? (double)s : (double)q);
            SceneBuilder.this.addInstruction(new HighlightValueBoxInstruction(location, expands, duration));
        }

        public void showRepeaterScrollInput(class_2338 pos, int duration) {
            this.showFilterSlotInput(SceneBuilder.this.scene.getSceneBuildingUtil().vector.blockSurface(pos, class_2350.field_11033).method_1031(0.0, 0.1875, 0.0), class_2350.field_11036, duration);
        }

        public void showFilterSlotInput(class_243 location, class_2350 side, int duration) {
            location = location.method_1019(class_243.method_24954((class_2382)side.method_10163()).method_1021(-0.0234375));
            class_243 expands = VecHelper.axisAlingedPlaneOf(side).method_1021(0.0859375);
            SceneBuilder.this.addInstruction(new HighlightValueBoxInstruction(location, expands, duration));
        }

        public void showLine(PonderPalette color, class_243 start, class_243 end, int duration) {
            SceneBuilder.this.addInstruction(new LineInstruction(color, start, end, duration, false));
        }

        public void showBigLine(PonderPalette color, class_243 start, class_243 end, int duration) {
            SceneBuilder.this.addInstruction(new LineInstruction(color, start, end, duration, true));
        }

        public void showOutline(PonderPalette color, Object slot, Selection selection, int duration) {
            SceneBuilder.this.addInstruction(new OutlineSelectionInstruction(color, slot, selection, duration));
        }
    }

    public class SpecialInstructions {
        public ElementLink<ParrotElement> birbOnTurntable(class_2338 pos) {
            return this.createBirb(VecHelper.getCenterOf((class_2382)pos), () -> new ParrotElement.SpinOnComponentPose(pos));
        }

        public ElementLink<ParrotElement> birbOnSpinnyShaft(class_2338 pos) {
            return this.createBirb(VecHelper.getCenterOf((class_2382)pos).method_1031(0.0, 0.5, 0.0), () -> new ParrotElement.SpinOnComponentPose(pos));
        }

        public ElementLink<ParrotElement> createBirb(class_243 location, Supplier<? extends ParrotElement.ParrotPose> pose) {
            ElementLink<ParrotElement> link = new ElementLink<ParrotElement>(ParrotElement.class);
            ParrotElement parrot = ParrotElement.create(location, pose);
            SceneBuilder.this.addInstruction(new CreateParrotInstruction(10, class_2350.field_11033, parrot));
            SceneBuilder.this.addInstruction(scene -> scene.linkElement(parrot, link));
            return link;
        }

        public void changeBirbPose(ElementLink<ParrotElement> birb, Supplier<? extends ParrotElement.ParrotPose> pose) {
            SceneBuilder.this.addInstruction(scene -> ((ParrotElement)scene.resolve(birb)).setPose((ParrotElement.ParrotPose)pose.get()));
        }

        public void conductorBirb(ElementLink<ParrotElement> birb, boolean conductor) {
            SceneBuilder.this.addInstruction(scene -> ((ParrotElement)scene.resolve(birb)).setConductor(conductor));
        }

        public void movePointOfInterest(class_243 location) {
            SceneBuilder.this.addInstruction(new MovePoiInstruction(location));
        }

        public void movePointOfInterest(class_2338 location) {
            this.movePointOfInterest(VecHelper.getCenterOf((class_2382)location));
        }

        public void rotateParrot(ElementLink<ParrotElement> link, double xRotation, double yRotation, double zRotation, int duration) {
            SceneBuilder.this.addInstruction(AnimateParrotInstruction.rotate(link, new class_243(xRotation, yRotation, zRotation), duration));
        }

        public void moveParrot(ElementLink<ParrotElement> link, class_243 offset, int duration) {
            SceneBuilder.this.addInstruction(AnimateParrotInstruction.move(link, offset, duration));
        }

        public ElementLink<MinecartElement> createCart(class_243 location, float angle, MinecartElement.MinecartConstructor type) {
            ElementLink<MinecartElement> link = new ElementLink<MinecartElement>(MinecartElement.class);
            MinecartElement cart = new MinecartElement(location, angle, type);
            SceneBuilder.this.addInstruction(new CreateMinecartInstruction(10, class_2350.field_11033, cart));
            SceneBuilder.this.addInstruction(scene -> scene.linkElement(cart, link));
            return link;
        }

        public void rotateCart(ElementLink<MinecartElement> link, float yRotation, int duration) {
            SceneBuilder.this.addInstruction(AnimateMinecartInstruction.rotate(link, yRotation, duration));
        }

        public void moveCart(ElementLink<MinecartElement> link, class_243 offset, int duration) {
            SceneBuilder.this.addInstruction(AnimateMinecartInstruction.move(link, offset, duration));
        }

        public <T extends AnimatedSceneElement> void hideElement(ElementLink<T> link, class_2350 direction) {
            SceneBuilder.this.addInstruction(new FadeOutOfSceneInstruction<T>(15, direction, link));
        }
    }

    public class WorldInstructions {
        public void incrementBlockBreakingProgress(class_2338 pos) {
            SceneBuilder.this.addInstruction(scene -> {
                PonderWorld world = scene.getWorld();
                int progress = world.getBlockBreakingProgressions().getOrDefault(pos, -1) + 1;
                if (progress == 9) {
                    world.addBlockDestroyEffects(pos, world.method_8320(pos));
                    world.method_22352(pos, false);
                    world.setBlockBreakingProgress(pos, 0);
                    scene.forEach(WorldSectionElement.class, WorldSectionElement::queueRedraw);
                } else {
                    world.setBlockBreakingProgress(pos, progress + 1);
                }
            });
        }

        public void showSection(Selection selection, class_2350 fadeInDirection) {
            SceneBuilder.this.addInstruction(new DisplayWorldSectionInstruction(15, fadeInDirection, selection, Optional.of(SceneBuilder.this.scene::getBaseWorldSection)));
        }

        public void showSectionAndMerge(Selection selection, class_2350 fadeInDirection, ElementLink<WorldSectionElement> link) {
            SceneBuilder.this.addInstruction(new DisplayWorldSectionInstruction(15, fadeInDirection, selection, Optional.of(() -> (WorldSectionElement)SceneBuilder.this.scene.resolve(link))));
        }

        public void glueBlockOnto(class_2338 position, class_2350 fadeInDirection, ElementLink<WorldSectionElement> link) {
            SceneBuilder.this.addInstruction(new DisplayWorldSectionInstruction(15, fadeInDirection, SceneBuilder.this.scene.getSceneBuildingUtil().select.position(position), Optional.of(() -> (WorldSectionElement)SceneBuilder.this.scene.resolve(link)), position));
        }

        public ElementLink<WorldSectionElement> showIndependentSection(Selection selection, class_2350 fadeInDirection) {
            DisplayWorldSectionInstruction instruction = new DisplayWorldSectionInstruction(15, fadeInDirection, selection, Optional.empty());
            SceneBuilder.this.addInstruction(instruction);
            return instruction.createLink(SceneBuilder.this.scene);
        }

        public ElementLink<WorldSectionElement> showIndependentSection(Selection selection, class_2350 fadeInDirection, int fadeInDuration) {
            DisplayWorldSectionInstruction instruction = new DisplayWorldSectionInstruction(fadeInDuration, fadeInDirection, selection, Optional.empty());
            SceneBuilder.this.addInstruction(instruction);
            return instruction.createLink(SceneBuilder.this.scene);
        }

        public ElementLink<WorldSectionElement> showIndependentSectionImmediately(Selection selection) {
            DisplayWorldSectionInstruction instruction = new DisplayWorldSectionInstruction(0, class_2350.field_11033, selection, Optional.empty());
            SceneBuilder.this.addInstruction(instruction);
            return instruction.createLink(SceneBuilder.this.scene);
        }

        public void hideSection(Selection selection, class_2350 fadeOutDirection) {
            WorldSectionElement worldSectionElement = new WorldSectionElement(selection);
            ElementLink<WorldSectionElement> elementLink = new ElementLink<WorldSectionElement>(WorldSectionElement.class);
            SceneBuilder.this.addInstruction(scene -> {
                scene.getBaseWorldSection().erase(selection);
                scene.linkElement(worldSectionElement, elementLink);
                scene.addElement(worldSectionElement);
                worldSectionElement.queueRedraw();
            });
            this.hideIndependentSection(elementLink, fadeOutDirection);
        }

        public void hideIndependentSection(ElementLink<WorldSectionElement> link, class_2350 fadeOutDirection) {
            SceneBuilder.this.addInstruction(new FadeOutOfSceneInstruction<WorldSectionElement>(15, fadeOutDirection, link));
        }

        public void hideIndependentSection(ElementLink<WorldSectionElement> link, class_2350 fadeOutDirection, int fadeOutDuration) {
            SceneBuilder.this.addInstruction(new FadeOutOfSceneInstruction<WorldSectionElement>(fadeOutDuration, fadeOutDirection, link));
        }

        public void hideIndependentSectionImmediately(ElementLink<WorldSectionElement> link) {
            SceneBuilder.this.addInstruction(new FadeOutOfSceneInstruction<WorldSectionElement>(0, class_2350.field_11033, link));
        }

        public void restoreBlocks(Selection selection) {
            SceneBuilder.this.addInstruction(scene -> scene.getWorld().restoreBlocks(selection));
        }

        public ElementLink<WorldSectionElement> makeSectionIndependent(Selection selection) {
            WorldSectionElement worldSectionElement = new WorldSectionElement(selection);
            ElementLink<WorldSectionElement> elementLink = new ElementLink<WorldSectionElement>(WorldSectionElement.class);
            SceneBuilder.this.addInstruction(scene -> {
                scene.getBaseWorldSection().erase(selection);
                scene.linkElement(worldSectionElement, elementLink);
                scene.addElement(worldSectionElement);
                worldSectionElement.queueRedraw();
                worldSectionElement.resetAnimatedTransform();
                worldSectionElement.setVisible(true);
                worldSectionElement.forceApplyFade(1.0f);
            });
            return elementLink;
        }

        public void rotateSection(ElementLink<WorldSectionElement> link, double xRotation, double yRotation, double zRotation, int duration) {
            SceneBuilder.this.addInstruction(AnimateWorldSectionInstruction.rotate(link, new class_243(xRotation, yRotation, zRotation), duration));
        }

        public void configureCenterOfRotation(ElementLink<WorldSectionElement> link, class_243 anchor) {
            SceneBuilder.this.addInstruction(scene -> ((WorldSectionElement)scene.resolve(link)).setCenterOfRotation(anchor));
        }

        public void configureStabilization(ElementLink<WorldSectionElement> link, class_243 anchor) {
            SceneBuilder.this.addInstruction(scene -> ((WorldSectionElement)scene.resolve(link)).stabilizeRotation(anchor));
        }

        public void moveSection(ElementLink<WorldSectionElement> link, class_243 offset, int duration) {
            SceneBuilder.this.addInstruction(AnimateWorldSectionInstruction.move(link, offset, duration));
        }

        public void rotateBearing(class_2338 pos, float angle, int duration) {
            SceneBuilder.this.addInstruction(AnimateBlockEntityInstruction.bearing(pos, angle, duration));
        }

        public void movePulley(class_2338 pos, float distance, int duration) {
            SceneBuilder.this.addInstruction(AnimateBlockEntityInstruction.pulley(pos, distance, duration));
        }

        public void animateBogey(class_2338 pos, float distance, int duration) {
            SceneBuilder.this.addInstruction(AnimateBlockEntityInstruction.bogey(pos, distance, duration + 1));
        }

        public void moveDeployer(class_2338 pos, float distance, int duration) {
            SceneBuilder.this.addInstruction(AnimateBlockEntityInstruction.deployer(pos, distance, duration));
        }

        public void setBlocks(Selection selection, class_2680 state, boolean spawnParticles) {
            SceneBuilder.this.addInstruction(new ReplaceBlocksInstruction(selection, $ -> state, true, spawnParticles));
        }

        public void destroyBlock(class_2338 pos) {
            this.setBlock(pos, class_2246.field_10124.method_9564(), true);
        }

        public void setBlock(class_2338 pos, class_2680 state, boolean spawnParticles) {
            this.setBlocks(SceneBuilder.this.scene.getSceneBuildingUtil().select.position(pos), state, spawnParticles);
        }

        public void replaceBlocks(Selection selection, class_2680 state, boolean spawnParticles) {
            this.modifyBlocks(selection, $ -> state, spawnParticles);
        }

        public void modifyBlock(class_2338 pos, UnaryOperator<class_2680> stateFunc, boolean spawnParticles) {
            this.modifyBlocks(SceneBuilder.this.scene.getSceneBuildingUtil().select.position(pos), stateFunc, spawnParticles);
        }

        public void cycleBlockProperty(class_2338 pos, class_2769<?> property) {
            this.modifyBlocks(SceneBuilder.this.scene.getSceneBuildingUtil().select.position(pos), s -> s.method_28498(property) ? (class_2680)s.method_28493(property) : s, false);
        }

        public void modifyBlocks(Selection selection, UnaryOperator<class_2680> stateFunc, boolean spawnParticles) {
            SceneBuilder.this.addInstruction(new ReplaceBlocksInstruction(selection, stateFunc, false, spawnParticles));
        }

        public void toggleRedstonePower(Selection selection) {
            this.modifyBlocks(selection, s -> {
                if (s.method_28498((class_2769)class_2741.field_12511)) {
                    s = (class_2680)s.method_11657((class_2769)class_2741.field_12511, (Comparable)Integer.valueOf((Integer)s.method_11654((class_2769)class_2741.field_12511) == 0 ? 15 : 0));
                }
                if (s.method_28498((class_2769)class_2741.field_12484)) {
                    s = (class_2680)s.method_28493((class_2769)class_2741.field_12484);
                }
                if (s.method_28498((class_2769)class_2459.field_11446)) {
                    s = (class_2680)s.method_28493((class_2769)class_2459.field_11446);
                }
                return s;
            }, false);
        }

        public <T extends class_1297> void modifyEntities(Class<T> entityClass, Consumer<T> entityCallBack) {
            SceneBuilder.this.addInstruction(scene -> scene.forEachWorldEntity(entityClass, entityCallBack));
        }

        public <T extends class_1297> void modifyEntitiesInside(Class<T> entityClass, Selection area, Consumer<T> entityCallBack) {
            SceneBuilder.this.addInstruction(scene -> scene.forEachWorldEntity(entityClass, e -> {
                if (area.test(e.method_24515())) {
                    entityCallBack.accept(e);
                }
            }));
        }

        public void modifyEntity(ElementLink<EntityElement> link, Consumer<class_1297> entityCallBack) {
            SceneBuilder.this.addInstruction(scene -> {
                EntityElement resolve = (EntityElement)scene.resolve(link);
                if (resolve != null) {
                    resolve.ifPresent(entityCallBack::accept);
                }
            });
        }

        public ElementLink<EntityElement> createEntity(Function<class_1937, class_1297> factory) {
            ElementLink<EntityElement> link = new ElementLink<EntityElement>(EntityElement.class, UUID.randomUUID());
            SceneBuilder.this.addInstruction(scene -> {
                PonderWorld world = scene.getWorld();
                class_1297 entity = (class_1297)factory.apply(world);
                EntityElement handle = new EntityElement(entity);
                scene.addElement(handle);
                scene.linkElement(handle, link);
                world.method_8649(entity);
            });
            return link;
        }

        public ElementLink<EntityElement> createItemEntity(class_243 location, class_243 motion, class_1799 stack) {
            return this.createEntity(world -> {
                class_1542 itemEntity = new class_1542(world, location.field_1352, location.field_1351, location.field_1350, stack);
                itemEntity.method_18799(motion);
                return itemEntity;
            });
        }

        public void createItemOnBeltLike(class_2338 location, class_2350 insertionSide, class_1799 stack) {
            SceneBuilder.this.addInstruction(scene -> {
                PonderWorld world = scene.getWorld();
                class_2586 blockEntity = world.method_8321(location);
                if (!(blockEntity instanceof SmartBlockEntity)) {
                    return;
                }
                SmartBlockEntity beltBlockEntity = (SmartBlockEntity)blockEntity;
                DirectBeltInputBehaviour behaviour = beltBlockEntity.getBehaviour(DirectBeltInputBehaviour.TYPE);
                if (behaviour == null) {
                    return;
                }
                behaviour.handleInsertion(stack, insertionSide.method_10153(), false);
            });
            this.flapFunnel(location.method_10084(), true);
        }

        public ElementLink<BeltItemElement> createItemOnBelt(class_2338 beltLocation, class_2350 insertionSide, class_1799 stack) {
            ElementLink<BeltItemElement> link = new ElementLink<BeltItemElement>(BeltItemElement.class);
            SceneBuilder.this.addInstruction(scene -> {
                PonderWorld world = scene.getWorld();
                class_2586 blockEntity = world.method_8321(beltLocation);
                if (!(blockEntity instanceof BeltBlockEntity)) {
                    return;
                }
                BeltBlockEntity beltBlockEntity = (BeltBlockEntity)blockEntity;
                DirectBeltInputBehaviour behaviour = beltBlockEntity.getBehaviour(DirectBeltInputBehaviour.TYPE);
                behaviour.handleInsertion(stack, insertionSide.method_10153(), false);
                BeltBlockEntity controllerBE = beltBlockEntity.getControllerBE();
                if (controllerBE != null) {
                    controllerBE.tick();
                }
                TransportedItemStackHandlerBehaviour transporter = beltBlockEntity.getBehaviour(TransportedItemStackHandlerBehaviour.TYPE);
                transporter.handleProcessingOnAllItems(tis -> {
                    BeltItemElement tracker = new BeltItemElement((TransportedItemStack)tis);
                    scene.addElement(tracker);
                    scene.linkElement(tracker, link);
                    return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
                });
            });
            this.flapFunnel(beltLocation.method_10084(), true);
            return link;
        }

        public void removeItemsFromBelt(class_2338 beltLocation) {
            SceneBuilder.this.addInstruction(scene -> {
                PonderWorld world = scene.getWorld();
                class_2586 blockEntity = world.method_8321(beltLocation);
                if (!(blockEntity instanceof SmartBlockEntity)) {
                    return;
                }
                SmartBlockEntity beltBlockEntity = (SmartBlockEntity)blockEntity;
                TransportedItemStackHandlerBehaviour transporter = beltBlockEntity.getBehaviour(TransportedItemStackHandlerBehaviour.TYPE);
                if (transporter == null) {
                    return;
                }
                transporter.handleCenteredProcessingOnAllItems(0.52f, tis -> TransportedItemStackHandlerBehaviour.TransportedResult.removeItem());
            });
        }

        public void stallBeltItem(ElementLink<BeltItemElement> link, boolean stalled) {
            SceneBuilder.this.addInstruction(scene -> {
                BeltItemElement resolve = (BeltItemElement)scene.resolve(link);
                if (resolve != null) {
                    resolve.ifPresent(tis -> {
                        tis.locked = stalled;
                    });
                }
            });
        }

        public void changeBeltItemTo(ElementLink<BeltItemElement> link, class_1799 newStack) {
            SceneBuilder.this.addInstruction(scene -> {
                BeltItemElement resolve = (BeltItemElement)scene.resolve(link);
                if (resolve != null) {
                    resolve.ifPresent(tis -> {
                        tis.stack = newStack;
                    });
                }
            });
        }

        public void setKineticSpeed(Selection selection, float speed) {
            this.modifyKineticSpeed(selection, f -> Float.valueOf(speed));
        }

        public void multiplyKineticSpeed(Selection selection, float modifier) {
            this.modifyKineticSpeed(selection, f -> Float.valueOf(f.floatValue() * modifier));
        }

        public void modifyKineticSpeed(Selection selection, UnaryOperator<Float> speedFunc) {
            this.modifyBlockEntityNBT(selection, SpeedGaugeBlockEntity.class, nbt -> {
                float newSpeed = ((Float)speedFunc.apply(Float.valueOf(nbt.method_10583("Speed")))).floatValue();
                nbt.method_10548("Value", SpeedGaugeBlockEntity.getDialTarget(newSpeed));
            });
            this.modifyBlockEntityNBT(selection, KineticBlockEntity.class, nbt -> nbt.method_10548("Speed", ((Float)speedFunc.apply(Float.valueOf(nbt.method_10583("Speed")))).floatValue()));
        }

        public void propagatePipeChange(class_2338 pos) {
            this.modifyBlockEntity(pos, PumpBlockEntity.class, be -> be.onSpeedChanged(0.0f));
        }

        public void setFilterData(Selection selection, Class<? extends class_2586> teType, class_1799 filter) {
            this.modifyBlockEntityNBT(selection, teType, nbt -> nbt.method_10566("Filter", NBTSerializer.serializeNBT((Object)filter)));
        }

        public void modifyBlockEntityNBT(Selection selection, Class<? extends class_2586> beType, Consumer<class_2487> consumer) {
            this.modifyBlockEntityNBT(selection, beType, consumer, false);
        }

        public <T extends class_2586> void modifyBlockEntity(class_2338 position, Class<T> beType, Consumer<T> consumer) {
            SceneBuilder.this.addInstruction(scene -> {
                class_2586 blockEntity = scene.getWorld().method_8321(position);
                if (beType.isInstance(blockEntity)) {
                    consumer.accept((class_2586)beType.cast(blockEntity));
                }
            });
        }

        public void modifyBlockEntityNBT(Selection selection, Class<? extends class_2586> teType, Consumer<class_2487> consumer, boolean reDrawBlocks) {
            SceneBuilder.this.addInstruction(new BlockEntityDataInstruction(selection, teType, nbt -> {
                consumer.accept((class_2487)nbt);
                return nbt;
            }, reDrawBlocks));
        }

        public void instructArm(class_2338 armLocation, ArmBlockEntity.Phase phase, class_1799 heldItem, int targetedPoint) {
            this.modifyBlockEntityNBT(SceneBuilder.this.scene.getSceneBuildingUtil().select.position(armLocation), ArmBlockEntity.class, compound -> {
                NBTHelper.writeEnum(compound, "Phase", phase);
                compound.method_10566("HeldItem", NBTSerializer.serializeNBT((Object)heldItem));
                compound.method_10569("TargetPointIndex", targetedPoint);
                compound.method_10548("MovementProgress", 0.0f);
            });
        }

        public void flapFunnel(class_2338 position, boolean outward) {
            this.modifyBlockEntity(position, FunnelBlockEntity.class, funnel -> funnel.flap(!outward));
        }

        public void setCraftingResult(class_2338 crafter, class_1799 output) {
            this.modifyBlockEntity(crafter, MechanicalCrafterBlockEntity.class, mct -> mct.setScriptedResult(output));
        }

        public void connectCrafterInvs(class_2338 position1, class_2338 position2) {
            SceneBuilder.this.addInstruction(s -> {
                ConnectedInputHandler.toggleConnection(s.getWorld(), position1, position2);
                s.forEach(WorldSectionElement.class, WorldSectionElement::queueRedraw);
            });
        }

        public void toggleControls(class_2338 position) {
            this.cycleBlockProperty(position, (class_2769<?>)ControlsBlock.VIRTUAL);
        }

        public void animateTrainStation(class_2338 position, boolean trainPresent) {
            this.modifyBlockEntityNBT(SceneBuilder.this.scene.getSceneBuildingUtil().select.position(position), StationBlockEntity.class, c -> c.method_10556("ForceFlag", trainPresent));
        }

        public void conductorBlaze(class_2338 position, boolean conductor) {
            this.modifyBlockEntityNBT(SceneBuilder.this.scene.getSceneBuildingUtil().select.position(position), BlazeBurnerBlockEntity.class, c -> c.method_10556("TrainHat", conductor));
        }

        public void changeSignalState(class_2338 position, SignalBlockEntity.SignalState state) {
            this.modifyBlockEntityNBT(SceneBuilder.this.scene.getSceneBuildingUtil().select.position(position), SignalBlockEntity.class, c -> NBTHelper.writeEnum(c, "State", state));
        }

        public void setDisplayBoardText(class_2338 position, int line, class_2561 text) {
            this.modifyBlockEntity(position, FlapDisplayBlockEntity.class, t -> t.applyTextManually(line, class_2561.class_2562.method_10867((class_2561)text)));
        }

        public void dyeDisplayBoard(class_2338 position, int line, class_1767 color) {
            this.modifyBlockEntity(position, FlapDisplayBlockEntity.class, t -> t.setColour(line, color));
        }

        public void flashDisplayLink(class_2338 position) {
            this.modifyBlockEntity(position, DisplayLinkBlockEntity.class, linkBlockEntity -> linkBlockEntity.glow.setValue(2.0));
        }
    }

    public class DebugInstructions {
        public void debugSchematic() {
            SceneBuilder.this.addInstruction(scene -> scene.addElement(new WorldSectionElement(scene.getSceneBuildingUtil().select.everywhere())));
        }

        public void addInstructionInstance(PonderInstruction instruction) {
            SceneBuilder.this.addInstruction(instruction);
        }

        public void enqueueCallback(Consumer<PonderScene> callback) {
            SceneBuilder.this.addInstruction(callback);
        }
    }

    public class EffectInstructions {
        public void emitParticles(class_243 location, EmitParticlesInstruction.Emitter emitter, float amountPerCycle, int cycles) {
            SceneBuilder.this.addInstruction(new EmitParticlesInstruction(location, emitter, amountPerCycle, cycles));
        }

        public void superGlue(class_2338 pos, class_2350 side, boolean fullBlock) {
            SceneBuilder.this.addInstruction(scene -> SuperGlueItem.spawnParticles(scene.getWorld(), pos, side, fullBlock));
        }

        private void rotationIndicator(class_2338 pos, boolean direction, class_2338 displayPos) {
            SceneBuilder.this.addInstruction(scene -> {
                class_2680 blockState = scene.getWorld().method_8320(pos);
                class_2586 blockEntity = scene.getWorld().method_8321(pos);
                if (!(blockState.method_26204() instanceof KineticBlock)) {
                    return;
                }
                if (!(blockEntity instanceof KineticBlockEntity)) {
                    return;
                }
                KineticBlockEntity kbe = (KineticBlockEntity)blockEntity;
                KineticBlock kb = (KineticBlock)blockState.method_26204();
                class_2350.class_2351 rotationAxis = kb.getRotationAxis(blockState);
                float speed = kbe.getTheoreticalSpeed();
                IRotate.SpeedLevel speedLevel = IRotate.SpeedLevel.of(speed);
                int color = direction ? (speed > 0.0f ? 15425035 : 1476519) : speedLevel.getColor();
                int particleSpeed = speedLevel.getParticleSpeed();
                particleSpeed = (int)((float)particleSpeed * Math.signum(speed));
                class_243 location = VecHelper.getCenterOf((class_2382)displayPos);
                RotationIndicatorParticleData particleData = new RotationIndicatorParticleData(color, particleSpeed, kb.getParticleInitialRadius(), kb.getParticleTargetRadius(), 20, rotationAxis.name().charAt(0));
                for (int i = 0; i < 20; ++i) {
                    scene.getWorld().method_8406(particleData, location.field_1352, location.field_1351, location.field_1350, 0.0, 0.0, 0.0);
                }
            });
        }

        public void rotationSpeedIndicator(class_2338 pos) {
            this.rotationIndicator(pos, false, pos);
        }

        public void rotationDirectionIndicator(class_2338 pos) {
            this.rotationIndicator(pos, true, pos);
        }

        public void rotationSpeedIndicator(class_2338 pos, class_2338 displayPos) {
            this.rotationIndicator(pos, false, displayPos);
        }

        public void rotationDirectionIndicator(class_2338 pos, class_2338 displayPos) {
            this.rotationIndicator(pos, true, displayPos);
        }

        public void indicateRedstone(class_2338 pos) {
            this.createRedstoneParticles(pos, 0xFF0000, 10);
        }

        public void indicateSuccess(class_2338 pos) {
            this.createRedstoneParticles(pos, 8454058, 10);
        }

        public void createRedstoneParticles(class_2338 pos, int color, int amount) {
            class_1160 rgb = new Color(color).asVectorF();
            SceneBuilder.this.addInstruction(new EmitParticlesInstruction(VecHelper.getCenterOf((class_2382)pos), EmitParticlesInstruction.Emitter.withinBlockSpace(new class_2390(rgb, 1.0f), class_243.field_1353), amount, 2));
        }
    }
}

