/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.gui.widget;

import com.simibubi.create.foundation.gui.element.RenderElement;
import com.simibubi.create.foundation.gui.element.ScreenElement;
import com.simibubi.create.foundation.gui.widget.AbstractSimiWidget;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import net.minecraft.class_4587;

public class ElementWidget
extends AbstractSimiWidget {
    protected RenderElement element = RenderElement.EMPTY;
    protected boolean usesFade = false;
    protected int fadeModX;
    protected int fadeModY;
    protected LerpedFloat fade = LerpedFloat.linear().startWithValue(1.0);
    protected boolean rescaleElement = false;
    protected float rescaleSizeX;
    protected float rescaleSizeY;
    protected float paddingX = 0.0f;
    protected float paddingY = 0.0f;

    public ElementWidget(int x, int y) {
        super(x, y);
    }

    public ElementWidget(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    public <T extends ElementWidget> T showingElement(RenderElement element) {
        this.element = element;
        return (T)this;
    }

    public <T extends ElementWidget> T showing(ScreenElement renderable) {
        return this.showingElement(RenderElement.of(renderable));
    }

    public <T extends ElementWidget> T modifyElement(Consumer<RenderElement> consumer) {
        if (this.element != null) {
            consumer.accept(this.element);
        }
        return (T)this;
    }

    public <T extends ElementWidget> T mapElement(UnaryOperator<RenderElement> function) {
        if (this.element != null) {
            this.element = (RenderElement)function.apply(this.element);
        }
        return (T)this;
    }

    public <T extends ElementWidget> T withPadding(float paddingX, float paddingY) {
        this.paddingX = paddingX;
        this.paddingY = paddingY;
        return (T)this;
    }

    public <T extends ElementWidget> T enableFade(int fadeModifierX, int fadeModifierY) {
        this.fade.startWithValue(0.0);
        this.usesFade = true;
        this.fadeModX = fadeModifierX;
        this.fadeModY = fadeModifierY;
        return (T)this;
    }

    public <T extends ElementWidget> T disableFade() {
        this.fade.startWithValue(1.0);
        this.usesFade = false;
        return (T)this;
    }

    public LerpedFloat fade() {
        return this.fade;
    }

    public <T extends ElementWidget> T fade(float target) {
        this.fade.chase(target, 0.1, LerpedFloat.Chaser.EXP);
        return (T)this;
    }

    @Deprecated
    public <T extends ElementWidget> T rescaleElement(float rescaleSizeX, float rescaleSizeY) {
        this.rescaleElement = true;
        this.rescaleSizeX = rescaleSizeX;
        this.rescaleSizeY = rescaleSizeY;
        return (T)this;
    }

    public <T extends ElementWidget> T disableRescale() {
        this.rescaleElement = false;
        return (T)this;
    }

    @Override
    public void tick() {
        super.tick();
        this.fade.tickChaser();
    }

    @Override
    protected void beforeRender(@Nonnull class_4587 ms, int mouseX, int mouseY, float partialTicks) {
        super.beforeRender(ms, mouseX, mouseY, partialTicks);
        this.field_22762 = this.method_25405(mouseX, mouseY);
        float fadeValue = this.fade.getValue(partialTicks);
        this.element.withAlpha(fadeValue);
        if (fadeValue < 1.0f) {
            ms.method_22904((double)((1.0f - fadeValue) * (float)this.fadeModX), (double)((1.0f - fadeValue) * (float)this.fadeModY), 0.0);
        }
    }

    @Override
    public void method_25359(@Nonnull class_4587 ms, int mouseX, int mouseY, float partialTicks) {
        ms.method_22903();
        ms.method_22904((double)((float)this.field_22760 + this.paddingX), (double)((float)this.field_22761 + this.paddingY), (double)this.z);
        float innerWidth = (float)this.field_22758 - 2.0f * this.paddingX;
        float innerHeight = (float)this.field_22759 - 2.0f * this.paddingY;
        float eX = this.element.getX();
        float eY = this.element.getY();
        if (this.rescaleElement) {
            float xScale = innerWidth / this.rescaleSizeX;
            float yScale = innerHeight / this.rescaleSizeY;
            ms.method_22905(xScale, yScale, 1.0f);
            this.element.at(eX / xScale, eY / yScale);
            innerWidth /= xScale;
            innerHeight /= yScale;
        }
        ((RenderElement)this.element.withBounds((int)innerWidth, (int)innerHeight)).render(ms);
        ms.method_22909();
        if (this.rescaleElement) {
            this.element.at(eX, eY);
        }
    }

    public RenderElement getRenderElement() {
        return this.element;
    }
}

