/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.foundation.gui.ILightingSettings;
import net.minecraft.class_1159;
import net.minecraft.class_1160;

public class CustomLightingSettings
implements ILightingSettings {
    private class_1160 light1;
    private class_1160 light2;
    private class_1159 lightMatrix;

    protected CustomLightingSettings(float yRot, float xRot) {
        this.init(yRot, xRot, 0.0f, 0.0f, false);
    }

    protected CustomLightingSettings(float yRot1, float xRot1, float yRot2, float xRot2) {
        this.init(yRot1, xRot1, yRot2, xRot2, true);
    }

    protected void init(float yRot1, float xRot1, float yRot2, float xRot2, boolean doubleLight) {
        this.light1 = class_1160.field_20707.method_23850();
        this.light1.method_19262(class_1160.field_20705.method_23214(yRot1));
        this.light1.method_19262(class_1160.field_20702.method_23214(xRot1));
        if (doubleLight) {
            this.light2 = class_1160.field_20707.method_23850();
            this.light2.method_19262(class_1160.field_20705.method_23214(yRot2));
            this.light2.method_19262(class_1160.field_20702.method_23214(xRot2));
        } else {
            this.light2 = class_1160.field_29501;
        }
        this.lightMatrix = new class_1159();
        this.lightMatrix.method_22668();
    }

    @Override
    public void applyLighting() {
        RenderSystem.setupLevelDiffuseLighting((class_1160)this.light1, (class_1160)this.light2, (class_1159)this.lightMatrix);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private float yRot1;
        private float xRot1;
        private float yRot2;
        private float xRot2;
        private boolean doubleLight;

        public Builder firstLightRotation(float yRot, float xRot) {
            this.yRot1 = yRot;
            this.xRot1 = xRot;
            return this;
        }

        public Builder secondLightRotation(float yRot, float xRot) {
            this.yRot2 = yRot;
            this.xRot2 = xRot;
            this.doubleLight = true;
            return this;
        }

        public Builder doubleLight() {
            this.doubleLight = true;
            return this;
        }

        public CustomLightingSettings build() {
            if (this.doubleLight) {
                return new CustomLightingSettings(this.yRot1, this.xRot1, this.yRot2, this.xRot2);
            }
            return new CustomLightingSettings(this.yRot1, this.xRot1);
        }
    }
}

