/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.blockEntity.behaviour.inventory;

import com.simibubi.create.foundation.utility.fabric.ListeningStorageView;
import com.simibubi.create.foundation.utility.fabric.ProcessingIterator;
import io.github.fabricators_of_create.porting_lib.transfer.callbacks.TransactionCallback;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VersionedInventoryWrapper
implements Storage<ItemVariant> {
    public static final AtomicInteger idGenerator = new AtomicInteger();
    private Storage<ItemVariant> inventory;
    private int version;
    private int id = idGenerator.getAndIncrement();

    public VersionedInventoryWrapper(Storage<ItemVariant> inventory) {
        this.inventory = inventory;
        this.version = 0;
    }

    public void incrementVersion() {
        ++this.version;
    }

    private void listen(TransactionContext transaction) {
        TransactionCallback.onSuccess((TransactionContext)transaction, this::incrementVersion);
    }

    public int getId() {
        return this.id;
    }

    public long getVersion() {
        return this.version;
    }

    public boolean supportsInsertion() {
        return this.inventory.supportsInsertion();
    }

    public boolean supportsExtraction() {
        return this.inventory.supportsExtraction();
    }

    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        this.listen(transaction);
        return this.inventory.insert((Object)resource, maxAmount, transaction);
    }

    public long simulateInsert(ItemVariant resource, long maxAmount, @Nullable TransactionContext transaction) {
        this.listen(transaction);
        return this.inventory.simulateInsert((Object)resource, maxAmount, transaction);
    }

    public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        this.listen(transaction);
        return this.inventory.extract((Object)resource, maxAmount, transaction);
    }

    public long simulateExtract(ItemVariant resource, long maxAmount, @Nullable TransactionContext transaction) {
        this.listen(transaction);
        return this.inventory.simulateExtract((Object)resource, maxAmount, transaction);
    }

    @NotNull
    public Iterator<StorageView<ItemVariant>> iterator() {
        return new ProcessingIterator<StorageView<ItemVariant>>(this.inventory.iterator(), view -> new ListeningStorageView(view, this::incrementVersion));
    }

    @Nullable
    public StorageView<ItemVariant> exactView(ItemVariant resource) {
        return new ListeningStorageView<ItemVariant>(super.exactView((Object)resource), this::incrementVersion);
    }

    @Nullable
    public StorageView<ItemVariant> exactView(TransactionContext transaction, ItemVariant resource) {
        this.listen(transaction);
        return this.inventory.exactView(transaction, (Object)resource);
    }
}

