/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.blockEntity.behaviour.filtering;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.logistics.filter.FilterItem;
import com.simibubi.create.content.logistics.filter.FilterItemStack;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBoard;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsFormatter;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.VecHelper;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemHandlerHelper;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import io.github.fabricators_of_create.porting_lib.util.NBTSerializer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.PlayerInventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_5250;

public class FilteringBehaviour
extends BlockEntityBehaviour
implements ValueSettingsBehaviour {
    public static final BehaviourType<FilteringBehaviour> TYPE = new BehaviourType();
    public class_5250 customLabel;
    ValueBoxTransform slotPositioning;
    boolean showCount;
    private FilterItemStack filter = FilterItemStack.empty();
    public int count;
    public boolean upTo;
    private Predicate<class_1799> predicate;
    private Consumer<class_1799> callback;
    private Supplier<Boolean> isActive;
    private Supplier<Boolean> showCountPredicate;
    boolean recipeFilter;
    boolean fluidFilter;

    public FilteringBehaviour(SmartBlockEntity be, ValueBoxTransform slot) {
        super(be);
        this.slotPositioning = slot;
        this.showCount = false;
        this.callback = stack -> {};
        this.predicate = stack -> true;
        this.isActive = () -> true;
        this.count = 64;
        this.showCountPredicate = () -> this.showCount;
        this.recipeFilter = false;
        this.fluidFilter = false;
        this.upTo = true;
    }

    @Override
    public boolean isSafeNBT() {
        return true;
    }

    @Override
    public void write(class_2487 nbt, boolean clientPacket) {
        nbt.method_10566("Filter", NBTSerializer.serializeNBT((Object)this.getFilter()));
        nbt.method_10569("FilterAmount", this.count);
        nbt.method_10556("UpTo", this.upTo);
        super.write(nbt, clientPacket);
    }

    @Override
    public void read(class_2487 nbt, boolean clientPacket) {
        this.filter = FilterItemStack.of(nbt.method_10562("Filter"));
        this.count = nbt.method_10550("FilterAmount");
        this.upTo = nbt.method_10577("UpTo");
        if (this.count == 0) {
            this.upTo = true;
            this.count = this.filter.item().method_7914();
        }
        super.read(nbt, clientPacket);
    }

    public FilteringBehaviour withCallback(Consumer<class_1799> filterCallback) {
        this.callback = filterCallback;
        return this;
    }

    public FilteringBehaviour withPredicate(Predicate<class_1799> filterPredicate) {
        this.predicate = filterPredicate;
        return this;
    }

    public FilteringBehaviour forRecipes() {
        this.recipeFilter = true;
        return this;
    }

    public FilteringBehaviour forFluids() {
        this.fluidFilter = true;
        return this;
    }

    public FilteringBehaviour onlyActiveWhen(Supplier<Boolean> condition) {
        this.isActive = condition;
        return this;
    }

    public FilteringBehaviour showCountWhen(Supplier<Boolean> condition) {
        this.showCountPredicate = condition;
        return this;
    }

    public FilteringBehaviour showCount() {
        this.showCount = true;
        return this;
    }

    public boolean setFilter(class_2350 face, class_1799 stack) {
        return this.setFilter(stack);
    }

    public void setLabel(class_5250 label) {
        this.customLabel = label;
    }

    public boolean setFilter(class_1799 stack) {
        class_1799 filter = stack.method_7972();
        if (!filter.method_7960() && !this.predicate.test(filter)) {
            return false;
        }
        this.filter = FilterItemStack.of(filter);
        if (!this.upTo) {
            this.count = Math.min(this.count, stack.method_7914());
        }
        this.callback.accept(filter);
        this.blockEntity.method_5431();
        this.blockEntity.sendData();
        return true;
    }

    @Override
    public void setValueSettings(class_1657 player, ValueSettingsBehaviour.ValueSettings settings, boolean ctrlDown) {
        if (this.getValueSettings().equals(settings)) {
            return;
        }
        this.count = class_3532.method_15340((int)settings.value(), (int)1, (int)this.filter.item().method_7914());
        this.upTo = settings.row() == 0;
        this.blockEntity.method_5431();
        this.blockEntity.sendData();
        this.playFeedbackSound(this);
    }

    @Override
    public ValueSettingsBehaviour.ValueSettings getValueSettings() {
        return new ValueSettingsBehaviour.ValueSettings(this.upTo ? 0 : 1, this.count == 0 ? this.filter.item().method_7914() : this.count);
    }

    @Override
    public void destroy() {
        if (this.filter.isFilterItem()) {
            class_243 pos = VecHelper.getCenterOf((class_2382)this.getPos());
            class_1937 world = this.getWorld();
            world.method_8649((class_1297)new class_1542(world, pos.field_1352, pos.field_1351, pos.field_1350, this.filter.item().method_7972()));
        }
        super.destroy();
    }

    @Override
    public ItemRequirement getRequiredItems() {
        if (this.filter.isFilterItem()) {
            return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, this.filter.item());
        }
        return ItemRequirement.NONE;
    }

    public class_1799 getFilter(class_2350 side) {
        return this.getFilter();
    }

    public class_1799 getFilter() {
        return this.filter.item();
    }

    public boolean isCountVisible() {
        return this.showCountPredicate.get() != false && this.filter.item().method_7914() > 1;
    }

    public boolean test(class_1799 stack) {
        return !this.isActive() || this.filter.test(this.blockEntity.method_10997(), stack);
    }

    public boolean test(FluidStack stack) {
        return !this.isActive() || this.filter.test(this.blockEntity.method_10997(), stack);
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    @Override
    public boolean testHit(class_243 hit) {
        class_2680 state = this.blockEntity.method_11010();
        class_243 localHit = hit.method_1020(class_243.method_24954((class_2382)this.blockEntity.method_11016()));
        return this.slotPositioning.testHit(state, localHit);
    }

    public int getAmount() {
        return this.count;
    }

    public boolean anyAmount() {
        return this.count == 0;
    }

    @Override
    public boolean acceptsValueSettings() {
        return this.isCountVisible();
    }

    @Override
    public boolean isActive() {
        return this.isActive.get();
    }

    @Override
    public ValueBoxTransform getSlotPositioning() {
        return this.slotPositioning;
    }

    @Override
    public ValueSettingsBoard createBoard(class_1657 player, class_3965 hitResult) {
        class_1799 filter = this.getFilter(hitResult.method_17780());
        int maxAmount = filter.method_7909() instanceof FilterItem ? 64 : filter.method_7914();
        return new ValueSettingsBoard((class_2561)Lang.translateDirect("logistics.filter.extracted_amount", new Object[0]), maxAmount, 16, Lang.translatedOptions("logistics.filter", "up_to", "exactly"), new ValueSettingsFormatter(this::formatValue));
    }

    public class_5250 formatValue(ValueSettingsBehaviour.ValueSettings value) {
        if (value.row() == 0 && value.value() == this.filter.item().method_7914()) {
            return Lang.translateDirect("logistics.filter.any_amount_short", new Object[0]);
        }
        return Components.literal((value.row() == 0 ? "\u2264" : "=") + Math.max(1, value.value()));
    }

    @Override
    public void onShortInteract(class_1657 player, class_1268 hand, class_2350 side) {
        class_1937 level = this.getWorld();
        class_2338 pos = this.getPos();
        class_1799 itemInHand = player.method_5998(hand);
        class_1799 toApply = itemInHand.method_7972();
        if (AllItems.WRENCH.isIn(toApply)) {
            return;
        }
        if (AllBlocks.MECHANICAL_ARM.isIn(toApply)) {
            return;
        }
        if (level.method_8608()) {
            return;
        }
        if (this.getFilter(side).method_7909() instanceof FilterItem && (!player.method_7337() || ItemHelper.extract((Storage<ItemVariant>)PlayerInventoryStorage.of((class_1657)player), stack -> ItemHandlerHelper.canItemStacksStack((class_1799)stack, (class_1799)this.getFilter(side)), true).method_7960())) {
            player.method_31548().method_7398(this.getFilter(side).method_7972());
        }
        if (toApply.method_7909() instanceof FilterItem) {
            toApply.method_7939(1);
        }
        if (!this.setFilter(side, toApply)) {
            player.method_7353((class_2561)Lang.translateDirect("logistics.filter.invalid_item", new Object[0]), true);
            AllSoundEvents.DENY.playOnServer(player.field_6002, (class_2382)player.method_24515(), 1.0f, 1.0f);
            return;
        }
        if (!player.method_7337() && toApply.method_7909() instanceof FilterItem) {
            if (itemInHand.method_7947() == 1) {
                player.method_6122(hand, class_1799.field_8037);
            } else {
                itemInHand.method_7934(1);
            }
        }
        level.method_8396(null, pos, class_3417.field_14667, class_3419.field_15245, 0.25f, 0.1f);
    }

    public class_5250 getLabel() {
        if (this.customLabel != null) {
            return this.customLabel;
        }
        return Lang.translateDirect(this.recipeFilter ? "logistics.recipe_filter" : (this.fluidFilter ? "logistics.fluid_filter" : "logistics.filter"), new Object[0]);
    }

    @Override
    public String getClipboardKey() {
        return "Filtering";
    }

    @Override
    public boolean writeToClipboard(class_2487 tag, class_2350 side) {
        ValueSettingsBehaviour.super.writeToClipboard(tag, side);
        class_1799 filter = this.getFilter(side);
        tag.method_10566("Filter", NBTSerializer.serializeNBT((Object)filter));
        return true;
    }

    @Override
    public boolean readFromClipboard(class_2487 tag, class_1657 player, class_2350 side, boolean simulate) {
        class_1799 copied;
        class_1792 class_17922;
        boolean upstreamResult = ValueSettingsBehaviour.super.readFromClipboard(tag, player, side, simulate);
        if (!tag.method_10545("Filter")) {
            return upstreamResult;
        }
        if (simulate) {
            return true;
        }
        if (this.getWorld().field_9236) {
            return true;
        }
        class_1799 refund = class_1799.field_8037;
        if (this.getFilter(side).method_7909() instanceof FilterItem && !player.method_7337()) {
            refund = this.getFilter(side).method_7972();
        }
        if ((class_17922 = (copied = class_1799.method_7915((class_2487)tag.method_10562("Filter"))).method_7909()) instanceof FilterItem) {
            FilterItem filterType = (FilterItem)class_17922;
            if (!player.method_7337()) {
                PlayerInventoryStorage inv = PlayerInventoryStorage.of((class_1657)player);
                for (boolean preferStacksWithoutData : Iterate.trueAndFalse) {
                    if (refund.method_7909() != filterType && ItemHelper.extract((Storage<ItemVariant>)inv, stack -> stack.method_7909() == filterType && preferStacksWithoutData != stack.method_7985(), 1, false).method_7960()) continue;
                    if (!refund.method_7960() && refund.method_7909() != filterType) {
                        player.method_31548().method_7398(refund);
                    }
                    this.setFilter(side, copied);
                    return true;
                }
                player.method_7353((class_2561)Lang.translate("logistics.filter.requires_item_in_inventory", copied.method_7964().method_27661().method_27692(class_124.field_1068)).style(class_124.field_1061).component(), true);
                AllSoundEvents.DENY.playOnServer(player.field_6002, (class_2382)player.method_24515(), 1.0f, 1.0f);
                return false;
            }
        }
        if (!refund.method_7960()) {
            player.method_31548().method_7398(refund);
        }
        return this.setFilter(side, copied);
    }
}

