/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.track;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.decoration.girder.GirderBlock;
import com.simibubi.create.content.trains.track.BezierConnection;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2482;
import net.minecraft.class_2544;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_3532;

public class TrackPaver {
    public static int paveStraight(class_1937 level, class_2338 startPos, class_243 direction, int extent, class_2248 block, boolean simulate, Set<class_2338> visited) {
        int itemsNeeded = 0;
        class_2680 defaultBlockState = block.method_9564();
        boolean slabLike = defaultBlockState.method_28498((class_2769)class_2482.field_11501);
        boolean wallLike = TrackPaver.isWallLike(defaultBlockState);
        if (slabLike) {
            defaultBlockState = (class_2680)defaultBlockState.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12682);
        }
        if (defaultBlockState.method_26204() instanceof GirderBlock) {
            for (class_2350 d : Iterate.horizontalDirections) {
                if (!class_243.method_24954((class_2382)d.method_10163()).equals((Object)direction)) continue;
                defaultBlockState = (class_2680)((class_2680)((class_2680)((class_2680)defaultBlockState.method_11657((class_2769)GirderBlock.TOP, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)GirderBlock.BOTTOM, (Comparable)Boolean.valueOf(false))).method_11657(GirderBlock.AXIS, (Comparable)d.method_10166())).method_11657((class_2769)(d.method_10166() == class_2350.class_2351.field_11048 ? GirderBlock.X : GirderBlock.Z), (Comparable)Boolean.valueOf(true));
            }
        }
        HashSet<class_2338> toPlaceOn = new HashSet<class_2338>();
        class_243 start = VecHelper.getCenterOf((class_2382)startPos);
        class_243 mainNormal = direction.method_1036(new class_243(0.0, 1.0, 0.0));
        class_243 normalizedNormal = mainNormal.method_1029();
        class_243 normalizedDirection = direction.method_1029();
        float diagFiller = 0.45f;
        for (int i = 0; i < extent; ++i) {
            class_243 offset = direction.method_1021((double)i);
            class_243 mainPos = start.method_1031(offset.field_1352, offset.field_1351, offset.field_1350);
            toPlaceOn.add(new class_2338(mainPos.method_1019(mainNormal)));
            toPlaceOn.add(new class_2338(mainPos.method_1020(mainNormal)));
            if (wallLike) continue;
            toPlaceOn.add(new class_2338(mainPos));
            if (i < extent - 1) {
                for (int x : Iterate.positiveAndNegative) {
                    toPlaceOn.add(new class_2338(mainPos.method_1019(normalizedNormal.method_1021((double)((float)x * diagFiller))).method_1019(normalizedDirection.method_1021((double)diagFiller))));
                }
            }
            if (i <= 0) continue;
            for (int x : Iterate.positiveAndNegative) {
                toPlaceOn.add(new class_2338(mainPos.method_1019(normalizedNormal.method_1021((double)((float)x * diagFiller))).method_1019(normalizedDirection.method_1021((double)(-diagFiller)))));
            }
        }
        class_2680 state = defaultBlockState;
        for (class_2338 p : toPlaceOn) {
            if (!visited.add(p) || !TrackPaver.placeBlockIfFree(level, p, state, simulate)) continue;
            itemsNeeded += slabLike ? 2 : 1;
        }
        visited.addAll(toPlaceOn);
        return itemsNeeded;
    }

    public static int paveCurve(class_1937 level, BezierConnection bc, class_2248 block, boolean simulate, Set<class_2338> visited) {
        int itemsNeeded = 0;
        class_2680 defaultBlockState = block.method_9564();
        boolean slabLike = defaultBlockState.method_28498((class_2769)class_2482.field_11501);
        if (slabLike) {
            defaultBlockState = (class_2680)defaultBlockState.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12682);
        }
        if (TrackPaver.isWallLike(defaultBlockState)) {
            if (AllBlocks.METAL_GIRDER.has(defaultBlockState)) {
                return (bc.getSegmentCount() + 1) / 2 * 2;
            }
            return 0;
        }
        HashMap<Pair<Integer, Integer>, Double> yLevels = new HashMap<Pair<Integer, Integer>, Double>();
        class_2338 tePosition = (class_2338)bc.tePositions.getFirst();
        class_243 end1 = ((class_243)bc.starts.getFirst()).method_1020(class_243.method_24954((class_2382)tePosition)).method_1031(0.0, 0.1875, 0.0);
        class_243 end2 = ((class_243)bc.starts.getSecond()).method_1020(class_243.method_24954((class_2382)tePosition)).method_1031(0.0, 0.1875, 0.0);
        class_243 axis1 = (class_243)bc.axes.getFirst();
        class_243 axis2 = (class_243)bc.axes.getSecond();
        double handleLength = bc.getHandleLength();
        class_243 finish1 = axis1.method_1021(handleLength).method_1019(end1);
        class_243 finish2 = axis2.method_1021(handleLength).method_1019(end2);
        class_243 faceNormal1 = (class_243)bc.normals.getFirst();
        class_243 faceNormal2 = (class_243)bc.normals.getSecond();
        int segCount = bc.getSegmentCount();
        float[] lut = bc.getStepLUT();
        for (int i = 0; i < segCount; ++i) {
            float t = i == segCount ? 1.0f : (float)i * lut[i] / (float)segCount;
            class_243 result = VecHelper.bezier(end1, end2, finish1, finish2, t += 0.5f / (float)segCount);
            class_243 derivative = VecHelper.bezierDerivative(end1, end2, finish1, finish2, t).method_1029();
            class_243 faceNormal = faceNormal1.equals((Object)faceNormal2) ? faceNormal1 : VecHelper.slerp(t, faceNormal1, faceNormal2);
            class_243 normal = faceNormal.method_1036(derivative).method_1029();
            class_243 below = result.method_1019(faceNormal.method_1021(-1.125));
            class_243 rail1 = below.method_1019(normal.method_1021((double)0.97f));
            class_243 rail2 = below.method_1020(normal.method_1021((double)0.97f));
            class_243 railMiddle = rail1.method_1019(rail2).method_1021(0.5);
            for (class_243 vec : new class_243[]{rail1, rail2, railMiddle}) {
                class_2338 pos = new class_2338(vec);
                Pair<Integer, Integer> key = Pair.of(pos.method_10263(), pos.method_10260());
                if (yLevels.containsKey(key) && !((Double)yLevels.get(key) > vec.field_1351)) continue;
                yLevels.put(key, vec.field_1351);
            }
        }
        for (Map.Entry entry : yLevels.entrySet()) {
            class_2680 stateToPlace;
            double yValue = (Double)entry.getValue();
            int floor = class_3532.method_15357((double)yValue);
            boolean placeSlab = slabLike && yValue - (double)floor >= 0.5;
            class_2338 targetPos = new class_2338(((Integer)((Pair)entry.getKey()).getFirst()).intValue(), floor, ((Integer)((Pair)entry.getKey()).getSecond()).intValue());
            targetPos = targetPos.method_10081((class_2382)tePosition).method_10086(placeSlab ? 1 : 0);
            class_2680 class_26802 = stateToPlace = placeSlab ? (class_2680)defaultBlockState.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12681) : defaultBlockState;
            if (!visited.add(targetPos)) continue;
            if (TrackPaver.placeBlockIfFree(level, targetPos, stateToPlace, simulate)) {
                itemsNeeded += !placeSlab ? 2 : 1;
            }
            if (!placeSlab || !visited.add(targetPos.method_10074())) continue;
            class_2680 topSlab = (class_2680)stateToPlace.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12679);
            if (!TrackPaver.placeBlockIfFree(level, targetPos.method_10074(), topSlab, simulate)) continue;
            ++itemsNeeded;
        }
        return itemsNeeded;
    }

    private static boolean isWallLike(class_2680 defaultBlockState) {
        return defaultBlockState.method_26204() instanceof class_2544 || AllBlocks.METAL_GIRDER.has(defaultBlockState);
    }

    private static boolean placeBlockIfFree(class_1937 level, class_2338 pos, class_2680 state, boolean simulate) {
        class_2680 stateAtPos = level.method_8320(pos);
        if (stateAtPos.method_26204() != state.method_26204() && stateAtPos.method_26207().method_15800()) {
            if (!simulate) {
                level.method_8652(pos, ProperWaterloggedBlock.withWater((class_1936)level, state, pos), 3);
            }
            return true;
        }
        return false;
    }
}

