/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.track;

import com.jozufozu.flywheel.core.PartialModel;
import com.simibubi.create.content.trains.graph.TrackNodeLocation;
import com.simibubi.create.content.trains.track.BezierConnection;
import com.simibubi.create.content.trains.track.BezierTrackPointLocation;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.content.trains.track.TrackShape;
import com.simibubi.create.content.trains.track.TrackTargetingBehaviour;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_4587;
import net.minecraft.class_5321;

public interface ITrackBlock {
    public class_243 getUpNormal(class_1922 var1, class_2338 var2, class_2680 var3);

    public List<class_243> getTrackAxes(class_1922 var1, class_2338 var2, class_2680 var3);

    public class_243 getCurveStart(class_1922 var1, class_2338 var2, class_2680 var3, class_243 var4);

    default public int getYOffsetAt(class_1922 world, class_2338 pos, class_2680 state, class_243 end) {
        return 0;
    }

    public class_2680 getBogeyAnchor(class_1922 var1, class_2338 var2, class_2680 var3);

    public boolean trackEquals(class_2680 var1, class_2680 var2);

    default public class_2680 overlay(class_1922 world, class_2338 pos, class_2680 existing, class_2680 placed) {
        return existing;
    }

    default public double getElevationAtCenter(class_1922 world, class_2338 pos, class_2680 state) {
        return this.isSlope(world, pos, state) ? 0.5 : 0.0;
    }

    public static Collection<TrackNodeLocation.DiscoveredLocation> walkConnectedTracks(class_1922 worldIn, TrackNodeLocation location, boolean linear) {
        class_1922 class_19222;
        if (location != null && worldIn instanceof class_3218) {
            class_3218 sl = (class_3218)worldIn;
            class_19222 = sl.method_8503().method_3847(location.dimension);
        } else {
            class_19222 = worldIn;
        }
        class_1922 world = class_19222;
        ArrayList<TrackNodeLocation.DiscoveredLocation> list = new ArrayList<TrackNodeLocation.DiscoveredLocation>();
        for (class_2338 blockPos : location.allAdjacent()) {
            class_2680 blockState = world.method_8320(blockPos);
            class_2248 class_22482 = blockState.method_26204();
            if (!(class_22482 instanceof ITrackBlock)) continue;
            ITrackBlock track = (ITrackBlock)class_22482;
            list.addAll(track.getConnected(world, blockPos, blockState, linear, location));
        }
        return list;
    }

    default public Collection<TrackNodeLocation.DiscoveredLocation> getConnected(class_1922 worldIn, class_2338 pos, class_2680 state, boolean linear, @Nullable TrackNodeLocation connectedTo) {
        class_1922 class_19222;
        if (connectedTo != null && worldIn instanceof class_3218) {
            class_3218 sl = (class_3218)worldIn;
            class_19222 = sl.method_8503().method_3847(connectedTo.dimension);
        } else {
            class_19222 = worldIn;
        }
        class_1922 world = class_19222;
        class_243 center = class_243.method_24955((class_2382)pos).method_1031(0.0, this.getElevationAtCenter(world, pos, state), 0.0);
        ArrayList<TrackNodeLocation.DiscoveredLocation> list = new ArrayList<TrackNodeLocation.DiscoveredLocation>();
        TrackShape shape = (TrackShape)((Object)state.method_11654(TrackBlock.SHAPE));
        List<class_243> trackAxes = this.getTrackAxes(world, pos, state);
        trackAxes.forEach(axis -> {
            BiFunction<Double, Boolean, class_243> offsetFactory = (d, b) -> axis.method_1021(b != false ? d : -d.doubleValue()).method_1019(center);
            Function<Boolean, class_5321<class_1937>> dimensionFactory = b -> {
                class_5321 class_53212;
                if (world instanceof class_1937) {
                    class_1937 l = (class_1937)world;
                    class_53212 = l.method_27983();
                } else {
                    class_53212 = class_1937.field_25179;
                }
                return class_53212;
            };
            Function<class_243, Integer> yOffsetFactory = v -> this.getYOffsetAt(world, pos, state, (class_243)v);
            ITrackBlock.addToListIfConnected(connectedTo, list, offsetFactory, b -> shape.getNormal(), dimensionFactory, yOffsetFactory, axis, null, (b, v) -> ITrackBlock.getMaterialSimple(world, v));
        });
        return list;
    }

    public static TrackMaterial getMaterialSimple(class_1922 world, class_243 pos) {
        return ITrackBlock.getMaterialSimple(world, pos, TrackMaterial.ANDESITE);
    }

    public static TrackMaterial getMaterialSimple(class_1922 world, class_243 pos, TrackMaterial defaultMaterial) {
        class_2248 block;
        if (defaultMaterial == null) {
            defaultMaterial = TrackMaterial.ANDESITE;
        }
        if (world != null && (block = world.method_8320(new class_2338(pos)).method_26204()) instanceof ITrackBlock) {
            ITrackBlock track = (ITrackBlock)block;
            return track.getMaterial();
        }
        return defaultMaterial;
    }

    public static void addToListIfConnected(@Nullable TrackNodeLocation fromEnd, Collection<TrackNodeLocation.DiscoveredLocation> list, BiFunction<Double, Boolean, class_243> offsetFactory, Function<Boolean, class_243> normalFactory, Function<Boolean, class_5321<class_1937>> dimensionFactory, Function<class_243, Integer> yOffsetFactory, class_243 axis, BezierConnection viaTurn, BiFunction<Boolean, class_243, TrackMaterial> materialFactory) {
        class_243 firstOffset = offsetFactory.apply(0.5, true);
        TrackNodeLocation.DiscoveredLocation firstLocation = new TrackNodeLocation.DiscoveredLocation(dimensionFactory.apply(true), firstOffset).viaTurn(viaTurn).materialA(materialFactory.apply(true, offsetFactory.apply(0.0, true))).materialB(materialFactory.apply(true, offsetFactory.apply(1.0, true))).withNormal(normalFactory.apply(true)).withDirection(axis).withYOffset(yOffsetFactory.apply(firstOffset));
        class_243 secondOffset = offsetFactory.apply(0.5, false);
        TrackNodeLocation.DiscoveredLocation secondLocation = new TrackNodeLocation.DiscoveredLocation(dimensionFactory.apply(false), secondOffset).viaTurn(viaTurn).materialA(materialFactory.apply(false, offsetFactory.apply(0.0, false))).materialB(materialFactory.apply(false, offsetFactory.apply(1.0, false))).withNormal(normalFactory.apply(false)).withDirection(axis).withYOffset(yOffsetFactory.apply(secondOffset));
        if (!firstLocation.dimension.equals(secondLocation.dimension)) {
            firstLocation.forceNode();
            secondLocation.forceNode();
        }
        boolean skipFirst = false;
        boolean skipSecond = false;
        if (fromEnd != null) {
            boolean equalsFirst = firstLocation.equals((Object)fromEnd);
            boolean equalsSecond = secondLocation.equals((Object)fromEnd);
            if (!equalsFirst && !equalsSecond) {
                return;
            }
            if (equalsFirst) {
                skipFirst = true;
            }
            if (equalsSecond) {
                skipSecond = true;
            }
        }
        if (!skipFirst) {
            list.add(firstLocation);
        }
        if (!skipSecond) {
            list.add(secondLocation);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public PartialModel prepareTrackOverlay(class_1922 var1, class_2338 var2, class_2680 var3, BezierTrackPointLocation var4, class_2350.class_2352 var5, class_4587 var6, TrackTargetingBehaviour.RenderedTrackOverlayType var7);

    @Environment(value=EnvType.CLIENT)
    public PartialModel prepareAssemblyOverlay(class_1922 var1, class_2338 var2, class_2680 var3, class_2350 var4, class_4587 var5);

    default public boolean isSlope(class_1922 world, class_2338 pos, class_2680 state) {
        return this.getTrackAxes((class_1922)world, (class_2338)pos, (class_2680)state).get((int)0).field_1351 != 0.0;
    }

    default public Pair<class_243, class_2350.class_2352> getNearestTrackAxis(class_1922 world, class_2338 pos, class_2680 state, class_243 lookVec) {
        class_243 best = null;
        double bestDiff = Double.MAX_VALUE;
        for (class_243 vec3 : this.getTrackAxes(world, pos, state)) {
            for (int opposite : Iterate.positiveAndNegative) {
                double distanceTo = vec3.method_1029().method_1022(lookVec.method_1021((double)opposite));
                if (distanceTo > bestDiff) continue;
                bestDiff = distanceTo;
                best = vec3;
            }
        }
        return Pair.of(best, lookVec.method_1026(best.method_18805(1.0, 0.0, 1.0).method_1029()) < 0.0 ? class_2350.class_2352.field_11056 : class_2350.class_2352.field_11060);
    }

    public TrackMaterial getMaterial();
}

