/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.AllKeys;
import com.simibubi.create.content.schematics.client.tools.ToolType;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1041;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class ToolSelectionScreen
extends class_437 {
    public final String scrollToCycle = Lang.translateDirect("gui.toolmenu.cycle", new Object[0]).getString();
    public final String holdToFocus = "gui.toolmenu.focusKey";
    protected List<ToolType> tools;
    protected Consumer<ToolType> callback;
    public boolean focused;
    private float yOffset;
    protected int selection;
    private boolean initialized;
    protected int w;
    protected int h;

    public ToolSelectionScreen(List<ToolType> tools, Consumer<ToolType> callback) {
        super((class_2561)Components.literal("Tool Selection"));
        this.field_22787 = class_310.method_1551();
        this.tools = tools;
        this.callback = callback;
        this.focused = false;
        this.yOffset = 0.0f;
        this.selection = 0;
        this.initialized = false;
        callback.accept(tools.get(this.selection));
        this.w = Math.max(tools.size() * 50 + 30, 220);
        this.h = 30;
    }

    public void setSelectedElement(ToolType tool) {
        if (!this.tools.contains((Object)tool)) {
            return;
        }
        this.selection = this.tools.indexOf((Object)tool);
    }

    public void cycle(int direction) {
        this.selection += direction < 0 ? 1 : -1;
        this.selection = (this.selection + this.tools.size()) % this.tools.size();
    }

    private void draw(class_4587 matrixStack, float partialTicks) {
        class_1041 mainWindow = this.field_22787.method_22683();
        if (!this.initialized) {
            this.method_25423(this.field_22787, mainWindow.method_4486(), mainWindow.method_4502());
        }
        int x = (mainWindow.method_4486() - this.w) / 2 + 15;
        int y = mainWindow.method_4502() - this.h - 75;
        matrixStack.method_22903();
        matrixStack.method_22904(0.0, (double)(-this.yOffset), this.focused ? 100.0 : 0.0);
        AllGuiTextures gray = AllGuiTextures.HUD_BACKGROUND;
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(this.focused ? 0.875f : 0.5f));
        RenderSystem.setShaderTexture((int)0, (class_2960)gray.location);
        ToolSelectionScreen.method_25290((class_4587)matrixStack, (int)(x - 15), (int)y, (float)gray.startX, (float)gray.startY, (int)this.w, (int)this.h, (int)gray.width, (int)gray.height);
        float toolTipAlpha = this.yOffset / 10.0f;
        List<class_2561> toolTip = this.tools.get(this.selection).getDescription();
        int stringAlphaComponent = (int)(toolTipAlpha * 255.0f) << 24;
        if (toolTipAlpha > 0.25f) {
            RenderSystem.setShaderColor((float)0.7f, (float)0.7f, (float)0.8f, (float)toolTipAlpha);
            ToolSelectionScreen.method_25290((class_4587)matrixStack, (int)(x - 15), (int)(y + 33), (float)gray.startX, (float)gray.startY, (int)this.w, (int)(this.h + 22), (int)gray.width, (int)gray.height);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (toolTip.size() > 0) {
                this.field_22793.method_30883(matrixStack, toolTip.get(0), (float)(x - 10), (float)(y + 38), 0xEEEEEE + stringAlphaComponent);
            }
            if (toolTip.size() > 1) {
                this.field_22793.method_30883(matrixStack, toolTip.get(1), (float)(x - 10), (float)(y + 50), 0xCCDDFF + stringAlphaComponent);
            }
            if (toolTip.size() > 2) {
                this.field_22793.method_30883(matrixStack, toolTip.get(2), (float)(x - 10), (float)(y + 60), 0xCCDDFF + stringAlphaComponent);
            }
            if (toolTip.size() > 3) {
                this.field_22793.method_30883(matrixStack, toolTip.get(3), (float)(x - 10), (float)(y + 72), 0xCCCCDD + stringAlphaComponent);
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.tools.size() > 1) {
            String keyName = AllKeys.TOOL_MENU.getBoundKey();
            int width = this.field_22787.method_22683().method_4486();
            if (!this.focused) {
                ToolSelectionScreen.method_27534((class_4587)matrixStack, (class_327)this.field_22787.field_1772, (class_2561)Lang.translateDirect("gui.toolmenu.focusKey", keyName), (int)(width / 2), (int)(y - 10), (int)0xCCDDFF);
            } else {
                ToolSelectionScreen.method_25300((class_4587)matrixStack, (class_327)this.field_22787.field_1772, (String)this.scrollToCycle, (int)(width / 2), (int)(y - 10), (int)0xCCDDFF);
            }
        } else {
            x += 65;
        }
        for (int i = 0; i < this.tools.size(); ++i) {
            float alpha;
            matrixStack.method_22903();
            float f = alpha = this.focused ? 1.0f : 0.2f;
            if (i == this.selection) {
                matrixStack.method_22904(0.0, -10.0, 0.0);
                ToolSelectionScreen.method_25300((class_4587)matrixStack, (class_327)this.field_22787.field_1772, (String)this.tools.get(i).getDisplayName().getString(), (int)(x + i * 50 + 24), (int)(y + 28), (int)0xCCDDFF);
                alpha = 1.0f;
            }
            RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)alpha);
            this.tools.get(i).getIcon().render(matrixStack, x + i * 50 + 16, y + 12, (class_332)this);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            this.tools.get(i).getIcon().render(matrixStack, x + i * 50 + 16, y + 11, (class_332)this);
            matrixStack.method_22909();
        }
        RenderSystem.disableBlend();
        matrixStack.method_22909();
    }

    public void update() {
        this.yOffset = this.focused ? (this.yOffset += (10.0f - this.yOffset) * 0.1f) : (this.yOffset *= 0.9f);
    }

    public void renderPassive(class_4587 matrixStack, float partialTicks) {
        this.draw(matrixStack, partialTicks);
    }

    public void method_25419() {
        this.callback.accept(this.tools.get(this.selection));
    }

    protected void method_25426() {
        super.method_25426();
        this.initialized = true;
    }
}

