/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.processing.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.RegisteredObjects;
import java.util.Random;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2522;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class ProcessingOutput {
    public static final ProcessingOutput EMPTY = new ProcessingOutput(class_1799.field_8037, 1.0f);
    private static final Random r = new Random();
    private final class_1799 stack;
    private final float chance;
    private Pair<class_2960, Integer> compatDatagenOutput;

    public ProcessingOutput(class_1799 stack, float chance) {
        this.stack = stack;
        this.chance = chance;
    }

    public ProcessingOutput(Pair<class_2960, Integer> item, float chance) {
        this.stack = class_1799.field_8037;
        this.compatDatagenOutput = item;
        this.chance = chance;
    }

    public class_1799 getStack() {
        return this.stack;
    }

    public float getChance() {
        return this.chance;
    }

    public class_1799 rollOutput() {
        int outputAmount = this.stack.method_7947();
        for (int roll = 0; roll < this.stack.method_7947(); ++roll) {
            if (!(r.nextFloat() > this.chance)) continue;
            --outputAmount;
        }
        if (outputAmount == 0) {
            return class_1799.field_8037;
        }
        class_1799 out = this.stack.method_7972();
        out.method_7939(outputAmount);
        return out;
    }

    public JsonElement serialize() {
        int count;
        JsonObject json = new JsonObject();
        class_2960 resourceLocation = this.compatDatagenOutput == null ? RegisteredObjects.getKeyOrThrow(this.stack.method_7909()) : this.compatDatagenOutput.getFirst();
        json.addProperty("item", resourceLocation.toString());
        int n = count = this.compatDatagenOutput == null ? this.stack.method_7947() : this.compatDatagenOutput.getSecond().intValue();
        if (count != 1) {
            json.addProperty("count", (Number)count);
        }
        if (this.stack.method_7985()) {
            json.add("nbt", JsonParser.parseString((String)this.stack.method_7969().toString()));
        }
        if (this.chance != 1.0f) {
            json.addProperty("chance", (Number)Float.valueOf(this.chance));
        }
        return json;
    }

    public static ProcessingOutput deserialize(JsonElement je) {
        if (!je.isJsonObject()) {
            throw new JsonSyntaxException("ProcessingOutput must be a json object");
        }
        JsonObject json = je.getAsJsonObject();
        String itemId = class_3518.method_15265((JsonObject)json, (String)"item");
        int count = class_3518.method_15282((JsonObject)json, (String)"count", (int)1);
        float chance = class_3518.method_15294((JsonObject)json, (String)"chance") ? class_3518.method_15259((JsonObject)json, (String)"chance") : 1.0f;
        class_1799 itemstack = new class_1799((class_1935)class_2378.field_11142.method_10223(new class_2960(itemId)), count);
        if (class_3518.method_15294((JsonObject)json, (String)"nbt")) {
            try {
                JsonElement element = json.get("nbt");
                itemstack.method_7980(class_2522.method_10718((String)(element.isJsonObject() ? Create.GSON.toJson(element) : class_3518.method_15287((JsonElement)element, (String)"nbt"))));
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
            }
        }
        return new ProcessingOutput(itemstack, chance);
    }

    public void write(class_2540 buf) {
        buf.method_10793(this.getStack());
        buf.writeFloat(this.getChance());
    }

    public static ProcessingOutput read(class_2540 buf) {
        return new ProcessingOutput(buf.method_10819(), buf.readFloat());
    }
}

