/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.processing.basin;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.recipe.DummyCraftingContainer;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.transfer.callbacks.TransactionCallback;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_3955;

public class BasinRecipe
extends ProcessingRecipe<SmartInventory> {
    public static boolean match(BasinBlockEntity basin, class_1860<?> recipe) {
        BasinRecipe basinRecipe;
        FilteringBehaviour filter = basin.getFilter();
        if (filter == null) {
            return false;
        }
        boolean filterTest = filter.test(recipe.method_8110());
        if (recipe instanceof BasinRecipe && (basinRecipe = (BasinRecipe)recipe).getRollableResults().isEmpty() && !basinRecipe.getFluidResults().isEmpty()) {
            filterTest = filter.test((FluidStack)basinRecipe.getFluidResults().get(0));
        }
        if (!filterTest) {
            return false;
        }
        return BasinRecipe.apply(basin, recipe, true);
    }

    public static boolean apply(BasinBlockEntity basin, class_1860<?> recipe) {
        return BasinRecipe.apply(basin, recipe, false);
    }

    private static boolean apply(BasinBlockEntity basin, class_1860<?> recipe, boolean test) {
        boolean isBasinRecipe = recipe instanceof BasinRecipe;
        Storage<ItemVariant> availableItems = basin.getItemStorage(null);
        Storage<FluidVariant> availableFluids = basin.getFluidStorage(null);
        if (availableItems == null || availableFluids == null) {
            return false;
        }
        BlazeBurnerBlock.HeatLevel heat = BasinBlockEntity.getHeatLevelOf(basin.method_10997().method_8320(basin.method_11016().method_10087(1)));
        if (isBasinRecipe && !((BasinRecipe)recipe).getRequiredHeat().testBlazeBurner(heat)) {
            return false;
        }
        ArrayList<class_1799> recipeOutputItems = new ArrayList<class_1799>();
        ArrayList<FluidStack> recipeOutputFluids = new ArrayList<FluidStack>();
        LinkedList ingredients = new LinkedList(recipe.method_8117());
        List<FluidIngredient> fluidIngredients = isBasinRecipe ? ((BasinRecipe)recipe).getFluidIngredients() : Collections.emptyList();
        class_2371 consumedItems = class_2371.method_10211();
        try (Transaction t = TransferUtil.getTransaction();){
            block8: for (Object ingredient : ingredients) {
                for (StorageView view : TransferUtil.getNonEmpty(availableItems)) {
                    ItemVariant var = (ItemVariant)view.getResource();
                    class_1799 stack = var.toStack();
                    if (!ingredient.method_8093(stack)) continue;
                    class_1799 remainder = stack.getRecipeRemainder();
                    if (!remainder.method_7960() && remainder.method_7962(stack)) continue block8;
                    long extracted = view.extract((Object)var, 1L, (TransactionContext)t);
                    if (extracted == 0L) continue;
                    consumedItems.add((Object)stack);
                    continue block8;
                }
                boolean bl = false;
                return bl;
            }
            boolean fluidsAffected = false;
            block10: for (FluidIngredient fluidIngredient : fluidIngredients) {
                long amountRequired = fluidIngredient.getRequiredAmount();
                for (StorageView view : TransferUtil.getNonEmpty(availableFluids)) {
                    FluidStack fluidStack = new FluidStack(view);
                    if (!fluidIngredient.test(fluidStack)) continue;
                    long drainedAmount = Math.min(amountRequired, fluidStack.getAmount());
                    if (view.extract((Object)fluidStack.getType(), drainedAmount, (TransactionContext)t) != drainedAmount) continue;
                    fluidsAffected = true;
                    if ((amountRequired -= drainedAmount) == 0L) continue block10;
                }
                boolean bl = false;
                return bl;
            }
            if (fluidsAffected) {
                TransactionCallback.onSuccess((TransactionContext)t, () -> {
                    basin.getBehaviour(SmartFluidTankBehaviour.INPUT).forEach(SmartFluidTankBehaviour.TankSegment::onFluidStackChanged);
                    basin.getBehaviour(SmartFluidTankBehaviour.OUTPUT).forEach(SmartFluidTankBehaviour.TankSegment::onFluidStackChanged);
                });
            }
            if (recipe instanceof BasinRecipe) {
                BasinRecipe basinRecipe = (BasinRecipe)recipe;
                recipeOutputItems.addAll(basinRecipe.rollResults());
                recipeOutputFluids.addAll((Collection<FluidStack>)basinRecipe.getFluidResults());
                recipeOutputItems.addAll((Collection<class_1799>)basinRecipe.method_8111((class_1263)basin.getInputInventory()));
            } else {
                recipeOutputItems.add(recipe.method_8110());
                if (recipe instanceof class_3955) {
                    class_3955 craftingRecipe = (class_3955)recipe;
                    recipeOutputItems.addAll((Collection<class_1799>)craftingRecipe.method_8111((class_1263)new DummyCraftingContainer((class_2371<class_1799>)consumedItems)));
                }
            }
            recipeOutputItems.removeIf(class_1799::method_7960);
            if (!basin.acceptOutputs(recipeOutputItems, recipeOutputFluids, (TransactionContext)t)) {
                boolean bl = false;
                return bl;
            }
            if (!test) {
                t.commit();
            }
            boolean bl = true;
            return bl;
        }
    }

    public static BasinRecipe convertShapeless(class_1860<?> recipe) {
        BasinRecipe basinRecipe = new ProcessingRecipeBuilder<BasinRecipe>(BasinRecipe::new, recipe.method_8114()).withItemIngredients((class_2371<class_1856>)recipe.method_8117()).withSingleItemOutput(recipe.method_8110()).build();
        return basinRecipe;
    }

    protected BasinRecipe(IRecipeTypeInfo type, ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        super(type, params);
    }

    public BasinRecipe(ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        this(AllRecipeTypes.BASIN, params);
    }

    @Override
    protected int getMaxInputCount() {
        return 9;
    }

    @Override
    protected int getMaxOutputCount() {
        return 4;
    }

    @Override
    protected int getMaxFluidInputCount() {
        return 2;
    }

    @Override
    protected int getMaxFluidOutputCount() {
        return 2;
    }

    @Override
    protected boolean canRequireHeat() {
        return true;
    }

    @Override
    protected boolean canSpecifyDuration() {
        return true;
    }

    public boolean matches(SmartInventory inv, @Nonnull class_1937 worldIn) {
        return false;
    }
}

