/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.fluids.pipes;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.ITransformableBlock;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.decoration.bracket.BracketedBlockEntityBehaviour;
import com.simibubi.create.content.decoration.encasing.EncasableBlock;
import com.simibubi.create.content.equipment.wrench.IWrenchableWithBracket;
import com.simibubi.create.content.fluids.FluidPropagator;
import com.simibubi.create.content.fluids.FluidTransportBehaviour;
import com.simibubi.create.content.fluids.pipes.EncasedPipeBlock;
import com.simibubi.create.content.fluids.pipes.FluidPipeBlockEntity;
import com.simibubi.create.content.fluids.pipes.FluidPipeBlockRotation;
import com.simibubi.create.content.fluids.pipes.GlassFluidPipeBlock;
import com.simibubi.create.content.fluids.pipes.VanillaFluidTargets;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1953;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2429;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4209;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;

public class FluidPipeBlock
extends class_2429
implements class_3737,
IWrenchableWithBracket,
IBE<FluidPipeBlockEntity>,
EncasableBlock,
ITransformableBlock {
    private static final class_265 OCCLUSION_BOX = class_2248.method_9541((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);

    public FluidPipeBlock(class_4970.class_2251 properties) {
        super(0.25f, properties);
        this.method_9590((class_2680)super.method_9564().method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public class_1269 onWrenched(class_2680 state, class_1838 context) {
        if (this.tryRemoveBracket(context)) {
            return class_1269.field_5812;
        }
        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();
        class_2350 clickedFace = context.method_8038();
        class_2350.class_2351 axis = this.getAxis((class_1922)world, pos, state);
        if (axis == null) {
            class_243 clickLocation = context.method_17698().method_1023((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
            double closest = 3.4028234663852886E38;
            class_2350 argClosest = class_2350.field_11036;
            for (class_2350 direction : Iterate.directions) {
                class_243 centerOf;
                double distance;
                if (clickedFace.method_10166() == direction.method_10166() || !((distance = (centerOf = class_243.method_24953((class_2382)direction.method_10163())).method_1025(clickLocation)) < closest)) continue;
                closest = distance;
                argClosest = direction;
            }
            axis = argClosest.method_10166();
        }
        if (clickedFace.method_10166() == axis) {
            return class_1269.field_5811;
        }
        if (!world.field_9236) {
            this.withBlockEntityDo((class_1922)world, pos, fpte -> fpte.getBehaviour(FluidTransportBehaviour.TYPE).interfaces.values().stream().filter(pc -> pc != null && pc.hasFlow()).findAny().ifPresent($ -> AllAdvancements.GLASS_PIPE.awardTo(context.method_8036())));
            FluidTransportBehaviour.cacheFlows((class_1936)world, pos);
            world.method_8501(pos, (class_2680)((class_2680)AllBlocks.GLASS_FLUID_PIPE.getDefaultState().method_11657((class_2769)GlassFluidPipeBlock.field_11459, (Comparable)axis)).method_11657((class_2769)class_2741.field_12508, (Comparable)((Boolean)state.method_11654((class_2769)class_2741.field_12508))));
            FluidTransportBehaviour.loadFlows((class_1936)world, pos);
        }
        return class_1269.field_5812;
    }

    public void method_9567(class_1937 pLevel, class_2338 pPos, class_2680 pState, class_1309 pPlacer, class_1799 pStack) {
        super.method_9567(pLevel, pPos, pState, pPlacer, pStack);
        AdvancementBehaviour.setPlacedBy(pLevel, pPos, pPlacer);
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 ray) {
        class_1799 heldItem = player.method_5998(hand);
        class_1269 result = this.tryEncase(state, world, pos, heldItem, player, hand, ray);
        if (result.method_23665()) {
            return result;
        }
        return class_1269.field_5811;
    }

    public class_2680 getAxisState(class_2350.class_2351 axis) {
        class_2680 defaultState = this.method_9564();
        for (class_2350 d : Iterate.directions) {
            defaultState = (class_2680)defaultState.method_11657((class_2769)field_11329.get(d), (Comparable)Boolean.valueOf(d.method_10166() == axis));
        }
        return defaultState;
    }

    @Nullable
    private class_2350.class_2351 getAxis(class_1922 world, class_2338 pos, class_2680 state) {
        return FluidPropagator.getStraightPipeAxis(state);
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean isMoving) {
        boolean blockTypeChanged;
        boolean bl = blockTypeChanged = state.method_26204() != newState.method_26204();
        if (blockTypeChanged && !world.field_9236) {
            FluidPropagator.propagateChangedPipe((class_1936)world, pos, state);
        }
        if (state != newState && !isMoving) {
            this.removeBracket((class_1922)world, pos, true).ifPresent(stack -> class_2248.method_9577((class_1937)world, (class_2338)pos, (class_1799)stack));
        }
        if (state.method_31709() && (blockTypeChanged || !newState.method_31709())) {
            world.method_8544(pos);
        }
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean isMoving) {
        if (world.field_9236) {
            return;
        }
        if (state != oldState) {
            world.method_39280(pos, (class_2248)this, 1, class_1953.field_9310);
        }
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 otherBlock, class_2338 neighborPos, boolean isMoving) {
        class_4209.method_19472((class_1937)world, (class_2338)pos);
        class_2350 d = FluidPropagator.validateNeighbourChange(state, world, pos, otherBlock, neighborPos, isMoving);
        if (d == null) {
            return;
        }
        if (!FluidPipeBlock.isOpenAt(state, d)) {
            return;
        }
        world.method_39280(pos, (class_2248)this, 1, class_1953.field_9310);
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 r) {
        FluidPropagator.propagateChangedPipe((class_1936)world, pos, state);
    }

    public static boolean isPipe(class_2680 state) {
        return state.method_26204() instanceof FluidPipeBlock;
    }

    public static boolean canConnectTo(class_1920 world, class_2338 neighbourPos, class_2680 neighbour, class_2350 direction) {
        if (FluidPropagator.hasFluidCapability((class_1922)world, neighbourPos, direction.method_10153())) {
            return true;
        }
        if (VanillaFluidTargets.shouldPipesConnectTo(neighbour)) {
            return true;
        }
        FluidTransportBehaviour transport = BlockEntityBehaviour.get((class_1922)world, neighbourPos, FluidTransportBehaviour.TYPE);
        BracketedBlockEntityBehaviour bracket = BlockEntityBehaviour.get((class_1922)world, neighbourPos, BracketedBlockEntityBehaviour.TYPE);
        if (FluidPipeBlock.isPipe(neighbour)) {
            return bracket == null || !bracket.isBracketPresent() || FluidPropagator.getStraightPipeAxis(neighbour) == direction.method_10166();
        }
        if (transport == null) {
            return false;
        }
        return transport.canHaveFlowToward(neighbour, direction.method_10153());
    }

    public static boolean shouldDrawRim(class_1920 world, class_2338 pos, class_2680 state, class_2350 direction) {
        class_2338 offsetPos = pos.method_10093(direction);
        class_2680 facingState = world.method_8320(offsetPos);
        if (facingState.method_26204() instanceof EncasedPipeBlock) {
            return true;
        }
        if (!FluidPipeBlock.isPipe(facingState)) {
            return true;
        }
        return !FluidPipeBlock.canConnectTo(world, offsetPos, facingState, direction);
    }

    public static boolean isOpenAt(class_2680 state, class_2350 direction) {
        return (Boolean)state.method_11654((class_2769)field_11329.get(direction));
    }

    public static boolean isCornerOrEndPipe(class_1920 world, class_2338 pos, class_2680 state) {
        return FluidPipeBlock.isPipe(state) && FluidPropagator.getStraightPipeAxis(state) == null && !FluidPipeBlock.shouldDrawCasing(world, pos, state);
    }

    public static boolean shouldDrawCasing(class_1920 world, class_2338 pos, class_2680 state) {
        if (!FluidPipeBlock.isPipe(state)) {
            return false;
        }
        for (class_2350.class_2351 axis : Iterate.axes) {
            int connections = 0;
            for (class_2350 direction : Iterate.directions) {
                if (direction.method_10166() == axis || !FluidPipeBlock.isOpenAt(state, direction)) continue;
                ++connections;
            }
            if (connections <= 2) continue;
            return true;
        }
        return false;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{field_11332, field_11335, field_11331, field_11328, field_11327, field_11330, class_2741.field_12508});
        super.method_9515(builder);
    }

    public class_2680 method_9605(class_1750 context) {
        class_3610 FluidState = context.method_8045().method_8316(context.method_8037());
        return (class_2680)this.updateBlockState(this.method_9564(), context.method_7715(), null, (class_1920)context.method_8045(), context.method_8037()).method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(FluidState.method_15772() == class_3612.field_15910));
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighbourState, class_1936 world, class_2338 pos, class_2338 neighbourPos) {
        if (((Boolean)state.method_11654((class_2769)class_2741.field_12508)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        if (FluidPipeBlock.isOpenAt(state, direction) && neighbourState.method_28498((class_2769)class_2741.field_12508)) {
            world.method_39280(pos, (class_2248)this, 1, class_1953.field_9310);
        }
        return this.updateBlockState(state, direction, direction.method_10153(), (class_1920)world, pos);
    }

    public class_2680 updateBlockState(class_2680 state, class_2350 preferredDirection, @Nullable class_2350 ignore, class_1920 world, class_2338 pos) {
        BracketedBlockEntityBehaviour bracket = BlockEntityBehaviour.get((class_1922)world, pos, BracketedBlockEntityBehaviour.TYPE);
        if (bracket != null && bracket.isBracketPresent()) {
            return state;
        }
        class_2680 prevState = state;
        int prevStateSides = (int)Arrays.stream(Iterate.directions).map(field_11329::get).filter(arg_0 -> ((class_2680)prevState).method_11654(arg_0)).count();
        for (class_2350 d : Iterate.directions) {
            if (d == ignore) continue;
            boolean shouldConnect = FluidPipeBlock.canConnectTo(world, pos.method_10093(d), world.method_8320(pos.method_10093(d)), d);
            state = (class_2680)state.method_11657((class_2769)field_11329.get(d), (Comparable)Boolean.valueOf(shouldConnect));
        }
        class_2350 connectedDirection = null;
        for (class_2350 d : Iterate.directions) {
            if (!FluidPipeBlock.isOpenAt(state, d)) continue;
            if (connectedDirection != null) {
                return state;
            }
            connectedDirection = d;
        }
        if (connectedDirection != null) {
            return (class_2680)state.method_11657((class_2769)field_11329.get(connectedDirection.method_10153()), (Comparable)Boolean.valueOf(true));
        }
        if (prevStateSides == 2) {
            return prevState;
        }
        return (class_2680)((class_2680)state.method_11657((class_2769)field_11329.get(preferredDirection), (Comparable)Boolean.valueOf(true))).method_11657((class_2769)field_11329.get(preferredDirection.method_10153()), (Comparable)Boolean.valueOf(true));
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)class_2741.field_12508) != false ? class_3612.field_15910.method_15729(false) : class_3612.field_15906.method_15785();
    }

    @Override
    public Optional<class_1799> removeBracket(class_1922 world, class_2338 pos, boolean inOnReplacedContext) {
        BracketedBlockEntityBehaviour behaviour = BracketedBlockEntityBehaviour.get(world, pos, BracketedBlockEntityBehaviour.TYPE);
        if (behaviour == null) {
            return Optional.empty();
        }
        class_2680 bracket = behaviour.removeBracket(inOnReplacedContext);
        if (bracket == null) {
            return Optional.empty();
        }
        return Optional.of(new class_1799((class_1935)bracket.method_26204()));
    }

    public boolean method_9516(class_2680 state, class_1922 reader, class_2338 pos, class_10 type) {
        return false;
    }

    @Override
    public Class<FluidPipeBlockEntity> getBlockEntityClass() {
        return FluidPipeBlockEntity.class;
    }

    @Override
    public class_2591<? extends FluidPipeBlockEntity> getBlockEntityType() {
        return (class_2591)AllBlockEntityTypes.FLUID_PIPE.get();
    }

    public class_265 method_9571(class_2680 pState, class_1922 pLevel, class_2338 pPos) {
        return OCCLUSION_BOX;
    }

    public class_2680 method_9598(class_2680 pState, class_2470 pRotation) {
        return FluidPipeBlockRotation.rotate(pState, pRotation);
    }

    public class_2680 method_9569(class_2680 pState, class_2415 pMirror) {
        return FluidPipeBlockRotation.mirror(pState, pMirror);
    }

    @Override
    public class_2680 transform(class_2680 state, StructureTransform transform) {
        return FluidPipeBlockRotation.transform(state, transform);
    }
}

