/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.rei.category;

import com.simibubi.create.compat.rei.category.BasinCategory;
import com.simibubi.create.compat.rei.category.CreateRecipeCategory;
import com.simibubi.create.compat.rei.category.animations.AnimatedBlazeBurner;
import com.simibubi.create.compat.rei.category.animations.AnimatedPress;
import com.simibubi.create.compat.rei.display.CreateDisplay;
import com.simibubi.create.content.processing.basin.BasinRecipe;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2371;
import net.minecraft.class_4587;

public class PackingCategory
extends BasinCategory {
    private AnimatedPress press = new AnimatedPress(true);
    private final AnimatedBlazeBurner heater = new AnimatedBlazeBurner();
    private PackingType type;

    public static PackingCategory standard(CreateRecipeCategory.Info<BasinRecipe> info) {
        return new PackingCategory(info, PackingType.COMPACTING);
    }

    public static PackingCategory autoSquare(CreateRecipeCategory.Info<BasinRecipe> info) {
        return new PackingCategory(info, PackingType.AUTO_SQUARE);
    }

    protected PackingCategory(CreateRecipeCategory.Info<BasinRecipe> info, PackingType type) {
        super(info, type != PackingType.AUTO_SQUARE);
        this.type = type;
    }

    @Override
    public void addWidgets(CreateDisplay<BasinRecipe> display, List<Widget> ingredients, Point origin) {
        int rows;
        BasinRecipe recipe = display.getRecipe();
        if (this.type == PackingType.COMPACTING) {
            super.addWidgets(display, ingredients, origin);
            return;
        }
        class_2371<class_1856> ingredients2 = recipe.method_8117();
        int size = ingredients2.size();
        int n = rows = size == 4 ? 2 : 3;
        for (int i = 0; i < size; ++i) {
            class_1856 ingredient = (class_1856)ingredients2.get(i);
            ingredients.add((Widget)PackingCategory.basicSlot(origin.x + (rows == 2 ? 26 : 17) + i % rows * 19 + 1, origin.y + 50 - i / rows * 19 + 1).markInput().entries((Collection)EntryIngredients.ofIngredient((class_1856)ingredient)));
        }
        ingredients.add((Widget)PackingCategory.basicSlot(origin.x + 142, origin.y + 51).markOutput().entries((Collection)EntryIngredients.of((class_1799)recipe.method_8110())));
    }

    @Override
    public void draw(BasinRecipe recipe, class_4587 matrixStack, double mouseX, double mouseY) {
        if (this.type == PackingType.COMPACTING) {
            super.draw(recipe, matrixStack, mouseX, mouseY);
        } else {
            class_2371<class_1856> ingredients2 = recipe.method_8117();
            int size = ingredients2.size();
            int rows = size == 4 ? 2 : 3;
            for (int i = 0; i < size; ++i) {
                AllGuiTextures.JEI_SLOT.render(matrixStack, (rows == 2 ? 26 : 17) + i % rows * 19, 50 - i / rows * 19);
            }
            AllGuiTextures.JEI_SLOT.render(matrixStack, 141, 50);
            AllGuiTextures.JEI_DOWN_ARROW.render(matrixStack, 136, 32);
            AllGuiTextures.JEI_SHADOW.render(matrixStack, 81, 68);
        }
        HeatCondition requiredHeat = recipe.getRequiredHeat();
        if (requiredHeat != HeatCondition.NONE) {
            this.heater.withHeat(requiredHeat.visualizeAsBlazeBurner()).draw(matrixStack, this.getDisplayWidth(null) / 2 + 3, 55);
        }
        this.press.draw(matrixStack, this.getDisplayWidth(null) / 2 + 3, 34);
    }

    static enum PackingType {
        AUTO_SQUARE,
        COMPACTING;

    }
}

