/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.impl.fluid.storage;

import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.base.FluidSnapshot;
import earth.terrarium.botarium.impl.fluid.holder.FabricFluidHolder;
import earth.terrarium.botarium.impl.fluid.storage.ExtendedFluidContainer;
import earth.terrarium.botarium.impl.fluid.storage.FabricBlockFluidContainer;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2487;
import net.minecraft.class_3611;

public class SingleFluidSlot
extends ExtendedFluidContainer
implements StorageView<FluidVariant> {
    private final FabricBlockFluidContainer<?> container;
    private final int slotIndex;

    public SingleFluidSlot(FabricBlockFluidContainer<?> container, int slotIndex) {
        this.container = container;
        this.slotIndex = slotIndex;
    }

    public FluidVariant fluidVariant() {
        FluidHolder fluidHolder = this.container.container.getFluids().get(this.slotIndex);
        return FluidVariant.of((class_3611)fluidHolder.getFluid(), (class_2487)fluidHolder.getCompound());
    }

    public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        this.updateSnapshots(transaction);
        return this.container.container.extractFromSlot(this.slotIndex, (FluidHolder)FabricFluidHolder.of(resource, maxAmount), false);
    }

    public boolean isResourceBlank() {
        return this.fluidVariant().isBlank();
    }

    public FluidVariant getResource() {
        return this.fluidVariant();
    }

    public long getAmount() {
        return this.container.container.getFluids().get(this.slotIndex).getFluidAmount();
    }

    public long getCapacity() {
        return this.container.container.getTankCapacity(this.slotIndex);
    }

    @Override
    public FluidSnapshot createSnapshot() {
        return this.container.createSnapshot();
    }

    @Override
    public void readSnapshot(FluidSnapshot snapshot) {
        this.container.readSnapshot(snapshot);
    }

    @Override
    public void onFinalCommit() {
        this.container.onFinalCommit();
    }

    public void updateSnapshots(TransactionContext transaction) {
        this.container.updateSnapshots(transaction);
    }
}

