/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.impl.fluid.storage;

import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.base.FluidSnapshot;
import earth.terrarium.botarium.common.fluid.impl.SimpleFluidSnapshot;
import earth.terrarium.botarium.impl.fluid.holder.FabricFluidHolder;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public record PlatformFluidContainer(Storage<FluidVariant> storage) implements FluidContainer
{
    public static PlatformFluidContainer of(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_2586 entity, @Nullable class_2350 direction) {
        Storage storage = (Storage)FluidStorage.SIDED.find(level, pos, state, entity, (Object)direction);
        return storage == null ? null : new PlatformFluidContainer((Storage<FluidVariant>)storage);
    }

    @Override
    public long insertFluid(FluidHolder fluid, boolean simulate) {
        try (Transaction transaction = Transaction.openOuter();){
            FabricFluidHolder fabricFluidHolder = FabricFluidHolder.of(fluid);
            long inserted = this.storage.insert((Object)fabricFluidHolder.toVariant(), fabricFluidHolder.getAmount(), (TransactionContext)transaction);
            if (!simulate) {
                transaction.commit();
            }
            long l = inserted;
            return l;
        }
    }

    @Override
    public FluidHolder extractFluid(FluidHolder fluid, boolean simulate) {
        try (Transaction transaction = Transaction.openOuter();){
            FabricFluidHolder fabricFluidHolder = FabricFluidHolder.of(fluid);
            long extracted = this.storage.extract((Object)fabricFluidHolder.toVariant(), fabricFluidHolder.getAmount(), (TransactionContext)transaction);
            if (!simulate) {
                transaction.commit();
            }
            FluidHolder fluidHolder = extracted == 0L ? FabricFluidHolder.of(fabricFluidHolder.toVariant(), extracted) : fluid;
            return fluidHolder;
        }
    }

    @Override
    public void setFluid(int slot, FluidHolder fluid) {
    }

    @Override
    public List<FluidHolder> getFluids() {
        ArrayList<FluidHolder> fluids = new ArrayList<FluidHolder>();
        this.storage.iterator().forEachRemaining(variant -> fluids.add(FabricFluidHolder.of((FluidVariant)variant.getResource(), variant.getAmount())));
        return fluids;
    }

    @Override
    public int getSize() {
        return this.getFluids().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getFluids().isEmpty() || this.getFluids().stream().allMatch(FluidHolder::isEmpty);
    }

    @Override
    public FluidContainer copy() {
        throw new UnsupportedOperationException("You may not copy a PlatformFluidContainer");
    }

    @Override
    public long getTankCapacity(int tank) {
        ArrayList fluids = new ArrayList();
        this.storage.iterator().forEachRemaining(fluids::add);
        return ((StorageView)fluids.get(tank)).getCapacity();
    }

    @Override
    public void fromContainer(FluidContainer container) {
        throw new UnsupportedOperationException("You may not overwrite a PlatformFluidContainer");
    }

    @Override
    public long extractFromSlot(FluidHolder fluidHolder, FluidHolder toInsert, Runnable snapshot) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean allowsInsertion() {
        return this.storage.supportsInsertion();
    }

    @Override
    public boolean allowsExtraction() {
        return this.storage.supportsExtraction();
    }

    @Override
    public FluidSnapshot createSnapshot() {
        return new SimpleFluidSnapshot(this);
    }

    @Override
    public void deserialize(class_2487 nbt) {
    }

    @Override
    public class_2487 serialize(class_2487 nbt) {
        return nbt;
    }

    public void method_5448() {
        this.storage.iterator().forEachRemaining(variant -> this.storage.extract((Object)((FluidVariant)variant.getResource()), variant.getAmount(), (TransactionContext)Transaction.openOuter()));
    }
}

