/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.api.fluid;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.botarium.api.fluid.FluidHooks;
import java.util.Optional;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3611;

public interface FluidHolder {
    public static final Codec<FluidHolder> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2378.field_11154.method_39673().fieldOf("fluid").forGetter(FluidHolder::getFluid), (App)Codec.FLOAT.fieldOf("buckets").orElse((Object)Float.valueOf(1.0f)).forGetter(fluidHolder -> Float.valueOf((float)fluidHolder.getFluidAmount() / (float)FluidHooks.getBucketAmount())), (App)class_2487.field_25128.optionalFieldOf("tag").forGetter(fluidHolder -> Optional.ofNullable(fluidHolder.getCompound()))).apply((Applicative)instance, (fluid, buckets, compoundTag) -> FluidHooks.newFluidHolder(fluid, FluidHooks.buckets(buckets.floatValue()), compoundTag.orElse(null))));

    public static FluidHolder of(class_3611 fluid) {
        return FluidHooks.newFluidHolder(fluid, FluidHooks.buckets(1.0), null);
    }

    public static FluidHolder of(class_3611 fluid, double buckets, class_2487 tag) {
        return FluidHooks.newFluidHolder(fluid, FluidHooks.buckets(buckets), tag);
    }

    public class_3611 getFluid();

    public void setFluid(class_3611 var1);

    public long getFluidAmount();

    public void setAmount(long var1);

    public class_2487 getCompound();

    public void setCompound(class_2487 var1);

    public boolean isEmpty();

    public boolean matches(FluidHolder var1);

    public FluidHolder copyHolder();

    public class_2487 serialize();

    public void deserialize(class_2487 var1);

    default public FluidHolder copyWithAmount(long amount) {
        FluidHolder copy = this.copyHolder();
        if (!copy.isEmpty()) {
            copy.setAmount(amount);
        }
        return copy;
    }

    public class_2561 getTranslationName();

    public String getTranslationKey();
}

