/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.api.energy;

import com.mojang.datafixers.util.Pair;
import earth.terrarium.botarium.api.energy.EnergyBlock;
import earth.terrarium.botarium.api.energy.EnergyItem;
import earth.terrarium.botarium.api.energy.PlatformEnergyManager;
import earth.terrarium.botarium.api.energy.PlatformItemEnergyManager;
import earth.terrarium.botarium.api.energy.StatefulEnergyContainer;
import earth.terrarium.botarium.api.item.ItemStackHolder;
import earth.terrarium.botarium.fabric.energy.FabricEnergyManager;
import earth.terrarium.botarium.fabric.energy.FabricItemEnergyManager;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.EnergyStorageUtil;

public class EnergyHooks {
    public static PlatformItemEnergyManager getItemEnergyManager(class_1799 stack) {
        return new FabricItemEnergyManager(stack);
    }

    public static PlatformEnergyManager getBlockEnergyManager(class_2586 entity, class_2350 direction) {
        return new FabricEnergyManager(entity, direction);
    }

    public static boolean isEnergyItem(class_1799 stack) {
        return EnergyStorageUtil.isEnergyStorage((class_1799)stack);
    }

    public static boolean isEnergyContainer(class_2586 block, class_2350 direction) {
        return EnergyStorage.SIDED.find(block.method_10997(), block.method_11016(), (Object)direction) != null;
    }

    public static long moveEnergy(PlatformEnergyManager from, PlatformEnergyManager to, long amount) {
        long extracted = from.extract(amount, true);
        long inserted = to.insert(extracted, true);
        from.extract(inserted, false);
        return to.insert(inserted, false);
    }

    public static long safeMoveEnergy(Optional<PlatformEnergyManager> from, Optional<PlatformEnergyManager> to, long amount) {
        return from.map(f -> to.map(t -> EnergyHooks.moveEnergy(f, t, amount)).orElse(0L)).orElse(0L);
    }

    public static Optional<PlatformEnergyManager> safeGetBlockEnergyManager(class_2586 entity, @Nullable class_2350 direction) {
        return EnergyHooks.isEnergyContainer(entity, direction) ? Optional.of(EnergyHooks.getBlockEnergyManager(entity, direction)) : Optional.empty();
    }

    public static Optional<PlatformItemEnergyManager> safeGetItemEnergyManager(class_1799 stack) {
        return EnergyHooks.isEnergyItem(stack) ? Optional.of(EnergyHooks.getItemEnergyManager(stack)) : Optional.empty();
    }

    public static long moveItemToItemEnergy(PlatformItemEnergyManager from, ItemStackHolder sender, PlatformItemEnergyManager to, ItemStackHolder receiver, long amount) {
        long extracted = from.extract(sender, amount, true);
        long inserted = to.insert(receiver, extracted, true);
        from.extract(sender, inserted, false);
        return to.insert(receiver, inserted, false);
    }

    public static long moveStandardToItemEnergy(PlatformEnergyManager from, PlatformItemEnergyManager to, ItemStackHolder receiver, long amount) {
        long extracted = from.extract(amount, true);
        long inserted = to.insert(receiver, extracted, true);
        from.extract(inserted, false);
        return to.insert(receiver, inserted, false);
    }

    public static long moveItemToStandardEnergy(PlatformItemEnergyManager from, ItemStackHolder sender, PlatformEnergyManager to, long amount) {
        long extracted = from.extract(sender, amount, true);
        long inserted = to.insert(extracted, true);
        from.extract(sender, inserted, false);
        return to.insert(inserted, false);
    }

    public static long safeMoveItemToItemEnergy(ItemStackHolder from, ItemStackHolder to, long amount) {
        return EnergyHooks.safeGetItemEnergyManager(from.getStack()).map(f -> EnergyHooks.safeGetItemEnergyManager(to.getStack()).map(t -> EnergyHooks.moveItemToItemEnergy(f, from, t, to, amount)).orElse(0L)).orElse(0L);
    }

    public static long safeMoveItemToBlockEnergy(ItemStackHolder from, class_2586 to, @Nullable class_2350 direction, long amount) {
        return EnergyHooks.safeGetItemEnergyManager(from.getStack()).map(f -> EnergyHooks.safeGetBlockEnergyManager(to, direction).map(t -> EnergyHooks.moveItemToStandardEnergy(f, from, t, amount)).orElse(0L)).orElse(0L);
    }

    public static long safeMoveBlockToItemEnergy(class_2586 from, @Nullable class_2350 direction, ItemStackHolder to, long amount) {
        return EnergyHooks.safeGetBlockEnergyManager(from, direction).map(f -> EnergyHooks.safeGetItemEnergyManager(to.getStack()).map(t -> EnergyHooks.moveStandardToItemEnergy(f, t, to, amount)).orElse(0L)).orElse(0L);
    }

    public static long moveBlockToBlockEnergy(class_2586 from, @Nullable class_2350 fromDirection, class_2586 to, @Nullable class_2350 toDirection, long amount) {
        return EnergyHooks.safeMoveEnergy(EnergyHooks.safeGetBlockEnergyManager(from, fromDirection), EnergyHooks.safeGetBlockEnergyManager(to, toDirection), amount);
    }

    public static long moveBlockToBlockEnergy(class_2586 from, class_2586 to, long amount) {
        return EnergyHooks.safeMoveEnergy(EnergyHooks.safeGetBlockEnergyManager(from, null), EnergyHooks.safeGetBlockEnergyManager(to, null), amount);
    }

    public static <T extends class_2586> void distributeEnergyNearby(T energyBlock, long amount) {
        class_2338 blockPos = energyBlock.method_11016();
        class_1937 level = energyBlock.method_10997();
        if (level == null) {
            return;
        }
        class_2350.method_42013().map(direction -> Pair.of((Object)direction, (Object)level.method_8321(blockPos.method_10093(direction)))).filter(pair -> pair.getSecond() != null).map(pair -> Pair.of(EnergyHooks.safeGetBlockEnergyManager((class_2586)pair.getSecond(), (class_2350)pair.getFirst()), (Object)((class_2350)pair.getFirst()))).filter(pair -> ((Optional)pair.getFirst()).isPresent()).forEach(pair -> {
            PlatformEnergyManager externalEnergy = (PlatformEnergyManager)((Optional)pair.getFirst()).get();
            EnergyHooks.safeGetBlockEnergyManager(energyBlock, ((class_2350)pair.getSecond()).method_10153()).ifPresent(platformEnergyManager -> EnergyHooks.moveEnergy(platformEnergyManager, externalEnergy, amount == -1L ? ((EnergyBlock)energyBlock).getEnergyStorage().getStoredEnergy() : amount));
        });
    }

    public static <T extends class_2586> void distributeEnergyNearby(T energyBlock) {
        EnergyHooks.distributeEnergyNearby(energyBlock, -1L);
    }

    public static int toDurabilityBar(EnergyItem energyItem, class_1799 stack) {
        StatefulEnergyContainer<class_1799> energyStorage = energyItem.getEnergyStorage(stack);
        return (int)((double)energyStorage.getStoredEnergy() / (double)energyStorage.getMaxCapacity() * 13.0);
    }
}

