/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.util.packet;

import com.google.common.primitives.Floats;
import com.railwayteam.railways.Railways;
import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.multiloader.C2SPacket;
import com.railwayteam.railways.multiloader.S2CPacket;
import com.railwayteam.railways.registry.CRPackets;
import com.simibubi.create.foundation.utility.Components;
import java.util.Collections;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1313;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2708;
import net.minecraft.class_2828;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_4538;

public class CameraMovePacket
implements C2SPacket,
S2CPacket {
    final int id;
    final class_2828.class_2830 packet;

    public CameraMovePacket(ConductorEntity entity, class_2828.class_2830 packet) {
        this.id = entity.method_5628();
        this.packet = packet;
    }

    public CameraMovePacket(class_2540 buf) {
        this.id = buf.method_10816();
        this.packet = class_2828.class_2830.method_34222((class_2540)buf);
    }

    @Override
    public void write(class_2540 buffer) {
        buffer.method_10804(this.id);
        this.packet.method_11052(buffer);
    }

    @Override
    public void handle(class_310 mc) {
        ConductorEntity conductor;
        class_1297 class_12972;
        if (mc.field_1687 != null && (class_12972 = mc.field_1687.method_8469(this.id)) instanceof ConductorEntity && mc.field_1719 == (conductor = (ConductorEntity)class_12972)) {
            double d0 = this.packet.method_12269(conductor.method_23317());
            double d1 = this.packet.method_12268(conductor.method_23318());
            double d2 = this.packet.method_12274(conductor.method_23321());
            conductor.method_43391(d0, d1, d2);
            conductor.method_5814(d0, d1, d2);
            float f = this.packet.method_12271(conductor.method_36454()) * 360.0f / 256.0f;
            float f1 = this.packet.method_12270(conductor.method_36455()) * 360.0f / 256.0f;
            conductor.method_5759(d0, d1, d2, f, f1, 3, true);
            conductor.method_24830(this.packet.method_12273());
        }
    }

    private static boolean containsInvalidValues(double x, double y, double z, float yaw, float pitch) {
        return Double.isNaN(x) || Double.isNaN(y) || Double.isNaN(z) || !Floats.isFinite((float)pitch) || !Floats.isFinite((float)yaw);
    }

    private static double clampHorizontal(double value) {
        return class_3532.method_15350((double)value, (double)-3.0E7, (double)3.0E7);
    }

    private static double clampVertical(double value) {
        return class_3532.method_15350((double)value, (double)-2.0E7, (double)2.0E7);
    }

    private static boolean isPlayerCollidingWithAnythingNew(ConductorEntity conductor, class_4538 world, class_238 box) {
        Iterable iterable = world.method_8600((class_1297)conductor, conductor.method_5829().method_1011((double)1.0E-5f));
        class_265 voxelShape = class_259.method_1078((class_238)box.method_1011((double)1.0E-5f));
        for (class_265 voxelShape2 : iterable) {
            if (class_259.method_1074((class_265)voxelShape2, (class_265)voxelShape, (class_247)class_247.field_16896)) continue;
            return true;
        }
        return false;
    }

    public static void teleport(class_3222 player, ConductorEntity conductor, double x, double y, double z, float yaw, float pitch) {
        CameraMovePacket.teleport(player, conductor, x, y, z, yaw, pitch, Collections.emptySet(), false);
    }

    public static void teleport(class_3222 player, ConductorEntity conductor, double x, double y, double z, float yaw, float pitch, Set<class_2708.class_2709> relativeSet, boolean dismountVehicle) {
        double d = relativeSet.contains(class_2708.class_2709.field_12400) ? conductor.method_23317() : 0.0;
        double e = relativeSet.contains(class_2708.class_2709.field_12398) ? conductor.method_23318() : 0.0;
        double f = relativeSet.contains(class_2708.class_2709.field_12403) ? conductor.method_23321() : 0.0;
        float g = relativeSet.contains(class_2708.class_2709.field_12401) ? conductor.method_36454() : 0.0f;
        float h = relativeSet.contains(class_2708.class_2709.field_12397) ? conductor.method_36455() : 0.0f;
        conductor.method_5641(x, y, z, yaw, pitch);
        CRPackets.PACKETS.sendTo(player, (S2CPacket)new CameraMovePacket(conductor, new class_2828.class_2830(x, y, z, yaw, pitch, conductor.method_24828())));
    }

    @Override
    public void handle(class_3222 sender1) {
        class_1297 class_12972 = sender1.field_6002.method_8469(this.id);
        if (class_12972 instanceof ConductorEntity) {
            ConductorEntity conductor = (ConductorEntity)class_12972;
            if (sender1.method_14242() == conductor) {
                boolean bl2;
                if (CameraMovePacket.containsInvalidValues(this.packet.method_12269(0.0), this.packet.method_12268(0.0), this.packet.method_12274(0.0), this.packet.method_12271(0.0f), this.packet.method_12270(0.0f))) {
                    sender1.field_13987.method_14367((class_2561)Components.translatable((String)"multiplayer.disconnect.invalid_player_movement"));
                    return;
                }
                class_1937 class_19372 = conductor.method_37908();
                if (!(class_19372 instanceof class_3218)) {
                    return;
                }
                class_3218 serverLevel = (class_3218)class_19372;
                double d = CameraMovePacket.clampHorizontal(this.packet.method_12269(conductor.method_23317()));
                double e = CameraMovePacket.clampVertical(this.packet.method_12268(conductor.method_23318()));
                double f = CameraMovePacket.clampHorizontal(this.packet.method_12274(conductor.method_23321()));
                float g = class_3532.method_15393((float)this.packet.method_12271(conductor.method_36454()));
                float h = class_3532.method_15393((float)this.packet.method_12270(conductor.method_36455()));
                if (conductor.method_5765()) {
                    conductor.method_5641(conductor.method_23317(), conductor.method_23318(), conductor.method_23321(), g, h);
                    return;
                }
                double i = conductor.method_23317();
                double j = conductor.method_23318();
                double k = conductor.method_23321();
                double l = conductor.method_23318();
                double m = d - conductor.firstGoodX;
                double n = e - conductor.firstGoodY;
                double o = f - conductor.firstGoodZ;
                double p = conductor.method_18798().method_1027();
                double q = m * m + n * n + o * o;
                ++conductor.receivedMovePacketCount;
                int r = conductor.receivedMovePacketCount - conductor.knownMovePacketCount;
                if (r > 5) {
                    Railways.LOGGER.debug("{} is sending move packets too frequently ({} packets since last tick)", (Object)sender1.method_5477().getString(), (Object)r);
                    r = 1;
                }
                float s = conductor.method_6128() ? 300.0f : 100.0f;
                float f2 = s;
                if (q - p > (double)(s * (float)r)) {
                    Railways.LOGGER.warn("{} moved too quickly! {},{},{}", new Object[]{sender1.method_5477().getString(), m, n, o});
                    CameraMovePacket.teleport(sender1, conductor, conductor.method_23317(), conductor.method_23318(), conductor.method_23321(), conductor.method_36454(), conductor.method_36455());
                    return;
                }
                class_238 aABB = conductor.method_5829();
                m = d - conductor.lastGoodX;
                n = e - conductor.lastGoodY;
                o = f - conductor.lastGoodZ;
                boolean bl = bl2 = n > 0.0;
                if (conductor.method_24828() && !this.packet.method_12273() && bl2) {
                    conductor.method_6043();
                }
                boolean bl22 = conductor.field_36331;
                conductor.method_5784(class_1313.field_6305, new class_243(m, n, o));
                double t = n;
                m = d - conductor.method_23317();
                n = e - conductor.method_23318();
                if (n > -0.5 || n < 0.5) {
                    n = 0.0;
                }
                o = f - conductor.method_23321();
                q = m * m + n * n + o * o;
                boolean bl3 = false;
                if (q > 0.0625) {
                    bl3 = true;
                    return;
                }
                conductor.method_5641(d, e, f, g, h);
                if (!conductor.field_5960 && (bl3 && serverLevel.method_8587((class_1297)conductor, aABB) || CameraMovePacket.isPlayerCollidingWithAnythingNew(conductor, (class_4538)serverLevel, aABB))) {
                    CameraMovePacket.teleport(sender1, conductor, i, j, k, g, h);
                    return;
                }
                conductor.doCheckFallDamage(conductor.method_23318() - l, this.packet.method_12273());
                conductor.method_24830(this.packet.method_12273());
                if (bl2) {
                    conductor.method_38785();
                }
                conductor.lastGoodX = conductor.method_23317();
                conductor.lastGoodY = conductor.method_23318();
                conductor.lastGoodZ = conductor.method_23321();
            }
        }
    }
}

