/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.fuel.tank;

import com.railwayteam.railways.content.fuel.tank.FuelTankBlockEntity;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.simibubi.create.foundation.fluid.FluidRenderer;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;

public class FuelTankRenderer
extends SafeBlockEntityRenderer<FuelTankBlockEntity> {
    public FuelTankRenderer(class_5614.class_5615 context) {
    }

    protected void renderSafe(FuelTankBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        if (!be.isController()) {
            return;
        }
        if (!be.window) {
            return;
        }
        LerpedFloat fluidLevel = be.getFluidLevel();
        if (fluidLevel == null) {
            return;
        }
        float capHeight = 0.25f;
        float tankHullWidth = 0.0703125f;
        float minPuddleHeight = 0.0625f;
        float totalHeight = (float)be.height - 2.0f * capHeight - minPuddleHeight;
        float level = fluidLevel.getValue(partialTicks);
        if (level < 1.0f / (512.0f * totalHeight)) {
            return;
        }
        float clampedLevel = class_3532.method_15363((float)(level * totalHeight), (float)0.0f, (float)totalHeight);
        FuelTankBlockEntity.FuelFluidHandler tank = be.tankInventory;
        FluidStack fluidStack = tank.getFluid();
        if (fluidStack.isEmpty()) {
            return;
        }
        boolean top = FluidVariantAttributes.isLighterThanAir((FluidVariant)fluidStack.getType());
        float xMin = tankHullWidth;
        float xMax = xMin + (float)be.width - 2.0f * tankHullWidth;
        float yMin = totalHeight + capHeight + minPuddleHeight - clampedLevel;
        float yMax = yMin + clampedLevel;
        if (top) {
            yMin += totalHeight - clampedLevel;
            yMax += totalHeight - clampedLevel;
        }
        float zMin = tankHullWidth;
        float zMax = zMin + (float)be.width - 2.0f * tankHullWidth;
        ms.method_22903();
        ms.method_22904(0.0, (double)(clampedLevel - totalHeight), 0.0);
        FluidRenderer.renderFluidBox((FluidStack)fluidStack, (float)xMin, (float)yMin, (float)zMin, (float)xMax, (float)yMax, (float)zMax, (class_4597)buffer, (class_4587)ms, (int)light, (boolean)false);
        ms.method_22909();
    }

    public boolean shouldRenderOffScreen(FuelTankBlockEntity be) {
        return be.isController();
    }
}

