/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_tracks.casing;

import com.jozufozu.flywheel.api.Material;
import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.railwayteam.railways.Railways;
import com.railwayteam.railways.content.custom_tracks.casing.RuntimeFakePartialModel;
import com.railwayteam.railways.content.custom_tracks.casing.SpriteCopyingBakedModel;
import com.railwayteam.railways.mixin_interfaces.IHasTrackCasing;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.simibubi.create.content.trains.track.BezierConnection;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1087;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2482;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_761;

public abstract class CasingRenderUtils {
    private static final HashMap<Pair<PartialModel, class_2482>, PartialModel> reTexturedModels = new HashMap();

    public static void clearModelCache() {
        reTexturedModels.clear();
        CRBlockPartials.registerCasingSpecs();
        Backend.reloadWorldRenderers();
    }

    public static PartialModel reTexture(PartialModel model, class_2482 block) {
        Pair key = Pair.of((Object)model, (Object)block);
        if (!reTexturedModels.containsKey(key)) {
            class_1087 slabModel = class_310.method_1551().method_1554().method_4743().method_3335(block.method_9564());
            SpriteCopyingBakedModel texturedCasing = new SpriteCopyingBakedModel(model.get(), slabModel);
            RuntimeFakePartialModel texturedPartial = RuntimeFakePartialModel.make(Railways.asResource("runtime_casing"), texturedCasing);
            reTexturedModels.put((Pair<PartialModel, class_2482>)key, texturedPartial);
            return texturedPartial;
        }
        return reTexturedModels.get(key);
    }

    public static void renderBezierCasings(class_4587 ms, class_1937 level, PartialModel texturedPartial, class_2680 state, class_4588 vb, BezierConnection bc) {
        double shiftDown;
        int heightDiff = Math.abs(((class_2338)bc.tePositions.get(false)).method_10264() - ((class_2338)bc.tePositions.get(true)).method_10264());
        double d = shiftDown = ((IHasTrackCasing)bc).isAlternate() && heightDiff > 0 ? -0.25 : 0.0;
        if ((double)heightDiff / bc.getLength() <= 0.13333333333333333) {
            for (class_243 pos : CasingRenderUtils.casingPositions(bc)) {
                ms.method_22903();
                class_2338 tePosition = (class_2338)bc.tePositions.getFirst();
                int light = class_761.method_23794((class_1920)level, (class_2338)new class_2338(pos).method_10081((class_2382)tePosition));
                ((SuperByteBuffer)CachedBufferer.partial((PartialModel)texturedPartial, (class_2680)state).translate(pos.field_1352, pos.field_1351, pos.field_1350).translate(0.0, shiftDown, 0.0).scale(1.001f)).light(light).renderInto(ms, vb);
                ms.method_22909();
            }
        } else {
            ms.method_22903();
            class_2338 tePosition = (class_2338)bc.tePositions.getFirst();
            BezierConnection.SegmentAngles[] segments = bc.getBakedSegments();
            TransformStack.cast((class_4587)ms).nudge((int)tePosition.method_10063());
            for (int i = 1; i < segments.length; ++i) {
                if (i % 2 == 0) continue;
                BezierConnection.SegmentAngles segment = segments[i];
                int light = class_761.method_23794((class_1920)level, (class_2338)segment.lightPosition.method_10081((class_2382)tePosition));
                class_1159 pose = segment.tieTransform.method_23761().method_22673();
                pose.method_22671(new class_1160(0.0f, (float)(i % 4) * 0.001f, 0.0f));
                ((SuperByteBuffer)CachedBufferer.partial((PartialModel)texturedPartial, (class_2680)state).mulPose(pose).mulNormal(segment.tieTransform.method_23762()).translate(0.0, shiftDown, 0.0).scale(1.02f)).light(light).renderInto(ms, vb);
                TrackMaterial.TrackType trackType = bc.getMaterial().trackType;
                if (trackType == CRTrackMaterials.CRTrackType.WIDE_GAUGE) {
                    for (boolean first : Iterate.trueAndFalse) {
                        for (boolean inner : Iterate.trueAndFalse) {
                            class_4587.class_4665 transform = (class_4587.class_4665)segment.railTransforms.get(first);
                            class_1159 pose2 = transform.method_23761().method_22673();
                            pose2.method_22671(new class_1160(0.0f, (float)(i % 4) * 0.001f, 0.0f));
                            CachedBufferer.partial((PartialModel)texturedPartial, (class_2680)state).mulPose(pose2).mulNormal(transform.method_23762()).translate((first ? -0.953125 : -0.03125) + (double)(inner ? 0 : (first ? 1 : -1)), shiftDown, 0.0).light(light).renderInto(ms, vb);
                        }
                    }
                    continue;
                }
                for (boolean first : Iterate.trueAndFalse) {
                    class_4587.class_4665 transform = (class_4587.class_4665)segment.railTransforms.get(first);
                    class_1159 pose2 = transform.method_23761().method_22673();
                    pose2.method_22671(new class_1160(0.0f, (float)(i % 4) * 0.001f, 0.0f));
                    CachedBufferer.partial((PartialModel)texturedPartial, (class_2680)state).mulPose(pose2).mulNormal(transform.method_23762()).translate(-0.5 + (trackType == CRTrackMaterials.CRTrackType.NARROW_GAUGE ? (first ? 0.5 : -0.5) : 0.0), shiftDown, 0.0).light(light).renderInto(ms, vb);
                }
            }
            ms.method_22909();
        }
    }

    public static List<class_243> casingPositions(BezierConnection bc) {
        ArrayList<class_243> positions = new ArrayList<class_243>();
        ArrayList<int[]> takenPositions = new ArrayList<int[]>();
        for (BezierConnection.Segment segment : bc) {
            double factor = 1.3;
            if (bc.getMaterial().trackType == CRTrackMaterials.CRTrackType.WIDE_GAUGE) {
                factor += 0.5;
            } else if (bc.getMaterial().trackType == CRTrackMaterials.CRTrackType.NARROW_GAUGE) {
                factor -= 0.4375;
            }
            class_243 pos1 = segment.position.method_1019(segment.normal.method_1021(factor));
            class_243 pos2 = segment.position.method_1019(segment.normal.method_1021(-factor));
            float steps = 4.0f;
            class_243 stepVec = pos1.method_1035(pos2).method_1021((double)(1.0f / steps));
            class_243 curPos = pos1;
            int i = 0;
            while ((float)i <= steps) {
                int x = (int)Math.floor(curPos.field_1352);
                int z = (int)Math.floor(curPos.field_1350);
                if (takenPositions.stream().noneMatch(pos -> pos[0] == x && pos[1] == z)) {
                    takenPositions.add(new int[]{x, z});
                    positions.add(new class_243((double)x, curPos.field_1351 - 0.1875, (double)z));
                }
                curPos = curPos.method_1019(stepVec);
                ++i;
            }
        }
        return positions.stream().toList();
    }

    public static ModelData makeCasingInstance(PartialModel baseModel, class_2482 slabBlock, Material<ModelData> mat) {
        PartialModel texturedPartial = CasingRenderUtils.reTexture(baseModel, slabBlock);
        return (ModelData)mat.getModel(texturedPartial, slabBlock.method_9564()).createInstance();
    }
}

