/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.base.data.recipe;

import com.railwayteam.railways.base.data.recipe.RailwaysRecipeProvider;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import net.minecraft.class_1767;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DyedRecipeList
implements Iterable<RailwaysRecipeProvider.GeneratedRecipe> {
    private static final int COLOR_AMOUNT = class_1767.values().length;
    protected final RailwaysRecipeProvider.GeneratedRecipe[] values = new RailwaysRecipeProvider.GeneratedRecipe[this.getColorCount()];

    public DyedRecipeList(Function<@NotNull class_1767, RailwaysRecipeProvider.GeneratedRecipe> filler) {
        for (class_1767 color : class_1767.values()) {
            this.values[color.ordinal()] = filler.apply(color);
        }
    }

    protected int getColorCount() {
        return COLOR_AMOUNT;
    }

    public RailwaysRecipeProvider.GeneratedRecipe get(@NotNull class_1767 color) {
        return this.values[color.ordinal()];
    }

    public RailwaysRecipeProvider.GeneratedRecipe[] toArray() {
        return Arrays.copyOf(this.values, this.values.length);
    }

    @Override
    public Iterator<RailwaysRecipeProvider.GeneratedRecipe> iterator() {
        return new Iterator<RailwaysRecipeProvider.GeneratedRecipe>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < DyedRecipeList.this.values.length;
            }

            @Override
            public RailwaysRecipeProvider.GeneratedRecipe next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return DyedRecipeList.this.values[this.index++];
            }
        };
    }

    public static class NullableDyedRecipeList
    extends DyedRecipeList {
        public NullableDyedRecipeList(Function<@Nullable class_1767, RailwaysRecipeProvider.GeneratedRecipe> filler) {
            super(filler);
            this.values[this.values.length - 1] = filler.apply(null);
        }

        @Override
        protected int getColorCount() {
            return COLOR_AMOUNT + 1;
        }

        @Override
        public RailwaysRecipeProvider.GeneratedRecipe get(@Nullable class_1767 color) {
            if (color == null) {
                return this.values[this.values.length - 1];
            }
            return super.get(color);
        }
    }
}

