/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.brewinandchewin.common.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.nhoryzon.mc.farmersdelight.util.RecipeMatcher;
import dev.sterner.brewinandchewin.common.registry.BCRecipeTypes;
import java.util.ArrayList;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;

public class KegRecipe
implements class_1860<class_1263> {
    public static final int INPUT_SLOTS = 4;
    private final class_2960 id;
    private final String group;
    public final class_2371<class_1856> ingredientList;
    private final class_1856 fluidItem;
    public final class_1799 output;
    private final class_1799 container;
    private final float experience;
    private final int fermentTime;
    private final int temperature;

    public KegRecipe(class_2960 id, String group, class_2371<class_1856> ingredientList, class_1856 fluidItem, class_1799 output, class_1799 container, float experience, int fermentTime, int temperature) {
        this.id = id;
        this.group = group;
        this.ingredientList = ingredientList;
        this.output = output;
        this.temperature = temperature;
        this.container = !container.method_7960() ? container : (output.method_7909().method_7858() != null ? new class_1799((class_1935)output.method_7909().method_7858()) : class_1799.field_8037);
        this.fluidItem = fluidItem;
        this.experience = experience;
        this.fermentTime = fermentTime;
    }

    public class_2371<class_1856> method_8117() {
        class_2371 ingredients = class_2371.method_10211();
        ingredients.addAll(this.ingredientList);
        if (!this.fluidItem.method_8103()) {
            ingredients.add((Object)this.fluidItem);
        }
        return ingredients;
    }

    public boolean method_8115(class_1263 inventory, class_1937 world) {
        ArrayList<class_1799> inputs = new ArrayList<class_1799>();
        int i = 0;
        for (int j = 0; j < 4; ++j) {
            class_1799 itemstack = inventory.method_5438(j);
            if (itemstack.method_7960()) continue;
            ++i;
            inputs.add(itemstack);
        }
        if (this.fluidItem != null) {
            return i == this.ingredientList.size() && RecipeMatcher.findMatches(inputs, this.ingredientList) != null && this.fluidItem.method_8093(inventory.method_5438(4));
        }
        return i == this.ingredientList.size() && RecipeMatcher.findMatches(inputs, this.ingredientList) != null;
    }

    public class_1799 method_8116(class_1263 inventory) {
        return this.output.method_7972();
    }

    public boolean method_8113(int width, int height) {
        return width * height >= this.ingredientList.size();
    }

    public class_1799 method_8110() {
        return this.output;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public class_1865<?> method_8119() {
        return BCRecipeTypes.KEG_RECIPE_SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return BCRecipeTypes.KEG_RECIPE_TYPE;
    }

    public class_1799 getOutputContainer() {
        return this.container;
    }

    public class_1856 getFluidItem() {
        return this.fluidItem;
    }

    public float getExperience() {
        return this.experience;
    }

    public int getFermentTime() {
        return this.fermentTime;
    }

    public int getTemperature() {
        return this.temperature;
    }

    public static class Serializer
    implements class_1865<KegRecipe> {
        public KegRecipe read(class_2960 id, JsonObject json) {
            String groupIn = class_3518.method_15253((JsonObject)json, (String)"group", (String)"");
            class_2371<class_1856> inputItemsIn = Serializer.readIngredients(class_3518.method_15261((JsonObject)json, (String)"ingredients"));
            if (inputItemsIn.isEmpty()) {
                throw new JsonParseException("No ingredients for cooking recipe");
            }
            if (inputItemsIn.size() > 4) {
                throw new JsonParseException("Too many ingredients for cooking recipe! The max is 4");
            }
            JsonObject jsonResult = class_3518.method_15296((JsonObject)json, (String)"result");
            class_1799 outputIn = new class_1799((class_1935)class_3518.method_15288((JsonObject)jsonResult, (String)"item"), class_3518.method_15282((JsonObject)jsonResult, (String)"count", (int)1));
            class_1856 fluidItemIn = class_1856.field_9017;
            if (class_3518.method_15294((JsonObject)json, (String)"fluiditem")) {
                JsonObject jsonContainer = class_3518.method_15296((JsonObject)json, (String)"fluiditem");
                fluidItemIn = class_1856.method_8102((JsonElement)jsonContainer);
            }
            class_1799 container = class_1799.field_8037;
            if (class_3518.method_15294((JsonObject)json, (String)"container")) {
                JsonObject jsonContainer = class_3518.method_15296((JsonObject)json, (String)"container");
                container = new class_1799((class_1935)class_3518.method_15288((JsonObject)jsonContainer, (String)"item"), class_3518.method_15282((JsonObject)jsonContainer, (String)"count", (int)1));
            }
            float experienceIn = class_3518.method_15277((JsonObject)json, (String)"experience", (float)0.0f);
            int fermentTimeIn = class_3518.method_15282((JsonObject)json, (String)"fermentingtime", (int)200);
            int temperatureIn = class_3518.method_15282((JsonObject)json, (String)"temperature", (int)3);
            return new KegRecipe(id, groupIn, inputItemsIn, fluidItemIn, outputIn, container, experienceIn, fermentTimeIn, temperatureIn);
        }

        private static class_2371<class_1856> readIngredients(JsonArray ingredientArray) {
            class_2371 defaultedList = class_2371.method_10211();
            for (int i = 0; i < ingredientArray.size(); ++i) {
                class_1856 ingredient = class_1856.method_8102((JsonElement)ingredientArray.get(i));
                if (ingredient.method_8103()) continue;
                defaultedList.add((Object)ingredient);
            }
            return defaultedList;
        }

        public KegRecipe read(class_2960 id, class_2540 buf) {
            String groupIn = buf.method_19772();
            int i = buf.method_10816();
            class_2371 inputItemsIn = class_2371.method_10213((int)i, (Object)class_1856.field_9017);
            inputItemsIn.replaceAll(ignored -> class_1856.method_8086((class_2540)buf));
            class_1856 fluidItem = class_1856.method_8086((class_2540)buf);
            class_1799 outputIn = buf.method_10819();
            class_1799 container = buf.method_10819();
            float experienceIn = buf.readFloat();
            int fermentTimeIn = buf.method_10816();
            int temperatureIn = buf.method_10816();
            return new KegRecipe(id, groupIn, (class_2371<class_1856>)inputItemsIn, fluidItem, outputIn, container, experienceIn, fermentTimeIn, temperatureIn);
        }

        public void write(class_2540 buf, KegRecipe recipe) {
            buf.method_10814(recipe.group);
            buf.method_10804(recipe.ingredientList.size());
            for (class_1856 ingredient : recipe.ingredientList) {
                ingredient.method_8088(buf);
            }
            recipe.fluidItem.method_8088(buf);
            buf.method_10793(recipe.output);
            buf.method_10793(recipe.container);
            buf.writeFloat(recipe.experience);
            buf.method_10804(recipe.fermentTime);
            buf.method_10804(recipe.temperature);
        }
    }
}

