/*
 * Decompiled with CFR 0.152.
 */
package ca.fxco.moreculling.utils;

import ca.fxco.moreculling.api.sprite.SpriteOpacity;
import java.util.List;
import net.minecraft.class_1011;
import net.minecraft.class_1058;
import org.jetbrains.annotations.Nullable;

public class SpriteUtils {
    public static boolean doesHaveTransparency(class_1058 sprite) {
        int width = sprite.method_4578();
        int height = sprite.method_4595();
        for (int frame : sprite.method_33442().toArray()) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    if (!sprite.method_4583(frame, x, y)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean doesHaveTransparency(class_1011 nativeImage) {
        if (nativeImage.method_4318().method_4329()) {
            int width = nativeImage.method_4307();
            for (int y = 0; y < nativeImage.method_4323(); ++y) {
                for (int x = 0; x < width; ++x) {
                    if (nativeImage.method_4311(x, y) != 0) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean doesHaveTranslucency(class_1011 image, @Nullable List<class_1011> orMatch) {
        if (image.method_4318().method_4329()) {
            int width = image.method_4307();
            for (int y = 0; y < image.method_4323(); ++y) {
                for (int x = 0; x < width; ++x) {
                    if (image.method_4311(x, y) == -1) continue;
                    if (orMatch != null) {
                        boolean success = false;
                        for (class_1011 nativeImage : orMatch) {
                            if (x > nativeImage.method_4307() || y > nativeImage.method_4323() || nativeImage.method_4311(x, y) != -1) continue;
                            success = true;
                            break;
                        }
                        if (success) continue;
                        return true;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public static void printOpacity(class_1058 sprite) {
        SpriteUtils.printOpacity(null, sprite);
    }

    public static void printOpacity(@Nullable String id, class_1058 sprite) {
        class_1011 img = ((SpriteOpacity)sprite).getUnmipmappedImage();
        if (img.method_4318().method_4337()) {
            SpriteUtils.printOpacity(img);
        }
    }

    public static void printOpacity(class_1011 nativeImage) {
        if (!nativeImage.method_4318().method_4337()) {
            return;
        }
        int width = nativeImage.method_4307();
        for (int y = 0; y < nativeImage.method_4323(); ++y) {
            StringBuilder line = new StringBuilder();
            for (int x = 0; x < width; ++x) {
                line.append(String.format("%4d" + (x != width - 1 ? "," : ""), nativeImage.method_4311(x, y)));
            }
            System.out.println(line);
        }
    }
}

