/*
 * Decompiled with CFR 0.152.
 */
package com.mangomilk.design_decor.blocks.industrial_gear;

import com.mangomilk.design_decor.blocks.industrial_gear.IndustrialGearBlock;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.foundation.placement.IPlacementHelper;
import com.simibubi.create.foundation.placement.PlacementHelpers;
import com.simibubi.create.foundation.placement.PlacementOffset;
import com.simibubi.create.foundation.utility.Iterate;
import io.github.fabricators_of_create.porting_lib.item.UseFirstBehaviorItem;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_6328;

public class IndustrialGearBlockItem
extends class_1747
implements UseFirstBehaviorItem {
    boolean large;
    private final int placementHelperId;
    private final int integratedCogHelperId;

    public IndustrialGearBlockItem(IndustrialGearBlock block, class_1792.class_1793 builder) {
        super((class_2248)block, builder);
        this.large = block.isLarge;
        this.placementHelperId = PlacementHelpers.register((IPlacementHelper)(this.large ? new LargeCogHelper() : new SmallCogHelper()));
        this.integratedCogHelperId = PlacementHelpers.register((IPlacementHelper)(this.large ? new IntegratedLargeCogHelper() : new IntegratedSmallCogHelper()));
    }

    public class_1269 onItemUseFirst(class_1799 stack, class_1838 context) {
        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();
        class_2680 state = world.method_8320(pos);
        IPlacementHelper helper = PlacementHelpers.get((int)this.placementHelperId);
        class_1657 player = context.method_8036();
        class_3965 ray = new class_3965(context.method_17698(), context.method_8038(), pos, true);
        if (helper.matchesState(state) && player != null && !player.method_5715()) {
            return helper.getOffset(player, world, state, pos, ray).placeInWorld(world, (class_1747)this, player, context.method_20287(), ray);
        }
        if (this.integratedCogHelperId != -1 && (helper = PlacementHelpers.get((int)this.integratedCogHelperId)).matchesState(state) && player != null && !player.method_5715()) {
            return helper.getOffset(player, world, state, pos, ray).placeInWorld(world, (class_1747)this, player, context.method_20287(), ray);
        }
        return class_1269.field_5811;
    }

    @class_6328
    private static class LargeCogHelper
    extends DiagonalCogHelper {
        private LargeCogHelper() {
        }

        public Predicate<class_1799> getItemPredicate() {
            return ((Predicate<class_1799>)ICogWheel::isLargeCogItem).and(ICogWheel::isDedicatedCogItem);
        }

        @Override
        public PlacementOffset getOffset(class_1657 player, class_1937 world, class_2680 state, class_2338 pos, class_3965 ray) {
            if (this.hitOnShaft(state, ray)) {
                return PlacementOffset.fail();
            }
            if (ICogWheel.isLargeCog((class_2680)state)) {
                class_2350.class_2351 axis = ((IRotate)state.method_26204()).getRotationAxis(state);
                class_2350 side = (class_2350)IPlacementHelper.orderedByDistanceOnlyAxis((class_2338)pos, (class_243)ray.method_17784(), (class_2350.class_2351)axis).get(0);
                List directions = IPlacementHelper.orderedByDistanceExceptAxis((class_2338)pos, (class_243)ray.method_17784(), (class_2350.class_2351)axis);
                for (class_2350 dir : directions) {
                    class_2338 newPos = pos.method_10093(dir).method_10093(side);
                    if (!IndustrialGearBlock.isValidCogwheelPosition(true, (class_4538)world, newPos, dir.method_10166()) || !world.method_8320(newPos).method_26207().method_15800()) continue;
                    return PlacementOffset.success((class_2382)newPos, s -> (class_2680)s.method_11657((class_2769)RotatedPillarKineticBlock.AXIS, (Comparable)dir.method_10166()));
                }
                return PlacementOffset.fail();
            }
            return super.getOffset(player, world, state, pos, ray);
        }
    }

    @class_6328
    private static class SmallCogHelper
    extends DiagonalCogHelper {
        private SmallCogHelper() {
        }

        public Predicate<class_1799> getItemPredicate() {
            return ((Predicate<class_1799>)ICogWheel::isSmallCogItem).and(ICogWheel::isDedicatedCogItem);
        }

        @Override
        public PlacementOffset getOffset(class_1657 player, class_1937 world, class_2680 state, class_2338 pos, class_3965 ray) {
            if (this.hitOnShaft(state, ray)) {
                return PlacementOffset.fail();
            }
            if (!ICogWheel.isLargeCog((class_2680)state)) {
                class_2350.class_2351 axis = ((IRotate)state.method_26204()).getRotationAxis(state);
                List directions = IPlacementHelper.orderedByDistanceExceptAxis((class_2338)pos, (class_243)ray.method_17784(), (class_2350.class_2351)axis);
                for (class_2350 dir : directions) {
                    class_2338 newPos = pos.method_10093(dir);
                    if (!IndustrialGearBlock.isValidCogwheelPosition(false, (class_4538)world, newPos, axis) || !world.method_8320(newPos).method_26207().method_15800()) continue;
                    return PlacementOffset.success((class_2382)newPos, s -> (class_2680)s.method_11657((class_2769)RotatedPillarKineticBlock.AXIS, (Comparable)axis));
                }
                return PlacementOffset.fail();
            }
            return super.getOffset(player, world, state, pos, ray);
        }
    }

    @class_6328
    public static class IntegratedLargeCogHelper
    implements IPlacementHelper {
        public Predicate<class_1799> getItemPredicate() {
            return ((Predicate<class_1799>)ICogWheel::isLargeCogItem).and(ICogWheel::isDedicatedCogItem);
        }

        public Predicate<class_2680> getStatePredicate() {
            return s -> !ICogWheel.isDedicatedCogWheel((class_2248)s.method_26204()) && ICogWheel.isSmallCog((class_2680)s);
        }

        public PlacementOffset getOffset(class_1657 player, class_1937 world, class_2680 state, class_2338 pos, class_3965 ray) {
            class_2350 face = ray.method_17780();
            class_2350.class_2351 newAxis = state.method_28498(HorizontalKineticBlock.HORIZONTAL_FACING) ? ((class_2350)state.method_11654(HorizontalKineticBlock.HORIZONTAL_FACING)).method_10166() : (state.method_28498((class_2769)DirectionalKineticBlock.FACING) ? ((class_2350)state.method_11654((class_2769)DirectionalKineticBlock.FACING)).method_10166() : (state.method_28498((class_2769)RotatedPillarKineticBlock.AXIS) ? (class_2350.class_2351)state.method_11654((class_2769)RotatedPillarKineticBlock.AXIS) : class_2350.class_2351.field_11052));
            if (face.method_10166() == newAxis) {
                return PlacementOffset.fail();
            }
            List directions = IPlacementHelper.orderedByDistanceExceptAxis((class_2338)pos, (class_243)ray.method_17784(), (class_2350.class_2351)face.method_10166(), (class_2350.class_2351)newAxis);
            for (class_2350 d : directions) {
                class_2338 newPos = pos.method_10093(face).method_10093(d);
                if (!world.method_8320(newPos).method_26207().method_15800()) continue;
                if (!IndustrialGearBlock.isValidCogwheelPosition(false, (class_4538)world, newPos, newAxis)) {
                    return PlacementOffset.fail();
                }
                return PlacementOffset.success((class_2382)newPos, s -> (class_2680)s.method_11657((class_2769)IndustrialGearBlock.AXIS, (Comparable)newAxis));
            }
            return PlacementOffset.fail();
        }
    }

    @class_6328
    public static class IntegratedSmallCogHelper
    implements IPlacementHelper {
        public Predicate<class_1799> getItemPredicate() {
            return ((Predicate<class_1799>)ICogWheel::isSmallCogItem).and(ICogWheel::isDedicatedCogItem);
        }

        public Predicate<class_2680> getStatePredicate() {
            return s -> !ICogWheel.isDedicatedCogWheel((class_2248)s.method_26204()) && ICogWheel.isSmallCog((class_2680)s);
        }

        public PlacementOffset getOffset(class_1657 player, class_1937 world, class_2680 state, class_2338 pos, class_3965 ray) {
            class_2350 face = ray.method_17780();
            class_2350.class_2351 newAxis = state.method_28498(HorizontalKineticBlock.HORIZONTAL_FACING) ? ((class_2350)state.method_11654(HorizontalKineticBlock.HORIZONTAL_FACING)).method_10166() : (state.method_28498((class_2769)DirectionalKineticBlock.FACING) ? ((class_2350)state.method_11654((class_2769)DirectionalKineticBlock.FACING)).method_10166() : (state.method_28498((class_2769)RotatedPillarKineticBlock.AXIS) ? (class_2350.class_2351)state.method_11654((class_2769)RotatedPillarKineticBlock.AXIS) : class_2350.class_2351.field_11052));
            if (face.method_10166() == newAxis) {
                return PlacementOffset.fail();
            }
            List directions = IPlacementHelper.orderedByDistanceExceptAxis((class_2338)pos, (class_243)ray.method_17784(), (class_2350.class_2351)newAxis);
            for (class_2350 d : directions) {
                class_2338 newPos = pos.method_10093(d);
                if (!world.method_8320(newPos).method_26207().method_15800()) continue;
                if (!IndustrialGearBlock.isValidCogwheelPosition(false, (class_4538)world, newPos, newAxis)) {
                    return PlacementOffset.fail();
                }
                return PlacementOffset.success().at((class_2382)newPos).withTransform(s -> (class_2680)s.method_11657((class_2769)IndustrialGearBlock.AXIS, (Comparable)newAxis));
            }
            return PlacementOffset.fail();
        }
    }

    @class_6328
    public static abstract class DiagonalCogHelper
    implements IPlacementHelper {
        public Predicate<class_2680> getStatePredicate() {
            return s -> ICogWheel.isSmallCog((class_2680)s) || ICogWheel.isLargeCog((class_2680)s);
        }

        public PlacementOffset getOffset(class_1657 player, class_1937 world, class_2680 state, class_2338 pos, class_3965 ray) {
            class_2350.class_2351 axis = ((IRotate)state.method_26204()).getRotationAxis(state);
            class_2350 closest = (class_2350)IPlacementHelper.orderedByDistanceExceptAxis((class_2338)pos, (class_243)ray.method_17784(), (class_2350.class_2351)axis).get(0);
            List directions = IPlacementHelper.orderedByDistanceExceptAxis((class_2338)pos, (class_243)ray.method_17784(), (class_2350.class_2351)axis, d -> d.method_10166() != closest.method_10166());
            for (class_2350 dir : directions) {
                class_2338 newPos = pos.method_10093(dir).method_10093(closest);
                if (!world.method_8320(newPos).method_26207().method_15800() || !IndustrialGearBlock.isValidCogwheelPosition(ICogWheel.isLargeCog((class_2680)state), (class_4538)world, newPos, axis)) continue;
                return PlacementOffset.success((class_2382)newPos, s -> (class_2680)s.method_11657((class_2769)RotatedPillarKineticBlock.AXIS, (Comparable)axis));
            }
            return PlacementOffset.fail();
        }

        protected boolean hitOnShaft(class_2680 state, class_3965 ray) {
            return AllShapes.SIX_VOXEL_POLE.get(((IRotate)state.method_26204()).getRotationAxis(state)).method_1107().method_1014(0.001).method_1006(ray.method_17784().method_1020(ray.method_17784().method_1032(Iterate.axisSet)));
        }
    }
}

