/*
 * Decompiled with CFR 0.152.
 */
package com.mangomilk.design_decor.blocks.horizontal_tanks;

import com.mangomilk.design_decor.blocks.horizontal_tanks.HorizontalFluidTankBlock;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.LangBuilder;
import io.github.fabricators_of_create.porting_lib.transfer.fluid.FluidTank;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import io.github.fabricators_of_create.porting_lib.util.LazyOptional;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_124;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class HorizontalFluidTankBlockEntity
extends SmartBlockEntity
implements IMultiBlockEntityContainer.Fluid,
IHaveGoggleInformation {
    protected LazyOptional<CombinedTankWrapper> fluidCapability;
    SmartFluidTankBehaviour fluidInventory;
    protected class_2338 controller;
    protected class_2338 lastKnownPos;
    protected boolean updateConnectivity;
    protected int radius = 1;
    protected int length = 1;
    protected class_2350.class_2351 axis;

    public HorizontalFluidTankBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.fluidInventory = new SmartFluidTankBehaviour(SmartFluidTankBehaviour.INPUT, (SmartBlockEntity)this, 1, FluidTankBlockEntity.getCapacityMultiplier(), true).forbidExtraction();
        behaviours.add((BlockEntityBehaviour)this.fluidInventory);
        this.fluidCapability = LazyOptional.of(() -> {
            Storage inputCap = this.fluidInventory.getCapability();
            return new CombinedTankWrapper(new Storage[]{inputCap});
        });
    }

    protected void updateConnectivity() {
        this.updateConnectivity = false;
        if (this.field_11863.method_8608()) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        ConnectivityHandler.formMulti((class_2586)this);
    }

    public void tick() {
        super.tick();
        if (this.fluidInventory.getPrimaryHandler().getFluidAmount() > this.fluidInventory.getPrimaryHandler().getCapacity()) {
            this.fluidInventory.getPrimaryHandler().setFluid(new FluidStack(this.fluidInventory.getPrimaryHandler().getFluid(), this.fluidInventory.getPrimaryHandler().getCapacity()));
        }
        if (this.isController()) {
            this.setTankSize(1, (int)(Math.pow(this.getHeight(), 2.0) * (double)this.getWidth()));
        }
        if (this.lastKnownPos == null) {
            this.lastKnownPos = this.method_11016();
        } else if (!this.lastKnownPos.equals((Object)this.field_11867) && this.field_11867 != null) {
            this.onPositionChanged();
            return;
        }
        if (this.updateConnectivity) {
            this.updateConnectivity();
        }
    }

    public int getCapacity() {
        return (int)(8000.0 * (Math.pow(this.getHeight(), 2.0) * (double)this.getWidth()));
    }

    public class_2338 getLastKnownPos() {
        return this.lastKnownPos;
    }

    public boolean isController() {
        return this.controller == null || this.field_11867.method_10263() == this.controller.method_10263() && this.field_11867.method_10264() == this.controller.method_10264() && this.field_11867.method_10260() == this.controller.method_10260();
    }

    private void onPositionChanged() {
        this.removeController(true);
        this.lastKnownPos = this.field_11867;
    }

    public HorizontalFluidTankBlockEntity getControllerBE() {
        if (this.isController()) {
            return this;
        }
        class_2586 blockEntity = this.field_11863.method_8321(this.controller);
        if (blockEntity instanceof HorizontalFluidTankBlockEntity) {
            return (HorizontalFluidTankBlockEntity)blockEntity;
        }
        return null;
    }

    public void removeController(boolean keepContents) {
        if (this.field_11863.method_8608()) {
            return;
        }
        this.updateConnectivity = true;
        this.controller = null;
        this.radius = 1;
        this.length = 1;
        class_2680 state = this.method_11010();
        if (HorizontalFluidTankBlock.isBarrel(state)) {
            state = (class_2680)state.method_11657((class_2769)HorizontalFluidTankBlock.LARGE, (Comparable)Boolean.valueOf(false));
            this.method_10997().method_8652(this.field_11867, state, 22);
        }
        this.fluidCapability.invalidate();
        this.method_5431();
        this.sendData();
    }

    public void setController(class_2338 controller) {
        if (this.field_11863.field_9236 && !this.isVirtual()) {
            return;
        }
        if (controller.equals((Object)this.controller)) {
            return;
        }
        this.controller = controller;
        this.fluidCapability.invalidate();
        this.method_5431();
        this.sendData();
    }

    public class_2338 getController() {
        return this.isController() ? this.field_11867 : this.controller;
    }

    protected void read(class_2487 compound, boolean clientPacket) {
        boolean changeOfController;
        super.read(compound, clientPacket);
        class_2338 controllerBefore = this.controller;
        int prevSize = this.radius;
        int prevLength = this.length;
        this.updateConnectivity = compound.method_10545("Uninitialized");
        this.controller = null;
        this.lastKnownPos = null;
        if (compound.method_10545("LastKnownPos")) {
            this.lastKnownPos = class_2512.method_10691((class_2487)compound.method_10562("LastKnownPos"));
        }
        if (compound.method_10545("Controller")) {
            this.controller = class_2512.method_10691((class_2487)compound.method_10562("Controller"));
        }
        if (this.isController()) {
            this.radius = compound.method_10550("Size");
            this.length = compound.method_10550("Length");
        }
        this.fluidInventory.getPrimaryHandler().readFromNBT(compound.method_10562("inputContent"));
        boolean bl = controllerBefore == null ? this.controller != null : (changeOfController = !controllerBefore.equals((Object)this.controller));
        if (this.method_11002() && (changeOfController || prevSize != this.radius || prevLength != this.length)) {
            this.field_11863.method_16109(this.method_11016(), class_2246.field_10124.method_9564(), this.method_11010());
        }
    }

    protected void write(class_2487 compound, boolean clientPacket) {
        if (this.updateConnectivity) {
            compound.method_10556("Uninitialized", true);
        }
        if (this.lastKnownPos != null) {
            compound.method_10566("LastKnownPos", (class_2520)class_2512.method_10692((class_2338)this.lastKnownPos));
        }
        if (!this.isController()) {
            compound.method_10566("Controller", (class_2520)class_2512.method_10692((class_2338)this.controller));
        }
        if (this.isController()) {
            compound.method_10569("Size", this.radius);
            compound.method_10569("Length", this.length);
        }
        compound.method_10566("inputContent", (class_2520)this.fluidInventory.getPrimaryHandler().writeToNBT(new class_2487()));
        super.write(compound, clientPacket);
    }

    private void initCapability() {
        if (!this.isController()) {
            HorizontalFluidTankBlockEntity controllerBE = this.getControllerBE();
            if (controllerBE == null) {
                return;
            }
            controllerBE.initCapability();
            this.fluidCapability = controllerBE.fluidCapability;
            return;
        }
        this.fluidCapability = LazyOptional.of(() -> {
            Storage inputCap = this.fluidInventory.getCapability();
            return new CombinedTankWrapper(new Storage[]{inputCap});
        });
    }

    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        HorizontalFluidTankBlockEntity controllerBE = this.getControllerBE();
        LangBuilder mb = Lang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
        boolean isEmpty = true;
        for (int i = 0; i < this.fluidInventory.getTanks().length; ++i) {
            FluidTank tank = this.getTank(i);
            FluidStack fluidStack = tank.getFluid();
            if (fluidStack.isEmpty()) continue;
            Lang.fluidName((FluidStack)fluidStack).style(class_124.field_1080).forGoggles(tooltip, 1);
            Lang.builder().add(Lang.number((double)fluidStack.getAmount()).add(mb).style(class_124.field_1077)).text(class_124.field_1080, " / ").add(Lang.number((double)tank.getCapacity()).add(mb).style(class_124.field_1063)).forGoggles(tooltip, 1);
            isEmpty = false;
        }
        if (this.fluidInventory.getTanks().length > 1) {
            if (isEmpty) {
                tooltip.remove(tooltip.size() - 1);
            }
            return true;
        }
        if (!isEmpty) {
            return true;
        }
        Lang.translate((String)"gui.goggles.fluid_container.capacity", (Object[])new Object[0]).add(Lang.number((double)this.getTankSize(0)).add(mb).style(class_124.field_1077)).style(class_124.field_1063).forGoggles(tooltip, 1);
        return true;
    }

    public static int getMaxLength(int radius) {
        return radius * 3;
    }

    public void preventConnectivityUpdate() {
        this.updateConnectivity = false;
    }

    public void notifyMultiUpdated() {
        class_2680 state = this.method_11010();
        if (HorizontalFluidTankBlock.isBarrel(state)) {
            this.field_11863.method_8652(this.method_11016(), (class_2680)state.method_11657((class_2769)HorizontalFluidTankBlock.LARGE, (Comparable)Boolean.valueOf(this.radius > 2)), 6);
        }
        this.fluidCapability.invalidate();
        this.method_5431();
    }

    public class_2350.class_2351 getMainConnectionAxis() {
        return this.getMainAxisOf((class_2586)this);
    }

    public int getMaxLength(class_2350.class_2351 longAxis, int width) {
        if (longAxis == class_2350.class_2351.field_11052) {
            return this.getMaxWidth();
        }
        return HorizontalFluidTankBlockEntity.getMaxLength(width);
    }

    public void setTankSize(int tank, int blocks) {
        this.applyFluidTankSize(blocks);
    }

    public void applyFluidTankSize(int blocks) {
        this.fluidInventory.getPrimaryHandler().setCapacity((long)blocks * FluidTankBlockEntity.getCapacityMultiplier());
    }

    public int getMaxWidth() {
        return 3;
    }

    public int getHeight() {
        return this.length;
    }

    public int getWidth() {
        return this.radius;
    }

    public int getLength() {
        return this.length;
    }

    public void setHeight(int height) {
        this.length = height;
    }

    public void setWidth(int width) {
        this.radius = width;
    }
}

