/*
 * Decompiled with CFR 0.152.
 */
package com.chefsdelights.farmersrespite.common.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.github.fabricators_of_create.porting_lib.crafting.CraftingHelper;
import io.github.fabricators_of_create.porting_lib.crafting.RecipeMatcher;
import java.util.ArrayList;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import org.jetbrains.annotations.Nullable;

public class KettleRecipe
implements class_1860<class_1263> {
    public static class_3956<KettleRecipe> TYPE = class_3956.method_17726((String)"farmersrespite:brewing");
    public static final class_1865<KettleRecipe> SERIALIZER = new Serializer();
    public static final int INPUT_SLOTS = 2;
    private final class_2960 id;
    private final String group;
    private final class_2371<class_1856> inputItems;
    private final class_1799 output;
    public final class_1799 container;
    private final float experience;
    public final int brewTime;
    private final boolean needWater;

    public KettleRecipe(class_2960 id, String group, class_2371<class_1856> inputItems, class_1799 output, class_1799 container, float experience, int brewTime, boolean needWater) {
        this.id = id;
        this.group = group;
        this.inputItems = inputItems;
        this.output = output;
        this.container = !container.method_7960() ? container : (output.method_7909().method_7858() != null ? new class_1799((class_1935)output.method_7909().method_7858()) : class_1799.field_8037);
        this.experience = experience;
        this.brewTime = brewTime;
        this.needWater = needWater;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public String method_8112() {
        return this.group;
    }

    public class_2371<class_1856> method_8117() {
        return this.inputItems;
    }

    public class_1799 method_8110() {
        return this.output;
    }

    public class_1799 getOutputContainer() {
        return this.container;
    }

    public class_1799 method_8116(class_1263 inv) {
        return this.output.method_7972();
    }

    public float getExperience() {
        return this.experience;
    }

    public int getBrewTime() {
        return this.brewTime;
    }

    public boolean getNeedWater() {
        return this.needWater;
    }

    public boolean method_8115(class_1263 inv, class_1937 worldIn) {
        ArrayList<class_1799> inputs = new ArrayList<class_1799>();
        int i = 0;
        for (int j = 0; j < 2; ++j) {
            class_1799 itemstack = inv.method_5438(j);
            if (itemstack.method_7960()) continue;
            ++i;
            inputs.add(itemstack);
        }
        return i == this.inputItems.size() && RecipeMatcher.findMatches(inputs, this.inputItems) != null;
    }

    public boolean method_8113(int width, int height) {
        return width * height >= this.inputItems.size();
    }

    public class_1865<?> method_8119() {
        return SERIALIZER;
    }

    public boolean method_8118() {
        return true;
    }

    public class_3956<?> method_17716() {
        return TYPE;
    }

    private static class Serializer
    implements class_1865<KettleRecipe> {
        Serializer() {
        }

        public KettleRecipe fromJson(class_2960 recipeId, JsonObject json) {
            String groupIn = class_3518.method_15253((JsonObject)json, (String)"group", (String)"");
            class_2371<class_1856> inputItemsIn = Serializer.readIngredients(class_3518.method_15261((JsonObject)json, (String)"ingredients"));
            if (inputItemsIn.isEmpty()) {
                throw new JsonParseException("No ingredients for brewing recipe");
            }
            if (inputItemsIn.size() > 2) {
                throw new JsonParseException("Too many ingredients for brewing recipe! The max is 2");
            }
            class_1799 outputIn = CraftingHelper.getItemStack((JsonObject)class_3518.method_15296((JsonObject)json, (String)"result"), (boolean)true);
            class_1799 container = class_3518.method_15294((JsonObject)json, (String)"container") ? CraftingHelper.getItemStack((JsonObject)class_3518.method_15296((JsonObject)json, (String)"container"), (boolean)true) : class_1799.field_8037;
            float experienceIn = class_3518.method_15277((JsonObject)json, (String)"experience", (float)0.0f);
            int brewTimeIn = class_3518.method_15282((JsonObject)json, (String)"brewingtime", (int)2400);
            boolean needWaterIn = class_3518.method_15258((JsonObject)json, (String)"needWater", (boolean)true);
            return new KettleRecipe(recipeId, groupIn, inputItemsIn, outputIn, container, experienceIn, brewTimeIn, needWaterIn);
        }

        private static class_2371<class_1856> readIngredients(JsonArray ingredientArray) {
            class_2371 nonnulllist = class_2371.method_10211();
            for (int i = 0; i < ingredientArray.size(); ++i) {
                class_1856 ingredient = class_1856.method_8102((JsonElement)ingredientArray.get(i));
                if (ingredient.method_8103()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        @Nullable
        public KettleRecipe fromNetwork(class_2960 recipeId, class_2540 buffer) {
            String groupIn = buffer.method_10800(Short.MAX_VALUE);
            int i = buffer.method_10816();
            class_2371 inputItemsIn = class_2371.method_10213((int)i, (Object)class_1856.field_9017);
            for (int j = 0; j < inputItemsIn.size(); ++j) {
                inputItemsIn.set(j, (Object)class_1856.method_8086((class_2540)buffer));
            }
            class_1799 outputIn = buffer.method_10819();
            class_1799 container = buffer.method_10819();
            float experienceIn = buffer.readFloat();
            int brewTimeIn = buffer.method_10816();
            Boolean needWaterIn = buffer.readBoolean();
            return new KettleRecipe(recipeId, groupIn, (class_2371<class_1856>)inputItemsIn, outputIn, container, experienceIn, brewTimeIn, needWaterIn);
        }

        public void toNetwork(class_2540 buffer, KettleRecipe recipe) {
            buffer.method_10814(recipe.group);
            buffer.method_10804(recipe.inputItems.size());
            for (class_1856 ingredient : recipe.inputItems) {
                ingredient.method_8088(buffer);
            }
            buffer.method_10793(recipe.output);
            buffer.method_10793(recipe.container);
            buffer.writeFloat(recipe.experience);
            buffer.method_10804(recipe.brewTime);
            buffer.writeBoolean(recipe.needWater);
        }
    }
}

