/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.util;

import com.tom.storagemod.util.IInventoryLink;
import com.tom.storagemod.util.MergedStorage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_5321;

public class RemoteConnections
extends class_18 {
    private static final String CONNECTIONS_TAG = "connections";
    public static final String CHANNEL_ID = "id";
    public static final String OWNER_ID = "owner";
    public static final String PUBLIC_TAG = "public";
    public static final String DISPLAY_NAME = "name";
    private static final String ID = "toms_storage_rc";
    private Map<UUID, Channel> connections = new HashMap<UUID, Channel>();

    private RemoteConnections() {
    }

    private RemoteConnections(class_2487 tag) {
        RemoteConnections.load(tag.method_10554(CONNECTIONS_TAG, 10), this.connections);
    }

    public static void load(class_2499 list, Map<UUID, Channel> connections) {
        for (int i = 0; i < list.size(); ++i) {
            class_2487 t = list.method_10602(i);
            UUID channel = t.method_25926(CHANNEL_ID);
            connections.put(channel, new Channel(t));
        }
    }

    public static RemoteConnections get(class_1937 world) {
        class_3218 sw = (class_3218)world;
        return (RemoteConnections)sw.method_8503().method_30002().method_17983().method_17924(RemoteConnections::new, RemoteConnections::new, ID);
    }

    public class_2487 method_75(class_2487 tag) {
        class_2499 list = new class_2499();
        this.connections.forEach((k, v) -> {
            class_2487 t = new class_2487();
            t.method_25927(CHANNEL_ID, k);
            v.save(t);
            list.add((Object)t);
        });
        tag.method_10566(CONNECTIONS_TAG, (class_2520)list);
        return tag;
    }

    public Channel getChannel(UUID connection) {
        return this.connections.get(connection);
    }

    public UUID makeChannel(class_2487 t, UUID owner) {
        UUID id = UUID.randomUUID();
        Object name = t.method_10558(DISPLAY_NAME);
        if (((String)name).length() > 50) {
            name = "Channel " + System.currentTimeMillis();
        }
        this.connections.put(id, new Channel(owner, t.method_10577(PUBLIC_TAG), (String)name));
        this.method_80();
        return id;
    }

    public void removeChannel(UUID id, UUID player) {
        Channel c = this.connections.get(id);
        if (c != null && c.owner.equals(player)) {
            this.connections.remove(id);
            this.method_80();
        }
    }

    public class_2499 listChannels(class_1657 pl) {
        class_2499 list = new class_2499();
        for (Map.Entry<UUID, Channel> e : this.connections.entrySet()) {
            if (!e.getValue().publicChannel && !e.getValue().owner.equals(pl.method_5667())) continue;
            class_2487 t = new class_2487();
            t.method_25927(CHANNEL_ID, e.getKey());
            e.getValue().save(t);
            list.add((Object)t);
        }
        return list;
    }

    public void editChannel(UUID id, boolean pub, UUID player) {
        Channel c = this.connections.get(id);
        if (c != null && c.owner.equals(player)) {
            c.publicChannel = pub;
            this.method_80();
        }
    }

    public void invalidateCache(UUID id) {
        Channel c = this.connections.get(id);
        if (c != null) {
            c.connectors.clear();
        }
    }

    public static class Channel {
        public Set<DimPos> connectors = new HashSet<DimPos>();
        public UUID owner;
        public boolean publicChannel;
        public String displayName;

        public Channel(UUID owner, boolean publicChannel, String displayName) {
            this.owner = owner;
            this.publicChannel = publicChannel;
            this.displayName = displayName;
        }

        private Channel(class_2487 t) {
            this(t.method_25926(RemoteConnections.OWNER_ID), t.method_10577(RemoteConnections.PUBLIC_TAG), t.method_10558(RemoteConnections.DISPLAY_NAME));
        }

        public static Channel fromTag(class_2487 t) {
            return new Channel(null, t.method_10577(RemoteConnections.PUBLIC_TAG), t.method_10558(RemoteConnections.DISPLAY_NAME));
        }

        public void register(class_3218 world, class_2338 blockPos) {
            DimPos pos = new DimPos((class_1937)world, blockPos);
            this.connectors.add(pos);
        }

        public Storage<ItemVariant> findOthers(class_3218 world, class_2338 blockPos, int lvl) {
            DimPos pos = new DimPos((class_1937)world, blockPos);
            this.connectors.add(pos);
            Iterator<DimPos> posItr = this.connectors.iterator();
            MergedStorage handler = new MergedStorage();
            while (posItr.hasNext()) {
                DimPos dimPos = posItr.next();
                if (dimPos.equals(pos)) continue;
                class_2586 te = dimPos.getTileEntity(world);
                if (te instanceof IInventoryLink) {
                    IInventoryLink link = (IInventoryLink)te;
                    Storage<ItemVariant> h = link.getInventoryFrom(world, lvl);
                    if (h == null) continue;
                    handler.add(h);
                    continue;
                }
                posItr.remove();
            }
            return handler;
        }

        public void save(class_2487 t) {
            t.method_25927(RemoteConnections.OWNER_ID, this.owner);
            t.method_10556(RemoteConnections.PUBLIC_TAG, this.publicChannel);
            t.method_10582(RemoteConnections.DISPLAY_NAME, this.displayName);
        }

        public void saveNet(class_2487 t) {
            t.method_10556(RemoteConnections.PUBLIC_TAG, this.publicChannel);
            t.method_10582(RemoteConnections.DISPLAY_NAME, this.displayName);
        }
    }

    public static class DimPos {
        public int x;
        public int y;
        public int z;
        public class_5321<class_1937> dim;

        public DimPos(class_1937 world, class_2338 pos) {
            this.x = pos.method_10263();
            this.y = pos.method_10264();
            this.z = pos.method_10260();
            this.dim = world.method_27983();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.dim == null ? 0 : this.dim.method_29177().hashCode());
            result = 31 * result + this.x;
            result = 31 * result + this.y;
            result = 31 * result + this.z;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DimPos other = (DimPos)obj;
            if (this.dim == null ? other.dim != null : !this.dim.equals(other.dim)) {
                return false;
            }
            if (this.x != other.x) {
                return false;
            }
            if (this.y != other.y) {
                return false;
            }
            return this.z == other.z;
        }

        public class_2586 getTileEntity(class_3218 world) {
            class_2338 pos;
            class_3218 dim = world.method_8503().method_3847(this.dim);
            if (!dim.method_8477(pos = new class_2338(this.x, this.y, this.z))) {
                return null;
            }
            return dim.method_8321(pos);
        }
    }
}

