/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.tile;

import com.tom.storagemod.Content;
import com.tom.storagemod.block.InventoryProxyBlock;
import com.tom.storagemod.platform.PlatformStorage;
import com.tom.storagemod.tile.PaintedBlockEntity;
import com.tom.storagemod.util.IProxy;
import com.tom.storagemod.util.InventoryWrapper;
import com.tom.storagemod.util.TickerUtil;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SidedStorageBlockEntity;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2614;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_3902;
import net.minecraft.class_3908;
import net.minecraft.class_3954;
import org.jetbrains.annotations.Nullable;

public class InventoryProxyBlockEntity
extends PaintedBlockEntity
implements TickerUtil.TickableServer,
SidedStorageBlockEntity,
class_1263,
PlatformStorage,
IProxy {
    private Storage<ItemVariant> pointedAtSt;
    private InventoryWrapper pointedAt;
    private InventoryWrapper filter;
    private boolean ignoreCount;
    private int globalCountLimit = 64;
    private boolean calling;

    public InventoryProxyBlockEntity(class_2338 pos, class_2680 state) {
        super(Content.invProxyTile.get(), pos, state);
    }

    @Override
    public void updateServer() {
        if (this.field_11863.method_8510() % 20L == 18L) {
            class_1263 inv;
            class_2680 state = this.field_11863.method_8320(this.field_11867);
            class_2350 facing = (class_2350)state.method_11654((class_2769)InventoryProxyBlock.FACING);
            InventoryProxyBlock.DirectionWithNull filter = (InventoryProxyBlock.DirectionWithNull)((Object)state.method_11654(InventoryProxyBlock.FILTER_FACING));
            class_2586 te = this.field_11863.method_8321(this.field_11867.method_10093(facing));
            if (te != null && !(te instanceof InventoryProxyBlockEntity)) {
                this.pointedAtSt = (Storage)ItemStorage.SIDED.find(this.field_11863, this.field_11867.method_10093(facing), (Object)facing.method_10153());
                inv = class_2614.method_11250((class_1937)this.field_11863, (class_2338)this.field_11867.method_10093(facing));
                this.pointedAt = inv != null ? new InventoryWrapper(inv, facing.method_10153()) : null;
            } else {
                this.pointedAtSt = null;
                this.pointedAt = null;
            }
            this.ignoreCount = false;
            this.globalCountLimit = 64;
            if (filter != InventoryProxyBlock.DirectionWithNull.NULL) {
                te = this.field_11863.method_8321(this.field_11867.method_10093(filter.getDir()));
                if (te != null && !(te instanceof InventoryProxyBlockEntity) && (inv = InventoryProxyBlockEntity.getInventoryAt(this.field_11863, this.field_11867.method_10093(filter.getDir()))) != null) {
                    this.filter = new InventoryWrapper(inv, filter.getDir().method_10153());
                    if (te instanceof class_3908) {
                        String[] sp;
                        block8: for (String string : sp = ((class_3908)te).method_5476().getString().split(",")) {
                            String[] sp2 = string.split("=");
                            String key = sp2[0];
                            String value = sp2.length > 1 ? sp2[1] : "";
                            switch (key) {
                                case "ignoreSize": {
                                    this.ignoreCount = true;
                                    continue block8;
                                }
                                case "maxCount": {
                                    if (value.isEmpty()) continue block8;
                                    this.globalCountLimit = this.parseInt(value, 64);
                                    continue block8;
                                }
                            }
                        }
                    }
                }
            } else {
                this.filter = null;
            }
            if (this.filter != null) {
                this.pointedAtSt = InventoryStorage.of((class_1263)this, (class_2350)class_2350.field_11033);
            }
            this.field_11863.method_8455(this.field_11867, this.method_11010().method_26204());
        }
    }

    @Override
    public Storage<ItemVariant> get() {
        return this.pointedAtSt;
    }

    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        if (this.pointedAtSt == null) {
            return 0L;
        }
        return this.pointedAtSt.insert((Object)resource, maxAmount, transaction);
    }

    public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        if (this.pointedAtSt == null) {
            return 0L;
        }
        return this.pointedAtSt.extract((Object)resource, maxAmount, transaction);
    }

    public Iterator<StorageView<ItemVariant>> iterator() {
        if (this.pointedAtSt == null) {
            return Collections.emptyIterator();
        }
        return this.pointedAtSt.iterator();
    }

    @Nullable
    public StorageView<ItemVariant> exactView(ItemVariant resource) {
        if (this.pointedAtSt == null) {
            return null;
        }
        return this.pointedAtSt.exactView((Object)resource);
    }

    @Nullable
    public Storage<ItemVariant> getItemStorage(class_2350 side) {
        class_2680 state = this.field_11863.method_8320(this.field_11867);
        class_2350 facing = (class_2350)state.method_11654((class_2769)InventoryProxyBlock.FACING);
        return side == facing ? null : this;
    }

    private int parseInt(String value, int def) {
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            return def;
        }
    }

    public <R> R call(Function<InventoryWrapper, R> func, Predicate<InventoryWrapper> accessCheck, R def) {
        if (this.calling) {
            return def;
        }
        this.calling = true;
        if (this.pointedAt != null && accessCheck.test(this.pointedAt)) {
            R r = func.apply(this.pointedAt);
            this.calling = false;
            return r;
        }
        this.calling = false;
        return def;
    }

    public void method_5448() {
    }

    public int method_5439() {
        return this.call(InventoryWrapper::size, i -> true, 0);
    }

    public boolean method_5442() {
        return this.call(InventoryWrapper::isEmpty, i -> true, true);
    }

    public class_1799 method_5438(int paramInt) {
        return this.call(i -> i.getStack(paramInt), i -> this.checkFilter((InventoryWrapper)i, paramInt, null), class_1799.field_8037);
    }

    public class_1799 method_5434(int paramInt1, int paramInt2) {
        return this.call(i -> i.removeStack(paramInt1, paramInt2), i -> this.checkFilter((InventoryWrapper)i, paramInt1, null), class_1799.field_8037);
    }

    public class_1799 method_5441(int paramInt) {
        return this.call(i -> i.removeStack(paramInt), i -> this.checkFilter((InventoryWrapper)i, paramInt, null), class_1799.field_8037);
    }

    public void method_5447(int paramInt, class_1799 paramItemStack) {
        this.call(i -> {
            i.setStack(paramInt, paramItemStack);
            return class_3902.field_17274;
        }, i -> true, class_3902.field_17274);
    }

    public boolean method_5437(int slot, class_1799 stack) {
        return this.call(i -> i.isValid(slot, stack, null), i -> this.checkFilter((InventoryWrapper)i, slot, stack), false);
    }

    private boolean checkFilter(InventoryWrapper w, int slot, class_1799 stack) {
        if (this.filter != null && this.filter.size() > slot) {
            class_1799 fstack = this.filter.getStack(slot);
            if (fstack.method_7960()) {
                return true;
            }
            if (stack == null) {
                stack = w.getStack(slot);
                return class_1799.method_7984((class_1799)stack, (class_1799)fstack) && class_1799.method_7975((class_1799)stack, (class_1799)fstack);
            }
            if (class_1799.method_7984((class_1799)stack, (class_1799)fstack) && class_1799.method_7975((class_1799)stack, (class_1799)fstack)) {
                if (this.ignoreCount) {
                    return true;
                }
                int count = w.getStack(slot).method_7947();
                if (count < fstack.method_7947()) {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public boolean method_5443(class_1657 paramPlayerEntity) {
        return false;
    }

    public int method_5444() {
        return this.filter == null ? this.call(InventoryWrapper::getMaxCountPerStack, i -> true, 0) : this.globalCountLimit;
    }

    public int getComparatorOutput() {
        return this.call(inventory -> {
            if (this.filter == null) {
                return class_1703.method_7618((class_1263)inventory.getInventory());
            }
            int i = 0;
            float f = 0.0f;
            int fsize = this.filter.size();
            for (int j = 0; j < inventory.size(); ++j) {
                class_1799 fstack;
                class_1799 itemStack = inventory.getStack(j);
                class_1799 class_17992 = fstack = fsize > j ? this.filter.getStack(j) : class_1799.field_8037;
                if (itemStack.method_7960() || !fstack.method_7960() && (!class_1799.method_7984((class_1799)itemStack, (class_1799)fstack) || !class_1799.method_7975((class_1799)itemStack, (class_1799)fstack))) continue;
                f += (float)(itemStack.method_7947() / Math.min(this.ignoreCount || fstack.method_7960() ? this.globalCountLimit : fstack.method_7947(), itemStack.method_7914()));
                ++i;
            }
            return class_3532.method_15375((float)((f /= (float)inventory.size()) * 14.0f)) + (i > 0 ? 1 : 0);
        }, i -> true, 0);
    }

    public static class_1263 getInventoryAt(class_1937 world, class_2338 blockPos) {
        class_2586 blockEntity;
        class_1278 inventory = null;
        class_2680 blockState = world.method_8320(blockPos);
        class_2248 block = blockState.method_26204();
        if (block instanceof class_3954) {
            inventory = ((class_3954)block).method_17680(blockState, (class_1936)world, blockPos);
        } else if (blockState.method_31709() && (blockEntity = world.method_8321(blockPos)) instanceof class_1263 && (inventory = (class_1263)blockEntity) instanceof class_2595 && block instanceof class_2281) {
            inventory = class_2281.method_17458((class_2281)((class_2281)block), (class_2680)blockState, (class_1937)world, (class_2338)blockPos, (boolean)true);
        }
        return inventory;
    }
}

