/*
 * Decompiled with CFR 0.152.
 */
package me.thegiggitybyte.sleepwarp.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;

public class JsonConfiguration {
    private static final JsonConfiguration DEFAULT_INSTANCE;
    private static final JsonConfiguration USER_INSTANCE;
    private JsonObject jsonObject;
    private Path filePath;

    public static JsonConfiguration getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static JsonConfiguration getUserInstance() {
        return USER_INSTANCE;
    }

    public JsonPrimitive getValue(String key) {
        JsonElement jsonValue = this.jsonObject.get(key);
        if (jsonValue != null) {
            return jsonValue.getAsJsonPrimitive();
        }
        throw new AssertionError((Object)"Key does not exist");
    }

    public Set<String> getKeys() {
        return this.jsonObject.keySet();
    }

    public boolean hasKey(String key) {
        return this.jsonObject.has(key);
    }

    public void setValue(String key, Number value) {
        this.setValue(key, new JsonPrimitive(value));
    }

    public void setValue(String key, String value) {
        this.setValue(key, new JsonPrimitive(value));
    }

    public void setValue(String key, boolean value) {
        this.setValue(key, new JsonPrimitive(Boolean.valueOf(value)));
    }

    private void setValue(String key, JsonPrimitive value) {
        this.jsonObject.add(key, (JsonElement)value);
    }

    private void validateJsonStructure() {
        for (Map.Entry entry : JsonConfiguration.DEFAULT_INSTANCE.jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            if (this.jsonObject.has(key) && this.jsonObject.get(key).isJsonPrimitive()) continue;
            this.jsonObject.add(key, value);
        }
    }

    public void writePendingChanges() {
        if (this.filePath == null) {
            throw new AssertionError((Object)"Configuration file path null.");
        }
        try (OutputStream fileStream = Files.newOutputStream(this.filePath, new OpenOption[0]);){
            StringWriter stringWriter = new StringWriter();
            JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
            jsonWriter.setLenient(true);
            jsonWriter.setIndent("  ");
            this.validateJsonStructure();
            Streams.write((JsonElement)this.jsonObject, (JsonWriter)jsonWriter);
            fileStream.write(stringWriter.toString().getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        JsonObject defaultJson = new JsonObject();
        defaultJson.addProperty("max_ticks_added", (Number)40);
        defaultJson.addProperty("player_multiplier", (Number)0.6);
        defaultJson.addProperty("action_bar_messages", Boolean.valueOf(true));
        defaultJson.addProperty("use_sleep_percentage", Boolean.valueOf(false));
        defaultJson.addProperty("tick_block_entities", Boolean.valueOf(true));
        defaultJson.addProperty("tick_random_block", Boolean.valueOf(true));
        defaultJson.addProperty("tick_snow_accumulation", Boolean.valueOf(true));
        defaultJson.addProperty("tick_ice_freezing", Boolean.valueOf(true));
        defaultJson.addProperty("tick_lightning", Boolean.valueOf(true));
        defaultJson.addProperty("tick_monsters", Boolean.valueOf(false));
        defaultJson.addProperty("tick_animals", Boolean.valueOf(false));
        defaultJson.addProperty("monster_tick_multiplier", (Number)0.25);
        defaultJson.addProperty("animal_tick_multiplier", (Number)0.25);
        DEFAULT_INSTANCE = new JsonConfiguration();
        JsonConfiguration.DEFAULT_INSTANCE.jsonObject = defaultJson;
        String environment = FabricLoader.getInstance().getEnvironmentType().toString().toLowerCase();
        Path filePath = FabricLoader.getInstance().getConfigDir().normalize().toAbsolutePath().resolveSibling("config/sleepwarp-" + environment + ".json");
        USER_INSTANCE = new JsonConfiguration();
        JsonConfiguration.USER_INSTANCE.filePath = filePath;
        try {
            if (Files.exists(filePath, new LinkOption[0])) {
                String jsonString = Files.readString(filePath);
                if (!jsonString.isEmpty()) {
                    JsonConfiguration.USER_INSTANCE.jsonObject = JsonParser.parseString((String)jsonString).getAsJsonObject();
                }
            } else {
                JsonConfiguration.USER_INSTANCE.jsonObject = new JsonObject();
            }
            USER_INSTANCE.validateJsonStructure();
            USER_INSTANCE.writePendingChanges();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

