/*
 * Decompiled with CFR 0.152.
 */
package me.thegiggitybyte.sleepwarp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import me.thegiggitybyte.sleepwarp.config.JsonConfiguration;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1429;
import net.minecraft.class_1506;
import net.minecraft.class_1538;
import net.minecraft.class_1588;
import net.minecraft.class_1923;
import net.minecraft.class_1928;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2488;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2761;
import net.minecraft.class_2769;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2902;
import net.minecraft.class_3193;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3898;
import net.minecraft.class_4538;
import net.minecraft.class_5250;
import net.minecraft.class_5562;
import net.minecraft.class_5819;

public class WarpDrive {
    private static final int DAY_LENGTH_TICKS = 24000;
    private static final ExecutorService TICK_EXECUTOR = Executors.newSingleThreadExecutor();
    private static final ExecutorService RANDOM_TICK_EXECUTOR = Executors.newSingleThreadExecutor();
    private static final ExecutorService MOB_TICK_EXECUTOR = Executors.newSingleThreadExecutor();

    static void engage(class_3218 world) {
        int tickCount;
        int percentRequired;
        int minimumSleeping;
        int totalPlayers = world.method_18456().size();
        long sleepingPlayers = world.method_18456().stream().filter(player -> player.method_7276()).count();
        if (sleepingPlayers == 0L) {
            return;
        }
        if (JsonConfiguration.getUserInstance().getValue("use_sleep_percentage").getAsBoolean() && sleepingPlayers < (long)(minimumSleeping = Math.max(1, totalPlayers * (percentRequired = world.method_8450().method_8356(class_1928.field_28357)) / 100))) {
            return;
        }
        int maxTicksAdded = Math.max(10, JsonConfiguration.getUserInstance().getValue("max_ticks_added").getAsInt());
        double playerMultiplier = Math.max(0.05, Math.min(1.0, JsonConfiguration.getUserInstance().getValue("player_multiplier").getAsDouble()));
        long worldTime = world.method_8532() % (long)DAY_LENGTH_TICKS;
        if (worldTime + (long)maxTicksAdded < (long)DAY_LENGTH_TICKS) {
            if (totalPlayers == 1) {
                tickCount = maxTicksAdded;
            } else {
                double sleepingRatio = (double)sleepingPlayers / (double)totalPlayers;
                double scaledRatio = sleepingRatio * playerMultiplier;
                double tickMultiplier = scaledRatio / (scaledRatio * 2.0 - playerMultiplier - sleepingRatio + 1.0);
                tickCount = Math.toIntExact(Math.round((double)maxTicksAdded * tickMultiplier));
            }
        } else {
            tickCount = Math.toIntExact((long)DAY_LENGTH_TICKS % worldTime);
        }
        for (int tick = 0; tick < tickCount; ++tick) {
            world.method_39501();
            world.method_8533();
            world.method_29203();
        }
        boolean doDaylightCycle = world.field_24456.method_146().method_8355(class_1928.field_19396);
        class_2761 packet = new class_2761(world.method_8510(), world.method_8532(), doDaylightCycle);
        world.method_8503().method_3760().method_14589((class_2596)packet, world.method_27983());
        long currentWorldTime = world.method_8532() % (long)DAY_LENGTH_TICKS;
        if (currentWorldTime == 0L) {
            if (world.method_8419()) {
                world.method_14195();
            }
            world.method_23660();
        } else {
            WarpDrive.tickWorld(world, tickCount);
        }
        if (!JsonConfiguration.getUserInstance().getValue("action_bar_messages").getAsBoolean()) {
            return;
        }
        class_5250 actionBarText = class_2561.method_43473().method_27692(class_124.field_1068);
        if (currentWorldTime > 0L) {
            long remainingTicks;
            long l = remainingTicks = world.method_8546() ? (long)world.field_24456.method_145() : (long)DAY_LENGTH_TICKS - currentWorldTime;
            if (remainingTicks > 0L) {
                if (totalPlayers > 1) {
                    double actualPercentage = (double)sleepingPlayers / (double)totalPlayers;
                    double requiredPercentage = 1.0 - playerMultiplier;
                    class_124 indicatorColor = actualPercentage >= requiredPercentage ? class_124.field_1077 : class_124.field_1061;
                    String playerNoun = sleepingPlayers == 1L ? "player" : "players";
                    actionBarText.method_10852((class_2561)class_2561.method_43470((String)("\u231b " + sleepingPlayers + " ")).method_27692(indicatorColor));
                    actionBarText.method_10852((class_2561)class_2561.method_43470((String)(playerNoun + " sleeping. ")));
                } else {
                    actionBarText.method_10852((class_2561)class_2561.method_43470((String)"\u231b ").method_27692(class_124.field_1065));
                }
                long remainingSeconds = Math.round((double)remainingTicks / (double)tickCount / 20.0);
                actionBarText.method_10852((class_2561)class_2561.method_43470((String)String.valueOf(remainingSeconds))).method_27693(" seconds until ").method_27693(world.method_8546() ? "the thunderstorm passes" : "dawn");
            }
        } else {
            String currentDay = String.valueOf(world.method_8532() / (long)DAY_LENGTH_TICKS);
            actionBarText.method_27693("Day ").method_10852((class_2561)class_2561.method_43470((String)currentDay).method_27692(class_124.field_1065));
        }
        world.method_18456().forEach(player -> player.method_7353((class_2561)actionBarText, true));
    }

    static void tickWorld(class_3218 world, int tickCount) {
        boolean canTickMonsters;
        class_3898 chunkStorage = world.method_14178().field_17254;
        ArrayList<class_2818> chunks = new ArrayList<class_2818>();
        for (class_3193 chunkHolder : chunkStorage.method_17264()) {
            class_2818 chunk = chunkHolder.method_16144();
            if (chunk == null || !world.method_39998(chunk.method_12004()) || !chunkStorage.method_38783(chunk.method_12004())) continue;
            chunks.add(chunk);
        }
        boolean canTickRandomBlock = JsonConfiguration.getUserInstance().getValue("tick_random_block").getAsBoolean();
        boolean canTickBlockEntities = JsonConfiguration.getUserInstance().getValue("tick_block_entities").getAsBoolean();
        boolean canTickLightning = JsonConfiguration.getUserInstance().getValue("tick_lightning").getAsBoolean();
        class_5819 random = class_5819.method_43047();
        for (int tick = 0; tick < tickCount; ++tick) {
            Collections.shuffle(chunks);
            for (class_2818 chunk : chunks) {
                if (canTickRandomBlock) {
                    CompletableFuture.runAsync(() -> WarpDrive.tickRandomBlock(world, chunk), RANDOM_TICK_EXECUTOR);
                }
                if (canTickLightning && world.method_8419() && world.method_8546() && random.method_43048(100000) == 0) {
                    CompletableFuture.runAsync(() -> WarpDrive.tickLightning(world, chunk), TICK_EXECUTOR);
                }
                if (random.method_43048(16) != 0) continue;
                CompletableFuture.runAsync(() -> WarpDrive.tickPrecipitation(world, chunk), TICK_EXECUTOR);
            }
            if (!canTickBlockEntities) continue;
            CompletableFuture.runAsync(() -> WarpDrive.tickBlockEntities(world), TICK_EXECUTOR);
        }
        boolean canTickAnimals = JsonConfiguration.getUserInstance().getValue("tick_animals").getAsBoolean();
        if (canTickAnimals | (canTickMonsters = JsonConfiguration.getUserInstance().getValue("tick_monsters").getAsBoolean())) {
            int tick;
            ArrayList animals = new ArrayList();
            ArrayList monsters = new ArrayList();
            world.field_26934.method_31791(entity -> {
                if (entity.method_31481()) {
                    return;
                }
                if (canTickAnimals && entity instanceof class_1429) {
                    class_1429 animal = (class_1429)entity;
                    animals.add(animal);
                } else if (canTickMonsters && entity instanceof class_1588) {
                    class_1588 monster = (class_1588)entity;
                    monsters.add(monster);
                }
            });
            if (canTickAnimals) {
                double animalTickMultiplier = JsonConfiguration.getUserInstance().getValue("animal_tick_multiplier").getAsDouble();
                tick = 0;
                while ((double)tick < (double)tickCount * animalTickMultiplier) {
                    CompletableFuture.runAsync(() -> WarpDrive.tickMobs(world, animals), MOB_TICK_EXECUTOR);
                    ++tick;
                }
            }
            if (canTickMonsters) {
                double monsterTickMultiplier = JsonConfiguration.getUserInstance().getValue("monster_tick_multiplier").getAsDouble();
                tick = 0;
                while ((double)tick < (double)tickCount * monsterTickMultiplier) {
                    CompletableFuture.runAsync(() -> WarpDrive.tickMobs(world, monsters), MOB_TICK_EXECUTOR);
                    ++tick;
                }
            }
        }
    }

    private static void tickPrecipitation(class_3218 world, class_2818 chunk) {
        class_2338 randomPos = world.method_8536(chunk.method_12004().method_8326(), 0, chunk.method_12004().method_8328(), 15);
        class_2338 topBlockPos = world.method_8598(class_2902.class_2903.field_13197, randomPos);
        class_1959 biome = (class_1959)world.method_23753(topBlockPos).comp_349();
        if (JsonConfiguration.getUserInstance().getValue("tick_ice_freezing").getAsBoolean() && biome.method_8705((class_4538)world, topBlockPos.method_10074())) {
            world.method_8501(topBlockPos.method_10074(), class_2246.field_10295.method_9564());
        }
        if (world.method_8419()) {
            if (JsonConfiguration.getUserInstance().getValue("tick_snow_accumulation").getAsBoolean()) {
                WarpDrive.tickSnowAccumulation(world, biome, topBlockPos);
            }
            class_1959.class_1963 precipitation = biome.method_8694();
            class_2680 blockState = world.method_8320(topBlockPos.method_10074());
            if (precipitation == class_1959.class_1963.field_9382 && biome.method_33599(topBlockPos.method_10074())) {
                precipitation = class_1959.class_1963.field_9383;
            }
            blockState.method_26204().method_9504(blockState, (class_1937)world, topBlockPos.method_10074(), precipitation);
        }
    }

    private static void tickSnowAccumulation(class_3218 world, class_1959 biome, class_2338 blockPos) {
        if (!biome.method_8696((class_4538)world, blockPos)) {
            return;
        }
        class_2680 blockState = world.method_8320(blockPos);
        if (blockState.method_27852(class_2246.field_10477)) {
            int snowLayers = (Integer)blockState.method_11654((class_2769)class_2488.field_11518);
            if (snowLayers < 8) {
                class_2680 layerBlockState = (class_2680)blockState.method_11657((class_2769)class_2488.field_11518, (Comparable)Integer.valueOf(snowLayers + 1));
                class_2248.method_9582((class_2680)blockState, (class_2680)layerBlockState, (class_1936)world, (class_2338)blockPos);
                world.method_8501(blockPos, layerBlockState);
            }
        } else {
            world.method_8501(blockPos, class_2246.field_10477.method_9564());
        }
    }

    private static void tickMobs(class_3218 world, List<class_1308> entities) {
        Collections.shuffle(entities);
        for (class_1308 entity : entities) {
            world.method_8503().method_20493(() -> {
                if (entity.method_31481() || world.method_31430((class_1297)entity) | !world.method_37118(entity.method_24515())) {
                    return;
                }
                class_1297 entityVehicle = entity.method_5854();
                if (entityVehicle != null && (entityVehicle.method_31481() || !entityVehicle.method_5626((class_1297)entity))) {
                    entity.method_5848();
                }
                world.method_18762((class_1297)entity);
            });
        }
    }

    private static void tickBlockEntities(class_3218 world) {
        for (class_5562 tickInvoker : world.field_27082) {
            if (tickInvoker.method_31704() || !world.method_41411(tickInvoker.method_31705())) continue;
            tickInvoker.method_31703();
        }
    }

    private static void tickLightning(class_3218 world, class_2818 chunk) {
        class_1538 lightningEntity;
        class_1506 skeletonHorseEntity;
        boolean skeletonHorseSpawn;
        class_1923 chunkPos = chunk.method_12004();
        class_2338 randomPos = world.method_8536(chunkPos.method_8326(), 0, chunkPos.method_8328(), 15);
        class_2338 blockPos = world.method_18210(randomPos);
        if (!world.method_8520(blockPos)) {
            return;
        }
        boolean canSpawnMobs = world.method_8450().method_8355(class_1928.field_19390);
        double localDifficulty = (double)world.method_8404(blockPos).method_5457() * 0.01;
        boolean bl = skeletonHorseSpawn = canSpawnMobs && class_5819.method_43047().method_43058() < localDifficulty && !world.method_8320(blockPos.method_10074()).method_27852(class_2246.field_27171);
        if (skeletonHorseSpawn && (skeletonHorseEntity = (class_1506)class_1299.field_6075.method_5883((class_1937)world)) != null) {
            skeletonHorseEntity.method_6813(true);
            skeletonHorseEntity.method_5614(0);
            skeletonHorseEntity.method_5814((double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260());
            world.method_8649((class_1297)skeletonHorseEntity);
        }
        if ((lightningEntity = (class_1538)class_1299.field_6112.method_5883((class_1937)world)) != null) {
            lightningEntity.method_29495(class_243.method_24955((class_2382)blockPos));
            lightningEntity.method_29498(skeletonHorseSpawn);
            world.method_8649((class_1297)lightningEntity);
        }
    }

    private static void tickRandomBlock(class_3218 world, class_2818 chunk) {
        int tickCount = world.method_8450().method_8356(class_1928.field_19399);
        if (tickCount == 0) {
            return;
        }
        class_5819 random = class_5819.method_43047();
        int startX = chunk.method_12004().method_8326();
        int startZ = chunk.method_12004().method_8328();
        for (class_2826 chunkSection : chunk.method_12006()) {
            if (!chunkSection.method_12262()) continue;
            int startY = chunkSection.method_12259();
            for (int tick = 0; tick < tickCount; ++tick) {
                class_3610 fluidState;
                class_2338 blockPos = world.method_8536(startX, startY, startZ, 15);
                class_2680 blockState = chunkSection.method_12254(blockPos.method_10263() - startX, blockPos.method_10264() - startY, blockPos.method_10260() - startZ);
                if (blockState.method_26229()) {
                    blockState.method_26199(world, blockPos, random);
                }
                if (!(fluidState = blockState.method_26227()).method_15773()) continue;
                fluidState.method_15757((class_1937)world, blockPos, random);
            }
        }
    }
}

