/*
 * Decompiled with CFR 0.152.
 */
package me.thegiggitybyte.sleepwarp;

import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import me.thegiggitybyte.sleepwarp.config.JsonConfiguration;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class Commands {
    static void register() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            LiteralCommandNode sleepWarpCommand = dispatcher.register(class_2170.method_9247((String)"sleepwarp"));
            dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"sleep").redirect((CommandNode)sleepWarpCommand));
            LiteralCommandNode statusCommand = ((LiteralArgumentBuilder)class_2170.method_9247((String)"status").executes(Commands::executeStatusCommand)).build();
            sleepWarpCommand.addChild((CommandNode)statusCommand);
            RequiredArgumentBuilder configKeyArg = class_2170.method_9244((String)"key", (ArgumentType)StringArgumentType.word()).suggests(Commands::getConfigKeySuggestions);
            RequiredArgumentBuilder configValueArg = (RequiredArgumentBuilder)class_2170.method_9244((String)"value", (ArgumentType)StringArgumentType.greedyString()).suggests(Commands::getConfigValueSuggestions).executes(Commands::executeConfigCommand);
            LiteralCommandNode configCommand = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"config").requires(source -> source.method_9259(2))).then(configKeyArg.then((ArgumentBuilder)configValueArg))).build();
            sleepWarpCommand.addChild((CommandNode)configCommand);
        });
    }

    private static int executeStatusCommand(CommandContext<class_2168> ctx) {
        List players = ((class_2168)ctx.getSource()).method_9225().method_18456();
        int sleepingCount = 0;
        class_5250 playerText = class_2561.method_43473();
        for (class_3222 player : players) {
            playerText.method_10852((class_2561)class_2561.method_43470((String)"[").method_27692(class_124.field_1080));
            if (player.method_6113() && player.method_7297() >= 100) {
                playerText.method_10852((class_2561)class_2561.method_43470((String)"\u2714 ").method_10852(player.method_5476()).method_27692(class_124.field_1077));
                ++sleepingCount;
            } else {
                playerText.method_10852((class_2561)class_2561.method_43470((String)"\u2716 ").method_10852(player.method_5476()).method_27692(class_124.field_1061));
            }
            playerText.method_10852((class_2561)class_2561.method_43470((String)"]").method_27692(class_124.field_1080)).method_27693(" ");
        }
        class_5250 messageText = class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)String.valueOf(sleepingCount)).method_27692(class_124.field_1080)).method_27693(" players sleeping: ").method_10852((class_2561)playerText);
        ((class_2168)ctx.getSource()).method_9226((class_2561)messageText, false);
        return 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int executeConfigCommand(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        String keyString = StringArgumentType.getString(ctx, (String)"key");
        String valueString = StringArgumentType.getString(ctx, (String)"value");
        class_5250 messageText = null;
        String setValueString = "";
        if (JsonConfiguration.getDefaultInstance().hasKey(keyString)) {
            JsonPrimitive valuePrimitive = JsonConfiguration.getDefaultInstance().getValue(keyString);
            if (valuePrimitive.isString()) {
                JsonConfiguration.getUserInstance().setValue(keyString, valueString);
                setValueString = valueString;
            } else if (valuePrimitive.isBoolean()) {
                if (valueString.equals("true") | valueString.equals("false")) {
                    boolean valueBoolean = Boolean.parseBoolean(valueString);
                    JsonConfiguration.getUserInstance().setValue(keyString, valueBoolean);
                    setValueString = String.valueOf(valueBoolean);
                } else {
                    messageText = class_2561.method_43470((String)"Configuration key '").method_27693(keyString).method_27693("' expects a boolean (true or false)");
                }
            } else {
                if (!valuePrimitive.isNumber()) throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"Unhandled value type")).create();
                try {
                    int valueInt = Integer.parseInt(valueString);
                    JsonConfiguration.getUserInstance().setValue(keyString, valueInt);
                    setValueString = String.valueOf(valueInt);
                }
                catch (NumberFormatException intException) {
                    try {
                        double valueDouble = Double.parseDouble(valueString);
                        JsonConfiguration.getUserInstance().setValue(keyString, valueDouble);
                        setValueString = String.valueOf(valueDouble);
                    }
                    catch (NumberFormatException doubleException) {
                        messageText = class_2561.method_43470((String)"Configuration key '").method_27693(keyString).method_27693("' expects an integer or float number");
                    }
                }
            }
        } else {
            messageText = class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"\u2716 ").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)keyString).method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)" is an invalid configuration key.").method_27692(class_124.field_1061));
        }
        if (messageText == null) {
            JsonConfiguration.getUserInstance().writePendingChanges();
            messageText = class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"\u2714 ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)(keyString + " set to ")).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)setValueString).method_27692(class_124.field_1054));
        }
        ((class_2168)ctx.getSource()).method_9226((class_2561)messageText, false);
        return 1;
    }

    private static CompletableFuture<Suggestions> getConfigKeySuggestions(CommandContext<class_2168> ctx, SuggestionsBuilder builder) {
        for (String key : JsonConfiguration.getDefaultInstance().getKeys()) {
            builder.suggest(key, (Message)class_2561.method_43470((String)"key"));
        }
        return builder.buildFuture();
    }

    private static CompletableFuture<Suggestions> getConfigValueSuggestions(CommandContext<class_2168> ctx, SuggestionsBuilder builder) {
        String keyString = (String)ctx.getLastChild().getArgument("key", String.class);
        if (JsonConfiguration.getDefaultInstance().hasKey(keyString)) {
            String suggestion = JsonConfiguration.getUserInstance().hasKey(keyString) ? JsonConfiguration.getUserInstance().getValue(keyString).getAsString() : JsonConfiguration.getUserInstance().getValue(keyString).getAsString();
            String pendingValue = builder.getRemaining();
            if (pendingValue.length() == 0 || pendingValue.equals(suggestion)) {
                builder.suggest(suggestion, (Message)class_2561.method_43470((String)"value"));
            }
        }
        return builder.buildFuture();
    }
}

