/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client;

import java.util.Objects;
import net.fabricmc.loader.api.SemanticVersion;
import net.fabricmc.loader.api.VersionParsingException;
import net.fabricmc.loader.api.entrypoint.PreLaunchEntrypoint;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.Platform;

public class SodiumPreLaunch
implements PreLaunchEntrypoint {
    private static final Logger LOGGER = LogManager.getLogger((String)"Sodium");

    public void onPreLaunch() {
        SodiumPreLaunch.checkJemalloc();
    }

    private static void checkJemalloc() {
        if (Platform.get() == Platform.WINDOWS && SodiumPreLaunch.isVersionWithinRange("5.2.1-0-gea6b3e973b477b8061e0076bb257dbd7f3faa756", "5.0.0", "5.2.0")) {
            LOGGER.info("Trying to switch memory allocators to work around memory leaks present with Jemalloc 5.0.0 through 5.2.0 on Windows");
            if (!Objects.equals(Configuration.MEMORY_ALLOCATOR.get(), "system")) {
                Configuration.MEMORY_ALLOCATOR.set((Object)"system");
            }
        }
    }

    private static boolean isVersionWithinRange(String curStr, String minStr, String maxStr) {
        SemanticVersion max;
        SemanticVersion min;
        SemanticVersion cur;
        try {
            cur = SemanticVersion.parse((String)curStr);
            min = SemanticVersion.parse((String)minStr);
            max = SemanticVersion.parse((String)maxStr);
        }
        catch (VersionParsingException e) {
            LOGGER.warn("Unable to parse version string", (Throwable)e);
            return false;
        }
        return cur.compareTo(min) >= 0 && cur.compareTo(max) <= 0;
    }
}

